/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Rule;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;

public class Dictionary<S> {
    private final Map<Atom<?>, Entry<S, ?>> terms = new IdentityHashMap();

    public <T> NamedRule<S, T> put(Atom<T> p_335994_, Rule<S, T> p_336190_) {
        Entry $$2 = this.terms.computeIfAbsent(p_335994_, Entry::new);
        if ($$2.value != null) {
            throw new IllegalArgumentException("Trying to override rule: " + String.valueOf(p_335994_));
        }
        $$2.value = p_336190_;
        return $$2;
    }

    public <T> NamedRule<S, T> putComplex(Atom<T> p_410268_, Term<S> p_410760_, Rule.RuleAction<S, T> p_410488_) {
        return this.put(p_410268_, Rule.fromTerm(p_410760_, p_410488_));
    }

    public <T> NamedRule<S, T> put(Atom<T> p_335571_, Term<S> p_336089_, Rule.SimpleRuleAction<S, T> p_410867_) {
        return this.put(p_335571_, Rule.fromTerm(p_336089_, p_410867_));
    }

    public void checkAllBound() {
        List<Atom> $$0 = this.terms.entrySet().stream().filter(p_409764_ -> p_409764_.getValue() == null).map(Map.Entry::getKey).toList();
        if (!$$0.isEmpty()) {
            throw new IllegalStateException("Unbound names: " + String.valueOf($$0));
        }
    }

    public <T> NamedRule<S, T> getOrThrow(Atom<T> p_410765_) {
        return Objects.requireNonNull(this.terms.get(p_410765_), () -> "No rule called " + String.valueOf(p_410765_));
    }

    public <T> NamedRule<S, T> forward(Atom<T> p_409601_) {
        return this.getOrCreateEntry(p_409601_);
    }

    private <T> Entry<S, T> getOrCreateEntry(Atom<T> p_410050_) {
        return this.terms.computeIfAbsent(p_410050_, Entry::new);
    }

    public <T> Term<S> named(Atom<T> p_410244_) {
        return new Reference<S, T>(this.getOrCreateEntry(p_410244_), p_410244_);
    }

    public <T> Term<S> namedWithAlias(Atom<T> p_409625_, Atom<T> p_410453_) {
        return new Reference<S, T>(this.getOrCreateEntry(p_409625_), p_410453_);
    }

    static class Entry<S, T>
    implements NamedRule<S, T>,
    Supplier<String> {
        private final Atom<T> name;
        @Nullable
        Rule<S, T> value;

        private Entry(Atom<T> p_410058_) {
            this.name = p_410058_;
        }

        @Override
        public Atom<T> name() {
            return this.name;
        }

        @Override
        public Rule<S, T> value() {
            return Objects.requireNonNull(this.value, this);
        }

        @Override
        public String get() {
            return "Unbound rule " + String.valueOf(this.name);
        }

        @Override
        public /* synthetic */ Object get() {
            return this.get();
        }
    }

    record Reference<S, T>(Entry<S, T> ruleToParse, Atom<T> nameToStore) implements Term<S>
    {
        @Override
        public boolean parse(ParseState<S> p_409926_, Scope p_409751_, Control p_409959_) {
            T $$3 = p_409926_.parse(this.ruleToParse);
            if ($$3 == null) {
                return false;
            }
            p_409751_.put(this.nameToStore, $$3);
            return true;
        }
    }
}

