/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class SaddleEquipmentSlotFix
extends DataFix {
    private static final Set<String> ENTITIES_WITH_SADDLE_ITEM = Set.of("minecraft:horse", "minecraft:skeleton_horse", "minecraft:zombie_horse", "minecraft:donkey", "minecraft:mule", "minecraft:camel", "minecraft:llama", "minecraft:trader_llama");
    private static final Set<String> ENTITIES_WITH_SADDLE_FLAG = Set.of("minecraft:pig", "minecraft:strider");
    private static final String SADDLE_FLAG = "Saddle";
    private static final String NEW_SADDLE = "saddle";

    public SaddleEquipmentSlotFix(Schema p_397560_) {
        super(p_397560_, true);
    }

    protected TypeRewriteRule makeRule() {
        TaggedChoice.TaggedChoiceType $$0 = this.getInputSchema().findChoiceType(References.ENTITY);
        OpticFinder $$1 = DSL.typeFinder((Type)$$0);
        Type $$2 = this.getInputSchema().getType(References.ENTITY);
        Type $$3 = this.getOutputSchema().getType(References.ENTITY);
        Type<?> $$4 = ExtraDataFixUtils.patchSubType($$2, $$2, $$3);
        return this.fixTypeEverywhereTyped("SaddleEquipmentSlotFix", $$2, $$3, p_397970_ -> {
            String $$4 = p_397970_.getOptional($$1).map(Pair::getFirst).map(NamespacedSchema::ensureNamespaced).orElse("");
            Typed $$5 = ExtraDataFixUtils.cast($$4, p_397970_);
            if (ENTITIES_WITH_SADDLE_ITEM.contains($$4)) {
                return Util.writeAndReadTypedOrThrow($$5, $$3, SaddleEquipmentSlotFix::fixEntityWithSaddleItem);
            }
            if (ENTITIES_WITH_SADDLE_FLAG.contains($$4)) {
                return Util.writeAndReadTypedOrThrow($$5, $$3, SaddleEquipmentSlotFix::fixEntityWithSaddleFlag);
            }
            return ExtraDataFixUtils.cast($$3, p_397970_);
        });
    }

    private static Dynamic<?> fixEntityWithSaddleItem(Dynamic<?> p_397781_) {
        if (p_397781_.get("SaddleItem").result().isEmpty()) {
            return p_397781_;
        }
        return SaddleEquipmentSlotFix.fixDropChances(p_397781_.renameField("SaddleItem", NEW_SADDLE));
    }

    private static Dynamic<?> fixEntityWithSaddleFlag(Dynamic<?> p_397827_) {
        boolean $$1 = p_397827_.get(SADDLE_FLAG).asBoolean(false);
        p_397827_ = p_397827_.remove(SADDLE_FLAG);
        if (!$$1) {
            return p_397827_;
        }
        Dynamic $$2 = p_397827_.emptyMap().set("id", p_397827_.createString("minecraft:saddle")).set("count", p_397827_.createInt(1));
        return SaddleEquipmentSlotFix.fixDropChances(p_397827_.set(NEW_SADDLE, $$2));
    }

    private static Dynamic<?> fixDropChances(Dynamic<?> p_397439_) {
        Dynamic $$1 = p_397439_.get("drop_chances").orElseEmptyMap().set(NEW_SADDLE, p_397439_.createFloat(2.0f));
        return p_397439_.set("drop_chances", $$1);
    }
}

