/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class RemoveBlockEntityTagFix
extends DataFix {
    private final Set<String> blockEntityIdsToDrop;

    public RemoveBlockEntityTagFix(Schema p_425633_, Set<String> p_426286_) {
        super(p_425633_, true);
        this.blockEntityIdsToDrop = p_426286_;
    }

    public TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.ITEM_STACK);
        OpticFinder $$1 = $$0.findField("tag");
        OpticFinder $$2 = $$1.type().findField("BlockEntityTag");
        Type $$3 = this.getInputSchema().getType(References.ENTITY);
        OpticFinder $$4 = DSL.namedChoice((String)"minecraft:falling_block", (Type)this.getInputSchema().getChoiceType(References.ENTITY, "minecraft:falling_block"));
        OpticFinder $$5 = $$4.type().findField("TileEntityData");
        Type $$6 = this.getInputSchema().getType(References.STRUCTURE);
        OpticFinder $$7 = $$6.findField("blocks");
        OpticFinder $$8 = DSL.typeFinder((Type)((List.ListType)$$7.type()).getElement());
        OpticFinder $$9 = $$8.type().findField("nbt");
        OpticFinder $$10 = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhereTyped("ItemRemoveBlockEntityTagFix", $$0, p_426223_ -> p_426223_.updateTyped($$1, p_426122_ -> this.removeBlockEntity((Typed<?>)p_426122_, (OpticFinder<?>)$$2, (OpticFinder<String>)$$10, "BlockEntityTag"))), (TypeRewriteRule[])new TypeRewriteRule[]{this.fixTypeEverywhereTyped("FallingBlockEntityRemoveBlockEntityTagFix", $$3, p_425901_ -> p_425901_.updateTyped($$4, p_426084_ -> this.removeBlockEntity((Typed<?>)p_426084_, (OpticFinder<?>)$$5, (OpticFinder<String>)$$10, "TileEntityData"))), this.fixTypeEverywhereTyped("StructureRemoveBlockEntityTagFix", $$6, p_426300_ -> p_426300_.updateTyped($$7, p_426016_ -> p_426016_.updateTyped($$8, p_425911_ -> this.removeBlockEntity((Typed<?>)p_425911_, (OpticFinder<?>)$$9, (OpticFinder<String>)$$10, "nbt")))), this.convertUnchecked("ItemRemoveBlockEntityTagFix - update block entity type", this.getInputSchema().getType(References.BLOCK_ENTITY), this.getOutputSchema().getType(References.BLOCK_ENTITY))});
    }

    private Typed<?> removeBlockEntity(Typed<?> p_425907_, OpticFinder<?> p_425929_, OpticFinder<String> p_425693_, String p_425948_) {
        Optional $$4 = p_425907_.getOptionalTyped(p_425929_);
        if ($$4.isEmpty()) {
            return p_425907_;
        }
        String $$5 = ((Typed)$$4.get()).getOptional(p_425693_).orElse("");
        if (!this.blockEntityIdsToDrop.contains($$5)) {
            return p_425907_;
        }
        return Util.writeAndReadTypedOrThrow(p_425907_, p_425907_.getType(), p_426288_ -> p_426288_.remove(p_425948_));
    }
}

