/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.PackedBitStorage;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.References;
import org.slf4j.Logger;

public class ChunkPalettedStorageFix
extends DataFix {
    private static final int NORTH_WEST_MASK = 128;
    private static final int WEST_MASK = 64;
    private static final int SOUTH_WEST_MASK = 32;
    private static final int SOUTH_MASK = 16;
    private static final int SOUTH_EAST_MASK = 8;
    private static final int EAST_MASK = 4;
    private static final int NORTH_EAST_MASK = 2;
    private static final int NORTH_MASK = 1;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int SIZE = 4096;

    public ChunkPalettedStorageFix(Schema p_15058_, boolean p_15059_) {
        super(p_15058_, p_15059_);
    }

    public static String getName(Dynamic<?> p_15065_) {
        return p_15065_.get("Name").asString("");
    }

    public static String getProperty(Dynamic<?> p_15067_, String p_15068_) {
        return p_15067_.get("Properties").get(p_15068_).asString("");
    }

    public static int idFor(CrudeIncrementalIntIdentityHashBiMap<Dynamic<?>> p_15062_, Dynamic<?> p_15063_) {
        int $$2 = p_15062_.getId(p_15063_);
        if ($$2 == -1) {
            $$2 = p_15062_.add(p_15063_);
        }
        return $$2;
    }

    private Dynamic<?> fix(Dynamic<?> p_15093_) {
        Optional $$1 = p_15093_.get("Level").result();
        if ($$1.isPresent() && ((Dynamic)$$1.get()).get("Sections").asStreamOpt().result().isPresent()) {
            return p_15093_.set("Level", new UpgradeChunk((Dynamic)$$1.get()).write());
        }
        return p_15093_;
    }

    public TypeRewriteRule makeRule() {
        Type $$0 = this.getInputSchema().getType(References.CHUNK);
        Type $$1 = this.getOutputSchema().getType(References.CHUNK);
        return this.writeFixAndRead("ChunkPalettedStorageFix", $$0, $$1, this::fix);
    }

    public static int getSideMask(boolean p_15087_, boolean p_15088_, boolean p_15089_, boolean p_15090_) {
        int $$4 = 0;
        if (p_15089_) {
            $$4 = p_15088_ ? ($$4 |= 2) : (p_15087_ ? ($$4 |= 0x80) : ($$4 |= 1));
        } else if (p_15090_) {
            $$4 = p_15087_ ? ($$4 |= 0x20) : (p_15088_ ? ($$4 |= 8) : ($$4 |= 0x10));
        } else if (p_15088_) {
            $$4 |= 4;
        } else if (p_15087_) {
            $$4 |= 0x40;
        }
        return $$4;
    }

    static final class UpgradeChunk {
        private int sides;
        private final Section[] sections = new Section[16];
        private final Dynamic<?> level;
        private final int x;
        private final int z;
        private final Int2ObjectMap<Dynamic<?>> blockEntities = new Int2ObjectLinkedOpenHashMap(16);

        public UpgradeChunk(Dynamic<?> p_15222_) {
            this.level = p_15222_;
            this.x = p_15222_.get("xPos").asInt(0) << 4;
            this.z = p_15222_.get("zPos").asInt(0) << 4;
            p_15222_.get("TileEntities").asStreamOpt().ifSuccess(p_15241_ -> p_15241_.forEach(p_145228_ -> {
                int $$3;
                int $$1 = p_145228_.get("x").asInt(0) - this.x & 0xF;
                int $$2 = p_145228_.get("y").asInt(0);
                int $$4 = $$2 << 8 | ($$3 = p_145228_.get("z").asInt(0) - this.z & 0xF) << 4 | $$1;
                if (this.blockEntities.put($$4, p_145228_) != null) {
                    LOGGER.warn("In chunk: {}x{} found a duplicate block entity at position: [{}, {}, {}]", new Object[]{this.x, this.z, $$1, $$2, $$3});
                }
            }));
            boolean $$1 = p_15222_.get("convertedFromAlphaFormat").asBoolean(false);
            p_15222_.get("Sections").asStreamOpt().ifSuccess(p_15235_ -> p_15235_.forEach(p_145226_ -> {
                Section $$1 = new Section((Dynamic<?>)p_145226_);
                this.sides = $$1.upgrade(this.sides);
                this.sections[$$1.y] = $$1;
            }));
            for (Section $$2 : this.sections) {
                if ($$2 == null) continue;
                block30: for (Int2ObjectMap.Entry $$3 : $$2.toFix.int2ObjectEntrySet()) {
                    int $$4 = $$2.y << 12;
                    switch ($$3.getIntKey()) {
                        case 2: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$7;
                                int $$5 = (Integer)intListIterator.next();
                                Dynamic<?> $$6 = this.getBlock($$5 |= $$4);
                                if (!"minecraft:grass_block".equals(ChunkPalettedStorageFix.getName($$6)) || !"minecraft:snow".equals($$7 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative($$5, Direction.UP)))) && !"minecraft:snow_layer".equals($$7)) continue;
                                this.setBlock($$5, MappingConstants.SNOWY_GRASS);
                            }
                            continue block30;
                        }
                        case 3: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$10;
                                int $$8 = (Integer)intListIterator.next();
                                Dynamic<?> $$9 = this.getBlock($$8 |= $$4);
                                if (!"minecraft:podzol".equals(ChunkPalettedStorageFix.getName($$9)) || !"minecraft:snow".equals($$10 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative($$8, Direction.UP)))) && !"minecraft:snow_layer".equals($$10)) continue;
                                this.setBlock($$8, MappingConstants.SNOWY_PODZOL);
                            }
                            continue block30;
                        }
                        case 110: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$13;
                                int $$11 = (Integer)intListIterator.next();
                                Dynamic<?> $$12 = this.getBlock($$11 |= $$4);
                                if (!"minecraft:mycelium".equals(ChunkPalettedStorageFix.getName($$12)) || !"minecraft:snow".equals($$13 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative($$11, Direction.UP)))) && !"minecraft:snow_layer".equals($$13)) continue;
                                this.setBlock($$11, MappingConstants.SNOWY_MYCELIUM);
                            }
                            continue block30;
                        }
                        case 25: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int $$14 = (Integer)intListIterator.next();
                                Dynamic<?> $$15 = this.removeBlockEntity($$14 |= $$4);
                                if ($$15 == null) continue;
                                String $$16 = Boolean.toString($$15.get("powered").asBoolean(false)) + (byte)Math.min(Math.max($$15.get("note").asInt(0), 0), 24);
                                this.setBlock($$14, MappingConstants.NOTE_BLOCK_MAP.getOrDefault($$16, MappingConstants.NOTE_BLOCK_MAP.get("false0")));
                            }
                            continue block30;
                        }
                        case 26: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$21;
                                int $$20;
                                int $$17 = (Integer)intListIterator.next();
                                Dynamic<?> $$18 = this.getBlockEntity($$17 |= $$4);
                                Dynamic<?> $$19 = this.getBlock($$17);
                                if ($$18 == null || ($$20 = $$18.get("color").asInt(0)) == 14 || $$20 < 0 || $$20 >= 16 || !MappingConstants.BED_BLOCK_MAP.containsKey($$21 = ChunkPalettedStorageFix.getProperty($$19, "facing") + ChunkPalettedStorageFix.getProperty($$19, "occupied") + ChunkPalettedStorageFix.getProperty($$19, "part") + $$20)) continue;
                                this.setBlock($$17, MappingConstants.BED_BLOCK_MAP.get($$21));
                            }
                            continue block30;
                        }
                        case 176: 
                        case 177: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$26;
                                int $$25;
                                int $$22 = (Integer)intListIterator.next();
                                Dynamic<?> $$23 = this.getBlockEntity($$22 |= $$4);
                                Dynamic<?> $$24 = this.getBlock($$22);
                                if ($$23 == null || ($$25 = $$23.get("Base").asInt(0)) == 15 || $$25 < 0 || $$25 >= 16 || !MappingConstants.BANNER_BLOCK_MAP.containsKey($$26 = ChunkPalettedStorageFix.getProperty($$24, $$3.getIntKey() == 176 ? "rotation" : "facing") + "_" + $$25)) continue;
                                this.setBlock($$22, MappingConstants.BANNER_BLOCK_MAP.get($$26));
                            }
                            continue block30;
                        }
                        case 86: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$29;
                                int $$27 = (Integer)intListIterator.next();
                                Dynamic<?> $$28 = this.getBlock($$27 |= $$4);
                                if (!"minecraft:carved_pumpkin".equals(ChunkPalettedStorageFix.getName($$28)) || !"minecraft:grass_block".equals($$29 = ChunkPalettedStorageFix.getName(this.getBlock(UpgradeChunk.relative($$27, Direction.DOWN)))) && !"minecraft:dirt".equals($$29)) continue;
                                this.setBlock($$27, MappingConstants.PUMPKIN);
                            }
                            continue block30;
                        }
                        case 140: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                int $$30 = (Integer)intListIterator.next();
                                Dynamic<?> $$31 = this.removeBlockEntity($$30 |= $$4);
                                if ($$31 == null) continue;
                                String $$32 = $$31.get("Item").asString("") + $$31.get("Data").asInt(0);
                                this.setBlock($$30, MappingConstants.FLOWER_POT_MAP.getOrDefault($$32, MappingConstants.FLOWER_POT_MAP.get("minecraft:air0")));
                            }
                            continue block30;
                        }
                        case 144: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$38;
                                int $$33 = (Integer)intListIterator.next();
                                Dynamic<?> $$34 = this.getBlockEntity($$33 |= $$4);
                                if ($$34 == null) continue;
                                String $$35 = String.valueOf($$34.get("SkullType").asInt(0));
                                String $$36 = ChunkPalettedStorageFix.getProperty(this.getBlock($$33), "facing");
                                if ("up".equals($$36) || "down".equals($$36)) {
                                    String $$37 = $$35 + String.valueOf($$34.get("Rot").asInt(0));
                                } else {
                                    $$38 = $$35 + $$36;
                                }
                                $$34.remove("SkullType");
                                $$34.remove("facing");
                                $$34.remove("Rot");
                                this.setBlock($$33, MappingConstants.SKULL_MAP.getOrDefault($$38, MappingConstants.SKULL_MAP.get("0north")));
                            }
                            continue block30;
                        }
                        case 64: 
                        case 71: 
                        case 193: 
                        case 194: 
                        case 195: 
                        case 196: 
                        case 197: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                Dynamic<?> $$41;
                                int $$39 = (Integer)intListIterator.next();
                                Dynamic<?> $$40 = this.getBlock($$39 |= $$4);
                                if (!ChunkPalettedStorageFix.getName($$40).endsWith("_door") || !"lower".equals(ChunkPalettedStorageFix.getProperty($$41 = this.getBlock($$39), "half"))) continue;
                                int $$42 = UpgradeChunk.relative($$39, Direction.UP);
                                Dynamic<?> $$43 = this.getBlock($$42);
                                String $$44 = ChunkPalettedStorageFix.getName($$41);
                                if (!$$44.equals(ChunkPalettedStorageFix.getName($$43))) continue;
                                String $$45 = ChunkPalettedStorageFix.getProperty($$41, "facing");
                                String $$46 = ChunkPalettedStorageFix.getProperty($$41, "open");
                                String $$47 = $$1 ? "left" : ChunkPalettedStorageFix.getProperty($$43, "hinge");
                                String $$48 = $$1 ? "false" : ChunkPalettedStorageFix.getProperty($$43, "powered");
                                this.setBlock($$39, MappingConstants.DOOR_MAP.get($$44 + $$45 + "lower" + $$47 + $$46 + $$48));
                                this.setBlock($$42, MappingConstants.DOOR_MAP.get($$44 + $$45 + "upper" + $$47 + $$46 + $$48));
                            }
                            continue block30;
                        }
                        case 175: {
                            IntListIterator intListIterator = ((IntList)$$3.getValue()).iterator();
                            while (intListIterator.hasNext()) {
                                String $$52;
                                int $$49 = (Integer)intListIterator.next();
                                Dynamic<?> $$50 = this.getBlock($$49 |= $$4);
                                if (!"upper".equals(ChunkPalettedStorageFix.getProperty($$50, "half"))) continue;
                                Dynamic<?> $$51 = this.getBlock(UpgradeChunk.relative($$49, Direction.DOWN));
                                switch ($$52 = ChunkPalettedStorageFix.getName($$51)) {
                                    case "minecraft:sunflower": {
                                        this.setBlock($$49, MappingConstants.UPPER_SUNFLOWER);
                                        break;
                                    }
                                    case "minecraft:lilac": {
                                        this.setBlock($$49, MappingConstants.UPPER_LILAC);
                                        break;
                                    }
                                    case "minecraft:tall_grass": {
                                        this.setBlock($$49, MappingConstants.UPPER_TALL_GRASS);
                                        break;
                                    }
                                    case "minecraft:large_fern": {
                                        this.setBlock($$49, MappingConstants.UPPER_LARGE_FERN);
                                        break;
                                    }
                                    case "minecraft:rose_bush": {
                                        this.setBlock($$49, MappingConstants.UPPER_ROSE_BUSH);
                                        break;
                                    }
                                    case "minecraft:peony": {
                                        this.setBlock($$49, MappingConstants.UPPER_PEONY);
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }

        @Nullable
        private Dynamic<?> getBlockEntity(int p_15237_) {
            return (Dynamic)this.blockEntities.get(p_15237_);
        }

        @Nullable
        private Dynamic<?> removeBlockEntity(int p_15243_) {
            return (Dynamic)this.blockEntities.remove(p_15243_);
        }

        public static int relative(int p_15227_, Direction p_15228_) {
            return switch (p_15228_.getAxis().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    int $$2 = (p_15227_ & 0xF) + p_15228_.getAxisDirection().getStep();
                    if ($$2 < 0 || $$2 > 15) {
                        yield -1;
                    }
                    yield p_15227_ & 0xFFFFFFF0 | $$2;
                }
                case 1 -> {
                    int $$3 = (p_15227_ >> 8) + p_15228_.getAxisDirection().getStep();
                    if ($$3 < 0 || $$3 > 255) {
                        yield -1;
                    }
                    yield p_15227_ & 0xFF | $$3 << 8;
                }
                case 2 -> {
                    int $$4 = (p_15227_ >> 4 & 0xF) + p_15228_.getAxisDirection().getStep();
                    if ($$4 < 0 || $$4 > 15) {
                        yield -1;
                    }
                    yield p_15227_ & 0xFFFFFF0F | $$4 << 4;
                }
            };
        }

        private void setBlock(int p_15230_, Dynamic<?> p_15231_) {
            if (p_15230_ < 0 || p_15230_ > 65535) {
                return;
            }
            Section $$2 = this.getSection(p_15230_);
            if ($$2 == null) {
                return;
            }
            $$2.setBlock(p_15230_ & 0xFFF, p_15231_);
        }

        @Nullable
        private Section getSection(int p_15245_) {
            int $$1 = p_15245_ >> 12;
            return $$1 < this.sections.length ? this.sections[$$1] : null;
        }

        public Dynamic<?> getBlock(int p_15225_) {
            if (p_15225_ < 0 || p_15225_ > 65535) {
                return MappingConstants.AIR;
            }
            Section $$1 = this.getSection(p_15225_);
            if ($$1 == null) {
                return MappingConstants.AIR;
            }
            return $$1.getBlock(p_15225_ & 0xFFF);
        }

        public Dynamic<?> write() {
            Dynamic $$0 = this.level;
            $$0 = this.blockEntities.isEmpty() ? $$0.remove("TileEntities") : $$0.set("TileEntities", $$0.createList(this.blockEntities.values().stream()));
            Dynamic $$1 = $$0.emptyMap();
            ArrayList $$2 = Lists.newArrayList();
            for (Section $$3 : this.sections) {
                if ($$3 == null) continue;
                $$2.add($$3.write());
                $$1 = $$1.set(String.valueOf($$3.y), $$1.createIntList(Arrays.stream($$3.update.toIntArray())));
            }
            Dynamic $$4 = $$0.emptyMap();
            $$4 = $$4.set("Sides", $$4.createByte((byte)this.sides));
            $$4 = $$4.set("Indices", $$1);
            return $$0.set("UpgradeData", $$4).set("Sections", $$4.createList($$2.stream()));
        }
    }

    public static enum Direction {
        DOWN(AxisDirection.NEGATIVE, Axis.Y),
        UP(AxisDirection.POSITIVE, Axis.Y),
        NORTH(AxisDirection.NEGATIVE, Axis.Z),
        SOUTH(AxisDirection.POSITIVE, Axis.Z),
        WEST(AxisDirection.NEGATIVE, Axis.X),
        EAST(AxisDirection.POSITIVE, Axis.X);

        private final Axis axis;
        private final AxisDirection axisDirection;

        private Direction(AxisDirection p_15154_, Axis p_15155_) {
            this.axis = p_15155_;
            this.axisDirection = p_15154_;
        }

        public AxisDirection getAxisDirection() {
            return this.axisDirection;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public static enum Axis {
            X,
            Y,
            Z;

        }

        public static enum AxisDirection {
            POSITIVE(1),
            NEGATIVE(-1);

            private final int step;

            private AxisDirection(int p_15180_) {
                this.step = p_15180_;
            }

            public int getStep() {
                return this.step;
            }
        }
    }

    static class DataLayer {
        private static final int SIZE = 2048;
        private static final int NIBBLE_SIZE = 4;
        private final byte[] data;

        public DataLayer() {
            this.data = new byte[2048];
        }

        public DataLayer(byte[] p_15132_) {
            this.data = p_15132_;
            if (p_15132_.length != 2048) {
                throw new IllegalArgumentException("ChunkNibbleArrays should be 2048 bytes not: " + p_15132_.length);
            }
        }

        public int get(int p_15136_, int p_15137_, int p_15138_) {
            int $$3 = this.getPosition(p_15137_ << 8 | p_15138_ << 4 | p_15136_);
            if (this.isFirst(p_15137_ << 8 | p_15138_ << 4 | p_15136_)) {
                return this.data[$$3] & 0xF;
            }
            return this.data[$$3] >> 4 & 0xF;
        }

        private boolean isFirst(int p_15134_) {
            return (p_15134_ & 1) == 0;
        }

        private int getPosition(int p_15140_) {
            return p_15140_ >> 1;
        }
    }

    static class Section {
        private final CrudeIncrementalIntIdentityHashBiMap<Dynamic<?>> palette = CrudeIncrementalIntIdentityHashBiMap.create(32);
        private final List<Dynamic<?>> listTag;
        private final Dynamic<?> section;
        private final boolean hasData;
        final Int2ObjectMap<IntList> toFix = new Int2ObjectLinkedOpenHashMap();
        final IntList update = new IntArrayList();
        public final int y;
        private final Set<Dynamic<?>> seen = Sets.newIdentityHashSet();
        private final int[] buffer = new int[4096];

        public Section(Dynamic<?> p_15195_) {
            this.listTag = Lists.newArrayList();
            this.section = p_15195_;
            this.y = p_15195_.get("Y").asInt(0);
            this.hasData = p_15195_.get("Blocks").result().isPresent();
        }

        public Dynamic<?> getBlock(int p_15198_) {
            if (p_15198_ < 0 || p_15198_ > 4095) {
                return MappingConstants.AIR;
            }
            Dynamic<?> $$1 = this.palette.byId(this.buffer[p_15198_]);
            return $$1 == null ? MappingConstants.AIR : $$1;
        }

        public void setBlock(int p_15203_, Dynamic<?> p_15204_) {
            if (this.seen.add(p_15204_)) {
                this.listTag.add("%%FILTER_ME%%".equals(ChunkPalettedStorageFix.getName(p_15204_)) ? MappingConstants.AIR : p_15204_);
            }
            this.buffer[p_15203_] = ChunkPalettedStorageFix.idFor(this.palette, p_15204_);
        }

        public int upgrade(int p_15210_) {
            if (!this.hasData) {
                return p_15210_;
            }
            ByteBuffer $$1 = (ByteBuffer)this.section.get("Blocks").asByteBufferOpt().result().get();
            DataLayer $$2 = this.section.get("Data").asByteBufferOpt().map(p_15214_ -> new DataLayer(DataFixUtils.toArray((ByteBuffer)p_15214_))).result().orElseGet(DataLayer::new);
            DataLayer $$3 = this.section.get("Add").asByteBufferOpt().map(p_15208_ -> new DataLayer(DataFixUtils.toArray((ByteBuffer)p_15208_))).result().orElseGet(DataLayer::new);
            this.seen.add(MappingConstants.AIR);
            ChunkPalettedStorageFix.idFor(this.palette, MappingConstants.AIR);
            this.listTag.add(MappingConstants.AIR);
            for (int $$4 = 0; $$4 < 4096; ++$$4) {
                int $$5 = $$4 & 0xF;
                int $$6 = $$4 >> 8 & 0xF;
                int $$7 = $$4 >> 4 & 0xF;
                int $$8 = $$3.get($$5, $$6, $$7) << 12 | ($$1.get($$4) & 0xFF) << 4 | $$2.get($$5, $$6, $$7);
                if (MappingConstants.FIX.get($$8 >> 4)) {
                    this.addFix($$8 >> 4, $$4);
                }
                if (MappingConstants.VIRTUAL.get($$8 >> 4)) {
                    int $$9 = ChunkPalettedStorageFix.getSideMask($$5 == 0, $$5 == 15, $$7 == 0, $$7 == 15);
                    if ($$9 == 0) {
                        this.update.add($$4);
                    } else {
                        p_15210_ |= $$9;
                    }
                }
                this.setBlock($$4, BlockStateData.getTag($$8));
            }
            return p_15210_;
        }

        private void addFix(int p_15200_, int p_15201_) {
            IntList $$2 = (IntList)this.toFix.get(p_15200_);
            if ($$2 == null) {
                $$2 = new IntArrayList();
                this.toFix.put(p_15200_, (Object)$$2);
            }
            $$2.add(p_15201_);
        }

        public Dynamic<?> write() {
            Dynamic $$0 = this.section;
            if (!this.hasData) {
                return $$0;
            }
            $$0 = $$0.set("Palette", $$0.createList(this.listTag.stream()));
            int $$1 = Math.max(4, DataFixUtils.ceillog2((int)this.seen.size()));
            PackedBitStorage $$2 = new PackedBitStorage($$1, 4096);
            for (int $$3 = 0; $$3 < this.buffer.length; ++$$3) {
                $$2.set($$3, this.buffer[$$3]);
            }
            $$0 = $$0.set("BlockStates", $$0.createLongList(Arrays.stream($$2.getRaw())));
            $$0 = $$0.remove("Blocks");
            $$0 = $$0.remove("Data");
            $$0 = $$0.remove("Add");
            return $$0;
        }
    }

    static class MappingConstants {
        static final BitSet VIRTUAL = new BitSet(256);
        static final BitSet FIX = new BitSet(256);
        static final Dynamic<?> PUMPKIN = ExtraDataFixUtils.blockState("minecraft:pumpkin");
        static final Dynamic<?> SNOWY_PODZOL = ExtraDataFixUtils.blockState("minecraft:podzol", Map.of("snowy", "true"));
        static final Dynamic<?> SNOWY_GRASS = ExtraDataFixUtils.blockState("minecraft:grass_block", Map.of("snowy", "true"));
        static final Dynamic<?> SNOWY_MYCELIUM = ExtraDataFixUtils.blockState("minecraft:mycelium", Map.of("snowy", "true"));
        static final Dynamic<?> UPPER_SUNFLOWER = ExtraDataFixUtils.blockState("minecraft:sunflower", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_LILAC = ExtraDataFixUtils.blockState("minecraft:lilac", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_TALL_GRASS = ExtraDataFixUtils.blockState("minecraft:tall_grass", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_LARGE_FERN = ExtraDataFixUtils.blockState("minecraft:large_fern", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_ROSE_BUSH = ExtraDataFixUtils.blockState("minecraft:rose_bush", Map.of("half", "upper"));
        static final Dynamic<?> UPPER_PEONY = ExtraDataFixUtils.blockState("minecraft:peony", Map.of("half", "upper"));
        static final Map<String, Dynamic<?>> FLOWER_POT_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_363273_ -> {
            p_363273_.put("minecraft:air0", ExtraDataFixUtils.blockState("minecraft:flower_pot"));
            p_363273_.put("minecraft:red_flower0", ExtraDataFixUtils.blockState("minecraft:potted_poppy"));
            p_363273_.put("minecraft:red_flower1", ExtraDataFixUtils.blockState("minecraft:potted_blue_orchid"));
            p_363273_.put("minecraft:red_flower2", ExtraDataFixUtils.blockState("minecraft:potted_allium"));
            p_363273_.put("minecraft:red_flower3", ExtraDataFixUtils.blockState("minecraft:potted_azure_bluet"));
            p_363273_.put("minecraft:red_flower4", ExtraDataFixUtils.blockState("minecraft:potted_red_tulip"));
            p_363273_.put("minecraft:red_flower5", ExtraDataFixUtils.blockState("minecraft:potted_orange_tulip"));
            p_363273_.put("minecraft:red_flower6", ExtraDataFixUtils.blockState("minecraft:potted_white_tulip"));
            p_363273_.put("minecraft:red_flower7", ExtraDataFixUtils.blockState("minecraft:potted_pink_tulip"));
            p_363273_.put("minecraft:red_flower8", ExtraDataFixUtils.blockState("minecraft:potted_oxeye_daisy"));
            p_363273_.put("minecraft:yellow_flower0", ExtraDataFixUtils.blockState("minecraft:potted_dandelion"));
            p_363273_.put("minecraft:sapling0", ExtraDataFixUtils.blockState("minecraft:potted_oak_sapling"));
            p_363273_.put("minecraft:sapling1", ExtraDataFixUtils.blockState("minecraft:potted_spruce_sapling"));
            p_363273_.put("minecraft:sapling2", ExtraDataFixUtils.blockState("minecraft:potted_birch_sapling"));
            p_363273_.put("minecraft:sapling3", ExtraDataFixUtils.blockState("minecraft:potted_jungle_sapling"));
            p_363273_.put("minecraft:sapling4", ExtraDataFixUtils.blockState("minecraft:potted_acacia_sapling"));
            p_363273_.put("minecraft:sapling5", ExtraDataFixUtils.blockState("minecraft:potted_dark_oak_sapling"));
            p_363273_.put("minecraft:red_mushroom0", ExtraDataFixUtils.blockState("minecraft:potted_red_mushroom"));
            p_363273_.put("minecraft:brown_mushroom0", ExtraDataFixUtils.blockState("minecraft:potted_brown_mushroom"));
            p_363273_.put("minecraft:deadbush0", ExtraDataFixUtils.blockState("minecraft:potted_dead_bush"));
            p_363273_.put("minecraft:tallgrass2", ExtraDataFixUtils.blockState("minecraft:potted_fern"));
            p_363273_.put("minecraft:cactus0", ExtraDataFixUtils.blockState("minecraft:potted_cactus"));
        });
        static final Map<String, Dynamic<?>> SKULL_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_363674_ -> {
            MappingConstants.mapSkull(p_363674_, 0, "skeleton", "skull");
            MappingConstants.mapSkull(p_363674_, 1, "wither_skeleton", "skull");
            MappingConstants.mapSkull(p_363674_, 2, "zombie", "head");
            MappingConstants.mapSkull(p_363674_, 3, "player", "head");
            MappingConstants.mapSkull(p_363674_, 4, "creeper", "head");
            MappingConstants.mapSkull(p_363674_, 5, "dragon", "head");
        });
        static final Map<String, Dynamic<?>> DOOR_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_363442_ -> {
            MappingConstants.mapDoor(p_363442_, "oak_door");
            MappingConstants.mapDoor(p_363442_, "iron_door");
            MappingConstants.mapDoor(p_363442_, "spruce_door");
            MappingConstants.mapDoor(p_363442_, "birch_door");
            MappingConstants.mapDoor(p_363442_, "jungle_door");
            MappingConstants.mapDoor(p_363442_, "acacia_door");
            MappingConstants.mapDoor(p_363442_, "dark_oak_door");
        });
        static final Map<String, Dynamic<?>> NOTE_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_361924_ -> {
            for (int $$1 = 0; $$1 < 26; ++$$1) {
                p_361924_.put("true" + $$1, ExtraDataFixUtils.blockState("minecraft:note_block", Map.of("powered", "true", "note", String.valueOf($$1))));
                p_361924_.put("false" + $$1, ExtraDataFixUtils.blockState("minecraft:note_block", Map.of("powered", "false", "note", String.valueOf($$1))));
            }
        });
        private static final Int2ObjectMap<String> DYE_COLOR_MAP = (Int2ObjectMap)DataFixUtils.make((Object)new Int2ObjectOpenHashMap(), p_360500_ -> {
            p_360500_.put(0, (Object)"white");
            p_360500_.put(1, (Object)"orange");
            p_360500_.put(2, (Object)"magenta");
            p_360500_.put(3, (Object)"light_blue");
            p_360500_.put(4, (Object)"yellow");
            p_360500_.put(5, (Object)"lime");
            p_360500_.put(6, (Object)"pink");
            p_360500_.put(7, (Object)"gray");
            p_360500_.put(8, (Object)"light_gray");
            p_360500_.put(9, (Object)"cyan");
            p_360500_.put(10, (Object)"purple");
            p_360500_.put(11, (Object)"blue");
            p_360500_.put(12, (Object)"brown");
            p_360500_.put(13, (Object)"green");
            p_360500_.put(14, (Object)"red");
            p_360500_.put(15, (Object)"black");
        });
        static final Map<String, Dynamic<?>> BED_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_361617_ -> {
            for (Int2ObjectMap.Entry $$1 : DYE_COLOR_MAP.int2ObjectEntrySet()) {
                if (Objects.equals($$1.getValue(), "red")) continue;
                MappingConstants.addBeds(p_361617_, $$1.getIntKey(), (String)$$1.getValue());
            }
        });
        static final Map<String, Dynamic<?>> BANNER_BLOCK_MAP = (Map)DataFixUtils.make((Object)Maps.newHashMap(), p_364554_ -> {
            for (Int2ObjectMap.Entry $$1 : DYE_COLOR_MAP.int2ObjectEntrySet()) {
                if (Objects.equals($$1.getValue(), "white")) continue;
                MappingConstants.addBanners(p_364554_, 15 - $$1.getIntKey(), (String)$$1.getValue());
            }
        });
        static final Dynamic<?> AIR;

        private MappingConstants() {
        }

        private static void mapSkull(Map<String, Dynamic<?>> p_365006_, int p_362507_, String p_362757_, String p_361302_) {
            p_365006_.put(p_362507_ + "north", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "north")));
            p_365006_.put(p_362507_ + "east", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "east")));
            p_365006_.put(p_362507_ + "south", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "south")));
            p_365006_.put(p_362507_ + "west", ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_wall_" + p_361302_, Map.of("facing", "west")));
            for (int $$4 = 0; $$4 < 16; ++$$4) {
                p_365006_.put("" + p_362507_ + $$4, ExtraDataFixUtils.blockState("minecraft:" + p_362757_ + "_" + p_361302_, Map.of("rotation", String.valueOf($$4))));
            }
        }

        private static void mapDoor(Map<String, Dynamic<?>> p_363047_, String p_362668_) {
            String $$2 = "minecraft:" + p_362668_;
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastlowerrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "eastupperrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "east", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northlowerrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "northupperrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "north", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southlowerrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "southupperrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "south", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westlowerrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "lower", "hinge", "right", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperleftfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperleftfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperlefttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperlefttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "left", "open", "true", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrightfalsefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrightfalsetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "false", "powered", "true")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrighttruefalse", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "false")));
            p_363047_.put("minecraft:" + p_362668_ + "westupperrighttruetrue", ExtraDataFixUtils.blockState($$2, Map.of("facing", "west", "half", "upper", "hinge", "right", "open", "true", "powered", "true")));
        }

        private static void addBeds(Map<String, Dynamic<?>> p_362926_, int p_362734_, String p_363528_) {
            p_362926_.put("southfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "south", "occupied", "false", "part", "foot")));
            p_362926_.put("westfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "west", "occupied", "false", "part", "foot")));
            p_362926_.put("northfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "north", "occupied", "false", "part", "foot")));
            p_362926_.put("eastfalsefoot" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "east", "occupied", "false", "part", "foot")));
            p_362926_.put("southfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "south", "occupied", "false", "part", "head")));
            p_362926_.put("westfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "west", "occupied", "false", "part", "head")));
            p_362926_.put("northfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "north", "occupied", "false", "part", "head")));
            p_362926_.put("eastfalsehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "east", "occupied", "false", "part", "head")));
            p_362926_.put("southtruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "south", "occupied", "true", "part", "head")));
            p_362926_.put("westtruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "west", "occupied", "true", "part", "head")));
            p_362926_.put("northtruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "north", "occupied", "true", "part", "head")));
            p_362926_.put("easttruehead" + p_362734_, ExtraDataFixUtils.blockState("minecraft:" + p_363528_ + "_bed", Map.of("facing", "east", "occupied", "true", "part", "head")));
        }

        private static void addBanners(Map<String, Dynamic<?>> p_364918_, int p_361132_, String p_364042_) {
            for (int $$3 = 0; $$3 < 16; ++$$3) {
                p_364918_.put($$3 + "_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_banner", Map.of("rotation", String.valueOf($$3))));
            }
            p_364918_.put("north_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "north")));
            p_364918_.put("south_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "south")));
            p_364918_.put("west_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "west")));
            p_364918_.put("east_" + p_361132_, ExtraDataFixUtils.blockState("minecraft:" + p_364042_ + "_wall_banner", Map.of("facing", "east")));
        }

        static {
            FIX.set(2);
            FIX.set(3);
            FIX.set(110);
            FIX.set(140);
            FIX.set(144);
            FIX.set(25);
            FIX.set(86);
            FIX.set(26);
            FIX.set(176);
            FIX.set(177);
            FIX.set(175);
            FIX.set(64);
            FIX.set(71);
            FIX.set(193);
            FIX.set(194);
            FIX.set(195);
            FIX.set(196);
            FIX.set(197);
            VIRTUAL.set(54);
            VIRTUAL.set(146);
            VIRTUAL.set(25);
            VIRTUAL.set(26);
            VIRTUAL.set(51);
            VIRTUAL.set(53);
            VIRTUAL.set(67);
            VIRTUAL.set(108);
            VIRTUAL.set(109);
            VIRTUAL.set(114);
            VIRTUAL.set(128);
            VIRTUAL.set(134);
            VIRTUAL.set(135);
            VIRTUAL.set(136);
            VIRTUAL.set(156);
            VIRTUAL.set(163);
            VIRTUAL.set(164);
            VIRTUAL.set(180);
            VIRTUAL.set(203);
            VIRTUAL.set(55);
            VIRTUAL.set(85);
            VIRTUAL.set(113);
            VIRTUAL.set(188);
            VIRTUAL.set(189);
            VIRTUAL.set(190);
            VIRTUAL.set(191);
            VIRTUAL.set(192);
            VIRTUAL.set(93);
            VIRTUAL.set(94);
            VIRTUAL.set(101);
            VIRTUAL.set(102);
            VIRTUAL.set(160);
            VIRTUAL.set(106);
            VIRTUAL.set(107);
            VIRTUAL.set(183);
            VIRTUAL.set(184);
            VIRTUAL.set(185);
            VIRTUAL.set(186);
            VIRTUAL.set(187);
            VIRTUAL.set(132);
            VIRTUAL.set(139);
            VIRTUAL.set(199);
            AIR = ExtraDataFixUtils.blockState("minecraft:air");
        }
    }
}

