/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.BitSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;

public class ExtraDataFixUtils {
    public static Dynamic<?> fixBlockPos(Dynamic<?> p_326292_) {
        Optional $$1 = p_326292_.get("X").asNumber().result();
        Optional $$2 = p_326292_.get("Y").asNumber().result();
        Optional $$3 = p_326292_.get("Z").asNumber().result();
        if ($$1.isEmpty() || $$2.isEmpty() || $$3.isEmpty()) {
            return p_326292_;
        }
        return ExtraDataFixUtils.createBlockPos(p_326292_, ((Number)$$1.get()).intValue(), ((Number)$$2.get()).intValue(), ((Number)$$3.get()).intValue());
    }

    public static Dynamic<?> fixInlineBlockPos(Dynamic<?> p_401383_, String p_401140_, String p_401018_, String p_401105_, String p_401115_) {
        Optional $$5 = p_401383_.get(p_401140_).asNumber().result();
        Optional $$6 = p_401383_.get(p_401018_).asNumber().result();
        Optional $$7 = p_401383_.get(p_401105_).asNumber().result();
        if ($$5.isEmpty() || $$6.isEmpty() || $$7.isEmpty()) {
            return p_401383_;
        }
        return p_401383_.remove(p_401140_).remove(p_401018_).remove(p_401105_).set(p_401115_, ExtraDataFixUtils.createBlockPos(p_401383_, ((Number)$$5.get()).intValue(), ((Number)$$6.get()).intValue(), ((Number)$$7.get()).intValue()));
    }

    public static Dynamic<?> createBlockPos(Dynamic<?> p_401108_, int p_401194_, int p_401075_, int p_401046_) {
        return p_401108_.createIntList(IntStream.of(p_401194_, p_401075_, p_401046_));
    }

    public static <T, R> Typed<R> cast(Type<R> p_330690_, Typed<T> p_331921_) {
        return new Typed(p_330690_, p_331921_.getOps(), p_331921_.getValue());
    }

    public static <T> Typed<T> cast(Type<T> p_394665_, Object p_394477_, DynamicOps<?> p_394121_) {
        return new Typed(p_394665_, p_394121_, p_394477_);
    }

    public static Type<?> patchSubType(Type<?> p_364210_, Type<?> p_360925_, Type<?> p_365306_) {
        return p_364210_.all(ExtraDataFixUtils.typePatcher(p_360925_, p_365306_), true, false).view().newType();
    }

    private static <A, B> TypeRewriteRule typePatcher(Type<A> p_365338_, Type<B> p_363692_) {
        RewriteResult $$2 = RewriteResult.create((View)View.create((String)"Patcher", p_365338_, p_363692_, p_359667_ -> p_359670_ -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(p_365338_, (RewriteResult)$$2), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    @SafeVarargs
    public static <T> Function<Typed<?>, Typed<?>> chainAllFilters(Function<Typed<?>, Typed<?>> ... p_344769_) {
        return p_345927_ -> {
            for (Function $$2 : p_344769_) {
                p_345927_ = (Typed)$$2.apply(p_345927_);
            }
            return p_345927_;
        };
    }

    public static Dynamic<?> blockState(String p_361952_, Map<String, String> p_362407_) {
        Dynamic $$2 = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag());
        Dynamic $$3 = $$2.set("Name", $$2.createString(p_361952_));
        if (!p_362407_.isEmpty()) {
            $$3 = $$3.set("Properties", $$2.createMap(p_362407_.entrySet().stream().collect(Collectors.toMap(p_359669_ -> $$2.createString((String)p_359669_.getKey()), p_359672_ -> $$2.createString((String)p_359672_.getValue())))));
        }
        return $$3;
    }

    public static Dynamic<?> blockState(String p_363485_) {
        return ExtraDataFixUtils.blockState(p_363485_, Map.of());
    }

    public static Dynamic<?> fixStringField(Dynamic<?> p_365145_, String p_361499_, UnaryOperator<String> p_360789_) {
        return p_365145_.update(p_361499_, p_359675_ -> (Dynamic)DataFixUtils.orElse((Optional)p_359675_.asString().map((Function)p_360789_).map(arg_0 -> ((Dynamic)p_365145_).createString(arg_0)).result(), (Object)p_359675_));
    }

    public static String dyeColorIdToName(int p_397819_) {
        return switch (p_397819_) {
            default -> "white";
            case 1 -> "orange";
            case 2 -> "magenta";
            case 3 -> "light_blue";
            case 4 -> "yellow";
            case 5 -> "lime";
            case 6 -> "pink";
            case 7 -> "gray";
            case 8 -> "light_gray";
            case 9 -> "cyan";
            case 10 -> "purple";
            case 11 -> "blue";
            case 12 -> "brown";
            case 13 -> "green";
            case 14 -> "red";
            case 15 -> "black";
        };
    }

    public static <T> Typed<?> readAndSet(Typed<?> p_404652_, OpticFinder<T> p_405690_, Dynamic<?> p_405117_) {
        return p_404652_.set(p_405690_, Util.readTypedOrThrow(p_405690_.type(), p_405117_, true));
    }
}

