/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.context;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.util.context.ContextKey;

public class ContextKeySet {
    private final Set<ContextKey<?>> required;
    private final Set<ContextKey<?>> allowed;

    ContextKeySet(Set<ContextKey<?>> p_381057_, Set<ContextKey<?>> p_381141_) {
        this.required = Set.copyOf(p_381057_);
        this.allowed = Set.copyOf(Sets.union(p_381057_, p_381141_));
    }

    public Set<ContextKey<?>> required() {
        return this.required;
    }

    public Set<ContextKey<?>> allowed() {
        return this.allowed;
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join(this.allowed.stream().map(p_381140_ -> (this.required.contains(p_381140_) ? "!" : "") + String.valueOf(p_381140_.name())).iterator()) + "]";
    }

    public static class Builder {
        private final Set<ContextKey<?>> required = Sets.newIdentityHashSet();
        private final Set<ContextKey<?>> optional = Sets.newIdentityHashSet();

        public Builder required(ContextKey<?> p_380985_) {
            if (this.optional.contains(p_380985_)) {
                throw new IllegalArgumentException("Parameter " + String.valueOf(p_380985_.name()) + " is already optional");
            }
            this.required.add(p_380985_);
            return this;
        }

        public Builder optional(ContextKey<?> p_381112_) {
            if (this.required.contains(p_381112_)) {
                throw new IllegalArgumentException("Parameter " + String.valueOf(p_381112_.name()) + " is already required");
            }
            this.optional.add(p_381112_);
            return this;
        }

        public ContextKeySet build() {
            return new ContextKeySet(this.required, this.optional);
        }
    }
}

