/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public interface ProblemReporter {
    public static final ProblemReporter DISCARDING = new ProblemReporter(){

        @Override
        public ProblemReporter forChild(PathElement p_422462_) {
            return this;
        }

        @Override
        public void report(Problem p_422437_) {
        }
    };

    public ProblemReporter forChild(PathElement var1);

    public void report(Problem var1);

    public static class ScopedCollector
    extends Collector
    implements AutoCloseable {
        private final Logger logger;

        public ScopedCollector(Logger p_421960_) {
            this.logger = p_421960_;
        }

        public ScopedCollector(PathElement p_421607_, Logger p_421775_) {
            super(p_421607_);
            this.logger = p_421775_;
        }

        @Override
        public void close() {
            if (!this.isEmpty()) {
                this.logger.warn("[{}] Serialization errors:\n{}", (Object)this.logger.getName(), (Object)this.getTreeReport());
            }
        }
    }

    public static class Collector
    implements ProblemReporter {
        public static final PathElement EMPTY_ROOT = () -> "";
        @Nullable
        private final Collector parent;
        private final PathElement element;
        private final Set<Entry> problems;

        public Collector() {
            this(EMPTY_ROOT);
        }

        public Collector(PathElement p_421639_) {
            this.parent = null;
            this.problems = new LinkedHashSet<Entry>();
            this.element = p_421639_;
        }

        private Collector(Collector p_421606_, PathElement p_422426_) {
            this.problems = p_421606_.problems;
            this.parent = p_421606_;
            this.element = p_422426_;
        }

        @Override
        public ProblemReporter forChild(PathElement p_422155_) {
            return new Collector(this, p_422155_);
        }

        @Override
        public void report(Problem p_422092_) {
            this.problems.add(new Entry(this, p_422092_));
        }

        public boolean isEmpty() {
            return this.problems.isEmpty();
        }

        public void forEach(BiConsumer<String, Problem> p_421886_) {
            ArrayList<PathElement> $$1 = new ArrayList<PathElement>();
            StringBuilder $$2 = new StringBuilder();
            for (Entry $$3 : this.problems) {
                Collector $$4 = $$3.source;
                while ($$4 != null) {
                    $$1.add($$4.element);
                    $$4 = $$4.parent;
                }
                for (int $$5 = $$1.size() - 1; $$5 >= 0; --$$5) {
                    $$2.append(((PathElement)$$1.get($$5)).get());
                }
                p_421886_.accept($$2.toString(), $$3.problem());
                $$2.setLength(0);
                $$1.clear();
            }
        }

        public String getReport() {
            HashMultimap $$0 = HashMultimap.create();
            this.forEach((arg_0, arg_1) -> ((Multimap)$$0).put(arg_0, arg_1));
            return $$0.asMap().entrySet().stream().map(p_421345_ -> " at " + (String)p_421345_.getKey() + ": " + ((Collection)p_421345_.getValue()).stream().map(Problem::description).collect(Collectors.joining("; "))).collect(Collectors.joining("\n"));
        }

        public String getTreeReport() {
            ArrayList<PathElement> $$0 = new ArrayList<PathElement>();
            ProblemTreeNode $$1 = new ProblemTreeNode(this.element);
            for (Entry $$2 : this.problems) {
                Collector $$3 = $$2.source;
                while ($$3 != this) {
                    $$0.add($$3.element);
                    $$3 = $$3.parent;
                }
                ProblemTreeNode $$4 = $$1;
                for (int $$5 = $$0.size() - 1; $$5 >= 0; --$$5) {
                    $$4 = $$4.child((PathElement)$$0.get($$5));
                }
                $$0.clear();
                $$4.problems.add($$2.problem);
            }
            return String.join((CharSequence)"\n", $$1.getLines());
        }

        record Entry(Collector source, Problem problem) {
        }

        record ProblemTreeNode(PathElement element, List<Problem> problems, Map<PathElement, ProblemTreeNode> children) {
            public ProblemTreeNode(PathElement p_422382_) {
                this(p_422382_, new ArrayList<Problem>(), new LinkedHashMap<PathElement, ProblemTreeNode>());
            }

            public ProblemTreeNode child(PathElement p_422281_) {
                return this.children.computeIfAbsent(p_422281_, ProblemTreeNode::new);
            }

            public List<String> getLines() {
                int $$0 = this.problems.size();
                int $$1 = this.children.size();
                if ($$0 == 0 && $$1 == 0) {
                    return List.of();
                }
                if ($$0 == 0 && $$1 == 1) {
                    ArrayList<String> $$2 = new ArrayList<String>();
                    this.children.forEach((p_421768_, p_421762_) -> $$2.addAll(p_421762_.getLines()));
                    $$2.set(0, this.element.get() + (String)$$2.get(0));
                    return $$2;
                }
                if ($$0 == 1 && $$1 == 0) {
                    return List.of(this.element.get() + ": " + this.problems.getFirst().description());
                }
                ArrayList<String> $$3 = new ArrayList<String>();
                this.children.forEach((p_422150_, p_422334_) -> $$3.addAll(p_422334_.getLines()));
                $$3.replaceAll(p_422662_ -> "  " + p_422662_);
                for (Problem $$4 : this.problems) {
                    $$3.add("  " + $$4.description());
                }
                $$3.addFirst(this.element.get() + ":");
                return $$3;
            }
        }
    }

    public record ElementReferencePathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "->{" + String.valueOf(this.id.location()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public record IndexedPathElement(int index) implements PathElement
    {
        @Override
        public String get() {
            return "[" + this.index + "]";
        }
    }

    public record IndexedFieldPathElement(String name, int index) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name + "[" + this.index + "]";
        }
    }

    public record FieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name;
        }
    }

    public record RootElementPathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "{" + String.valueOf(this.id.location()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public record RootFieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return this.name;
        }
    }

    @FunctionalInterface
    public static interface PathElement {
        public String get();
    }

    public static interface Problem {
        public String description();
    }
}

