/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ProfiledReloadInstance;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;

public class SimpleReloadInstance<S>
implements ReloadInstance {
    private static final int PREPARATION_PROGRESS_WEIGHT = 2;
    private static final int EXTRA_RELOAD_PROGRESS_WEIGHT = 2;
    private static final int LISTENER_PROGRESS_WEIGHT = 1;
    final CompletableFuture<Unit> allPreparations = new CompletableFuture();
    @Nullable
    private CompletableFuture<List<S>> allDone;
    final Set<PreparableReloadListener> preparingListeners;
    private final int listenerCount;
    private final AtomicInteger startedTasks = new AtomicInteger();
    private final AtomicInteger finishedTasks = new AtomicInteger();
    private final AtomicInteger startedReloads = new AtomicInteger();
    private final AtomicInteger finishedReloads = new AtomicInteger();

    public static ReloadInstance of(ResourceManager p_10816_, List<PreparableReloadListener> p_10817_, Executor p_10818_, Executor p_10819_, CompletableFuture<Unit> p_10820_) {
        SimpleReloadInstance<Void> $$5 = new SimpleReloadInstance<Void>(p_10817_);
        $$5.startTasks(p_10818_, p_10819_, p_10816_, p_10817_, StateFactory.SIMPLE, p_10820_);
        return $$5;
    }

    protected SimpleReloadInstance(List<PreparableReloadListener> p_10811_) {
        this.listenerCount = p_10811_.size();
        this.preparingListeners = new HashSet<PreparableReloadListener>(p_10811_);
    }

    protected void startTasks(Executor p_405149_, Executor p_404751_, ResourceManager p_404875_, List<PreparableReloadListener> p_404801_, StateFactory<S> p_405705_, CompletableFuture<?> p_405320_) {
        this.allDone = this.prepareTasks(p_405149_, p_404751_, p_404875_, p_404801_, p_405705_, p_405320_);
    }

    protected CompletableFuture<List<S>> prepareTasks(Executor p_405268_, Executor p_405682_, ResourceManager p_404829_, List<PreparableReloadListener> p_405049_, StateFactory<S> p_405573_, CompletableFuture<?> p_405777_) {
        Executor $$6 = p_404224_ -> {
            this.startedTasks.incrementAndGet();
            p_405268_.execute(() -> {
                p_404224_.run();
                this.finishedTasks.incrementAndGet();
            });
        };
        Executor $$7 = p_404227_ -> {
            this.startedReloads.incrementAndGet();
            p_405682_.execute(() -> {
                p_404227_.run();
                this.finishedReloads.incrementAndGet();
            });
        };
        this.startedTasks.incrementAndGet();
        p_405777_.thenRun(this.finishedTasks::incrementAndGet);
        CompletableFuture<Object> $$8 = p_405777_;
        ArrayList<CompletableFuture<S>> $$9 = new ArrayList<CompletableFuture<S>>();
        for (PreparableReloadListener $$10 : p_405049_) {
            PreparableReloadListener.PreparationBarrier $$11 = this.createBarrierForListener($$10, $$8, p_405682_);
            CompletableFuture<S> $$12 = p_405573_.create($$11, p_404829_, $$10, $$6, $$7);
            $$9.add($$12);
            $$8 = $$12;
        }
        return Util.sequenceFailFast($$9);
    }

    private PreparableReloadListener.PreparationBarrier createBarrierForListener(final PreparableReloadListener p_405338_, final CompletableFuture<?> p_404885_, final Executor p_405684_) {
        return new PreparableReloadListener.PreparationBarrier(){

            @Override
            public <T> CompletableFuture<T> wait(T p_10858_) {
                p_405684_.execute(() -> {
                    SimpleReloadInstance.this.preparingListeners.remove(p_405338_);
                    if (SimpleReloadInstance.this.preparingListeners.isEmpty()) {
                        SimpleReloadInstance.this.allPreparations.complete(Unit.INSTANCE);
                    }
                });
                return SimpleReloadInstance.this.allPreparations.thenCombine((CompletionStage)p_404885_, (p_10861_, p_10862_) -> p_10858_);
            }
        };
    }

    @Override
    public CompletableFuture<?> done() {
        return Objects.requireNonNull(this.allDone, "not started");
    }

    @Override
    public float getActualProgress() {
        int $$0 = this.listenerCount - this.preparingListeners.size();
        float $$1 = SimpleReloadInstance.weightProgress(this.finishedTasks.get(), this.finishedReloads.get(), $$0);
        float $$2 = SimpleReloadInstance.weightProgress(this.startedTasks.get(), this.startedReloads.get(), this.listenerCount);
        return $$1 / $$2;
    }

    private static int weightProgress(int p_404933_, int p_405172_, int p_405849_) {
        return p_404933_ * 2 + p_405172_ * 2 + p_405849_ * 1;
    }

    public static ReloadInstance create(ResourceManager p_203835_, List<PreparableReloadListener> p_203836_, Executor p_203837_, Executor p_203838_, CompletableFuture<Unit> p_203839_, boolean p_203840_) {
        if (p_203840_) {
            return ProfiledReloadInstance.of(p_203835_, p_203836_, p_203837_, p_203838_, p_203839_);
        }
        return SimpleReloadInstance.of(p_203835_, p_203836_, p_203837_, p_203838_, p_203839_);
    }

    @FunctionalInterface
    protected static interface StateFactory<S> {
        public static final StateFactory<Void> SIMPLE = (p_405840_, p_405259_, p_405187_, p_405538_, p_405432_) -> p_405187_.reload(p_405840_, p_405259_, p_405538_, p_405432_);

        public CompletableFuture<S> create(PreparableReloadListener.PreparationBarrier var1, ResourceManager var2, PreparableReloadListener var3, Executor var4, Executor var5);
    }
}

