/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ProfiledReloadInstance
extends SimpleReloadInstance<State> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Stopwatch total = Stopwatch.createUnstarted();

    public static ReloadInstance of(ResourceManager p_404634_, List<PreparableReloadListener> p_404750_, Executor p_405435_, Executor p_405297_, CompletableFuture<Unit> p_405418_) {
        ProfiledReloadInstance $$5 = new ProfiledReloadInstance(p_404750_);
        $$5.startTasks(p_405435_, p_405297_, p_404634_, p_404750_, (p_404217_, p_404218_, p_404219_, p_404220_, p_404221_) -> {
            AtomicLong $$6 = new AtomicLong();
            AtomicLong $$7 = new AtomicLong();
            AtomicLong $$8 = new AtomicLong();
            AtomicLong $$9 = new AtomicLong();
            CompletableFuture<Void> $$10 = p_404219_.reload(p_404217_, p_404218_, ProfiledReloadInstance.profiledExecutor(p_404220_, $$6, $$7, p_404219_.getName()), ProfiledReloadInstance.profiledExecutor(p_404221_, $$8, $$9, p_404219_.getName()));
            return $$10.thenApplyAsync(p_404215_ -> {
                LOGGER.debug("Finished reloading {}", (Object)p_404219_.getName());
                return new State(p_404219_.getName(), $$6, $$7, $$8, $$9);
            }, p_405297_);
        }, p_405418_);
        return $$5;
    }

    private ProfiledReloadInstance(List<PreparableReloadListener> p_10650_) {
        super(p_10650_);
        this.total.start();
    }

    @Override
    protected CompletableFuture<List<State>> prepareTasks(Executor p_405318_, Executor p_405642_, ResourceManager p_404932_, List<PreparableReloadListener> p_404797_, SimpleReloadInstance.StateFactory<State> p_405213_, CompletableFuture<?> p_405774_) {
        return super.prepareTasks(p_405318_, p_405642_, p_404932_, p_404797_, p_405213_, p_405774_).thenApplyAsync(this::finish, p_405642_);
    }

    private static Executor profiledExecutor(Executor p_373101_, AtomicLong p_373001_, AtomicLong p_404775_, String p_372795_) {
        return p_404205_ -> p_373101_.execute(() -> {
            ProfilerFiller $$4 = Profiler.get();
            $$4.push(p_372795_);
            long $$5 = Util.getNanos();
            p_404205_.run();
            p_373001_.addAndGet(Util.getNanos() - $$5);
            p_404775_.incrementAndGet();
            $$4.pop();
        });
    }

    private List<State> finish(List<State> p_215484_) {
        this.total.stop();
        long $$1 = 0L;
        LOGGER.info("Resource reload finished after {} ms", (Object)this.total.elapsed(TimeUnit.MILLISECONDS));
        for (State $$2 : p_215484_) {
            long $$3 = TimeUnit.NANOSECONDS.toMillis($$2.preparationNanos.get());
            long $$4 = $$2.preparationCount.get();
            long $$5 = TimeUnit.NANOSECONDS.toMillis($$2.reloadNanos.get());
            long $$6 = $$2.reloadCount.get();
            long $$7 = $$3 + $$5;
            long $$8 = $$4 + $$6;
            String $$9 = $$2.name;
            LOGGER.info("{} took approximately {} tasks/{} ms ({} tasks/{} ms preparing, {} tasks/{} ms applying)", new Object[]{$$9, $$8, $$7, $$4, $$3, $$6, $$5});
            $$1 += $$5;
        }
        LOGGER.info("Total blocking time: {} ms", (Object)$$1);
        return p_215484_;
    }

    public record State(String name, AtomicLong preparationNanos, AtomicLong preparationCount, AtomicLong reloadNanos, AtomicLong reloadCount) {
    }
}

