/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public abstract class AbstractPackResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackLocationInfo location;

    protected AbstractPackResources(PackLocationInfo p_326071_) {
        this.location = p_326071_;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> p_389404_) throws IOException {
        IoSupplier<InputStream> $$1 = this.getRootResource("pack.mcmeta");
        if ($$1 == null) {
            return null;
        }
        try (InputStream $$2 = $$1.get();){
            T t = AbstractPackResources.getMetadataFromStream(p_389404_, $$2);
            return t;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionType<T> p_389726_, InputStream p_10216_) {
        void $$6;
        try (BufferedReader $$2 = new BufferedReader(new InputStreamReader(p_10216_, StandardCharsets.UTF_8));){
            JsonObject $$3 = GsonHelper.parse($$2);
        }
        catch (Exception $$5) {
            LOGGER.error("Couldn't load {} metadata", (Object)p_389726_.name(), (Object)$$5);
            return null;
        }
        if (!$$6.has(p_389726_.name())) {
            return null;
        }
        return p_389726_.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)$$6.get(p_389726_.name())).ifError(p_389537_ -> LOGGER.error("Couldn't load {} metadata: {}", (Object)p_389726_.name(), p_389537_)).result().orElse(null);
    }

    @Override
    public PackLocationInfo location() {
        return this.location;
    }
}

