/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.LegacyTextFilter;
import net.minecraft.server.network.PlayerSafetyServiceTextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.StringUtil;
import net.minecraft.util.thread.ConsecutiveExecutor;
import org.slf4j.Logger;

public abstract class ServerTextFilter
implements AutoCloseable {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private static final ThreadFactory THREAD_FACTORY = p_361370_ -> {
        Thread $$1 = new Thread(p_361370_);
        $$1.setName("Chat-Filter-Worker-" + WORKER_COUNT.getAndIncrement());
        return $$1;
    };
    private final URL chatEndpoint;
    private final MessageEncoder chatEncoder;
    final IgnoreStrategy chatIgnoreStrategy;
    final ExecutorService workerPool;

    protected static ExecutorService createWorkerPool(int p_365438_) {
        return Executors.newFixedThreadPool(p_365438_, THREAD_FACTORY);
    }

    protected ServerTextFilter(URL p_365184_, MessageEncoder p_364370_, IgnoreStrategy p_362863_, ExecutorService p_361317_) {
        this.chatIgnoreStrategy = p_362863_;
        this.workerPool = p_361317_;
        this.chatEndpoint = p_365184_;
        this.chatEncoder = p_364370_;
    }

    protected static URL getEndpoint(URI p_362537_, @Nullable JsonObject p_363488_, String p_362892_, String p_363642_) throws MalformedURLException {
        String $$4 = ServerTextFilter.getEndpointFromConfig(p_363488_, p_362892_, p_363642_);
        return p_362537_.resolve("/" + $$4).toURL();
    }

    protected static String getEndpointFromConfig(@Nullable JsonObject p_364584_, String p_360874_, String p_364672_) {
        return p_364584_ != null ? GsonHelper.getAsString(p_364584_, p_360874_, p_364672_) : p_364672_;
    }

    @Nullable
    public static ServerTextFilter createFromConfig(DedicatedServerProperties p_360477_) {
        String $$1 = p_360477_.textFilteringConfig;
        if (StringUtil.isBlank($$1)) {
            return null;
        }
        return switch (p_360477_.textFilteringVersion) {
            case 0 -> LegacyTextFilter.createTextFilterFromConfig($$1);
            case 1 -> PlayerSafetyServiceTextFilter.createTextFilterFromConfig($$1);
            default -> {
                LOGGER.warn("Could not create text filter - unsupported text filtering version used");
                yield null;
            }
        };
    }

    protected CompletableFuture<FilteredText> requestMessageProcessing(GameProfile p_362002_, String p_365325_, IgnoreStrategy p_363966_, Executor p_363262_) {
        if (p_365325_.isEmpty()) {
            return CompletableFuture.completedFuture(FilteredText.EMPTY);
        }
        return CompletableFuture.supplyAsync(() -> {
            JsonObject $$3 = this.chatEncoder.encode(p_362002_, p_365325_);
            try {
                JsonObject $$4 = this.processRequestResponse($$3, this.chatEndpoint);
                return this.filterText(p_365325_, p_363966_, $$4);
            }
            catch (Exception $$5) {
                LOGGER.warn("Failed to validate message '{}'", (Object)p_365325_, (Object)$$5);
                return FilteredText.fullyFiltered(p_365325_);
            }
        }, p_363262_);
    }

    protected abstract FilteredText filterText(String var1, IgnoreStrategy var2, JsonObject var3);

    protected FilterMask parseMask(String p_360987_, JsonArray p_362850_, IgnoreStrategy p_361890_) {
        if (p_362850_.isEmpty()) {
            return FilterMask.PASS_THROUGH;
        }
        if (p_361890_.shouldIgnore(p_360987_, p_362850_.size())) {
            return FilterMask.FULLY_FILTERED;
        }
        FilterMask $$3 = new FilterMask(p_360987_.length());
        for (int $$4 = 0; $$4 < p_362850_.size(); ++$$4) {
            $$3.setFiltered(p_362850_.get($$4).getAsInt());
        }
        return $$3;
    }

    @Override
    public void close() {
        this.workerPool.shutdownNow();
    }

    protected void drainStream(InputStream p_364540_) throws IOException {
        byte[] $$1 = new byte[1024];
        while (p_364540_.read($$1) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject processRequestResponse(JsonObject p_360751_, URL p_364299_) throws IOException {
        HttpURLConnection $$2 = this.makeRequest(p_360751_, p_364299_);
        try (InputStream $$3 = $$2.getInputStream();){
            JsonObject jsonObject;
            if ($$2.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = LenientJsonParser.parse(new InputStreamReader($$3, StandardCharsets.UTF_8)).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.drainStream($$3);
                throw throwable;
            }
            this.drainStream($$3);
            return jsonObject;
        }
    }

    protected HttpURLConnection makeRequest(JsonObject p_365284_, URL p_360402_) throws IOException {
        HttpURLConnection $$2 = this.getURLConnection(p_360402_);
        this.setAuthorizationProperty($$2);
        try (OutputStreamWriter $$3 = new OutputStreamWriter($$2.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter $$4 = new JsonWriter((Writer)$$3);){
            Streams.write((JsonElement)p_365284_, (JsonWriter)$$4);
        }
        int $$5 = $$2.getResponseCode();
        if ($$5 < 200 || $$5 >= 300) {
            throw new RequestFailedException($$5 + " " + $$2.getResponseMessage());
        }
        return $$2;
    }

    protected abstract void setAuthorizationProperty(HttpURLConnection var1);

    protected int connectionReadTimeout() {
        return 2000;
    }

    protected HttpURLConnection getURLConnection(URL p_364237_) throws IOException {
        HttpURLConnection $$1 = (HttpURLConnection)p_364237_.openConnection();
        $$1.setConnectTimeout(15000);
        $$1.setReadTimeout(this.connectionReadTimeout());
        $$1.setUseCaches(false);
        $$1.setDoOutput(true);
        $$1.setDoInput(true);
        $$1.setRequestMethod("POST");
        $$1.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        $$1.setRequestProperty("Accept", "application/json");
        $$1.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.getCurrentVersion().name());
        return $$1;
    }

    public TextFilter createContext(GameProfile p_364881_) {
        return new PlayerContext(p_364881_);
    }

    @FunctionalInterface
    public static interface IgnoreStrategy {
        public static final IgnoreStrategy NEVER_IGNORE = (p_361637_, p_365001_) -> false;
        public static final IgnoreStrategy IGNORE_FULLY_FILTERED = (p_361951_, p_362976_) -> p_361951_.length() == p_362976_;

        public static IgnoreStrategy ignoreOverThreshold(int p_365213_) {
            return (p_363255_, p_363924_) -> p_363924_ >= p_365213_;
        }

        public static IgnoreStrategy select(int p_362175_) {
            return switch (p_362175_) {
                case -1 -> NEVER_IGNORE;
                case 0 -> IGNORE_FULLY_FILTERED;
                default -> IgnoreStrategy.ignoreOverThreshold(p_362175_);
            };
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    @FunctionalInterface
    protected static interface MessageEncoder {
        public JsonObject encode(GameProfile var1, String var2);
    }

    protected static class RequestFailedException
    extends RuntimeException {
        protected RequestFailedException(String p_360393_) {
            super(p_360393_);
        }
    }

    protected class PlayerContext
    implements TextFilter {
        protected final GameProfile profile;
        protected final Executor streamExecutor;

        protected PlayerContext(GameProfile p_360371_) {
            this.profile = p_360371_;
            ConsecutiveExecutor $$2 = new ConsecutiveExecutor(ServerTextFilter.this.workerPool, "chat stream for " + p_360371_.getName());
            this.streamExecutor = $$2::schedule;
        }

        @Override
        public CompletableFuture<List<FilteredText>> processMessageBundle(List<String> p_360687_) {
            List $$1 = (List)p_360687_.stream().map(p_361744_ -> ServerTextFilter.this.requestMessageProcessing(this.profile, (String)p_361744_, ServerTextFilter.this.chatIgnoreStrategy, this.streamExecutor)).collect(ImmutableList.toImmutableList());
            return Util.sequenceFailFast($$1).exceptionally(p_365427_ -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<FilteredText> processStreamMessage(String p_362855_) {
            return ServerTextFilter.this.requestMessageProcessing(this.profile, p_362855_, ServerTextFilter.this.chatIgnoreStrategy, this.streamExecutor);
        }
    }
}

