/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;

public class VersionCommand {
    private static final Component HEADER = Component.translatable("commands.version.header");
    private static final Component STABLE = Component.translatable("commands.version.stable.yes");
    private static final Component UNSTABLE = Component.translatable("commands.version.stable.no");

    public static void register(CommandDispatcher<CommandSourceStack> p_416451_, boolean p_416468_) {
        p_416451_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("version").requires(Commands.hasPermission(p_416468_ ? 2 : 0))).executes(p_416547_ -> {
            CommandSourceStack $$1 = (CommandSourceStack)p_416547_.getSource();
            $$1.sendSystemMessage(HEADER);
            VersionCommand.dumpVersion($$1::sendSystemMessage);
            return 1;
        }));
    }

    public static void dumpVersion(Consumer<Component> p_416474_) {
        WorldVersion $$1 = SharedConstants.getCurrentVersion();
        p_416474_.accept(Component.translatable("commands.version.id", $$1.id()));
        p_416474_.accept(Component.translatable("commands.version.name", $$1.name()));
        p_416474_.accept(Component.translatable("commands.version.data", $$1.dataVersion().version()));
        p_416474_.accept(Component.translatable("commands.version.series", $$1.dataVersion().series()));
        p_416474_.accept(Component.translatable("commands.version.protocol", $$1.protocolVersion(), "0x" + Integer.toHexString($$1.protocolVersion())));
        p_416474_.accept(Component.translatable("commands.version.build_time", Component.translationArg($$1.buildTime())));
        p_416474_.accept(Component.translatable("commands.version.pack.resource", $$1.packVersion(PackType.CLIENT_RESOURCES)));
        p_416474_.accept(Component.translatable("commands.version.pack.data", $$1.packVersion(PackType.SERVER_DATA)));
        p_416474_.accept($$1.stable() ? STABLE : UNSTABLE);
    }
}

