/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PlaceCommand {
    private static final SimpleCommandExceptionType ERROR_FEATURE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType ERROR_JIGSAW_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType ERROR_STRUCTURE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType ERROR_TEMPLATE_INVALID = new DynamicCommandExceptionType(p_304274_ -> Component.translatableEscape("commands.place.template.invalid", p_304274_));
    private static final SimpleCommandExceptionType ERROR_TEMPLATE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.place.template.failed"));
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_TEMPLATES = (p_214552_, p_214553_) -> {
        StructureTemplateManager $$2 = ((CommandSourceStack)p_214552_.getSource()).getLevel().getStructureManager();
        return SharedSuggestionProvider.suggestResource($$2.listTemplates(), p_214553_);
    };

    public static void register(CommandDispatcher<CommandSourceStack> p_214548_) {
        p_214548_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("place").requires(Commands.hasPermission(2))).then(Commands.literal("feature").then(((RequiredArgumentBuilder)Commands.argument("feature", ResourceKeyArgument.key(Registries.CONFIGURED_FEATURE)).executes(p_274824_ -> PlaceCommand.placeFeature((CommandSourceStack)p_274824_.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandSourceStack>)p_274824_, "feature"), BlockPos.containing(((CommandSourceStack)p_274824_.getSource()).getPosition())))).then(Commands.argument("pos", BlockPosArgument.blockPos()).executes(p_248163_ -> PlaceCommand.placeFeature((CommandSourceStack)p_248163_.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandSourceStack>)p_248163_, "feature"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_248163_, "pos"))))))).then(Commands.literal("jigsaw").then(Commands.argument("pool", ResourceKeyArgument.key(Registries.TEMPLATE_POOL)).then(Commands.argument("target", ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)Commands.argument("max_depth", IntegerArgumentType.integer((int)1, (int)20)).executes(p_274825_ -> PlaceCommand.placeJigsaw((CommandSourceStack)p_274825_.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandSourceStack>)p_274825_, "pool"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_274825_, "target"), IntegerArgumentType.getInteger((CommandContext)p_274825_, (String)"max_depth"), BlockPos.containing(((CommandSourceStack)p_274825_.getSource()).getPosition())))).then(Commands.argument("position", BlockPosArgument.blockPos()).executes(p_248167_ -> PlaceCommand.placeJigsaw((CommandSourceStack)p_248167_.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandSourceStack>)p_248167_, "pool"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_248167_, "target"), IntegerArgumentType.getInteger((CommandContext)p_248167_, (String)"max_depth"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_248167_, "position"))))))))).then(Commands.literal("structure").then(((RequiredArgumentBuilder)Commands.argument("structure", ResourceKeyArgument.key(Registries.STRUCTURE)).executes(p_274826_ -> PlaceCommand.placeStructure((CommandSourceStack)p_274826_.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandSourceStack>)p_274826_, "structure"), BlockPos.containing(((CommandSourceStack)p_274826_.getSource()).getPosition())))).then(Commands.argument("pos", BlockPosArgument.blockPos()).executes(p_248168_ -> PlaceCommand.placeStructure((CommandSourceStack)p_248168_.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandSourceStack>)p_248168_, "structure"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_248168_, "pos"))))))).then(Commands.literal("template").then(((RequiredArgumentBuilder)Commands.argument("template", ResourceLocationArgument.id()).suggests(SUGGEST_TEMPLATES).executes(p_392744_ -> PlaceCommand.placeTemplate((CommandSourceStack)p_392744_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_392744_, "template"), BlockPos.containing(((CommandSourceStack)p_392744_.getSource()).getPosition()), Rotation.NONE, Mirror.NONE, 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(p_392741_ -> PlaceCommand.placeTemplate((CommandSourceStack)p_392741_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_392741_, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392741_, "pos"), Rotation.NONE, Mirror.NONE, 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("rotation", TemplateRotationArgument.templateRotation()).executes(p_392738_ -> PlaceCommand.placeTemplate((CommandSourceStack)p_392738_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_392738_, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392738_, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)p_392738_, "rotation"), Mirror.NONE, 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("mirror", TemplateMirrorArgument.templateMirror()).executes(p_392740_ -> PlaceCommand.placeTemplate((CommandSourceStack)p_392740_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_392740_, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392740_, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)p_392740_, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)p_392740_, "mirror"), 1.0f, 0, false))).then(((RequiredArgumentBuilder)Commands.argument("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(p_392742_ -> PlaceCommand.placeTemplate((CommandSourceStack)p_392742_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_392742_, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392742_, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)p_392742_, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)p_392742_, "mirror"), FloatArgumentType.getFloat((CommandContext)p_392742_, (String)"integrity"), 0, false))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(p_392739_ -> PlaceCommand.placeTemplate((CommandSourceStack)p_392739_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_392739_, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392739_, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)p_392739_, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)p_392739_, "mirror"), FloatArgumentType.getFloat((CommandContext)p_392739_, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)p_392739_, (String)"seed"), false))).then(Commands.literal("strict").executes(p_392743_ -> PlaceCommand.placeTemplate((CommandSourceStack)p_392743_.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)p_392743_, "template"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392743_, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandSourceStack>)p_392743_, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandSourceStack>)p_392743_, "mirror"), FloatArgumentType.getFloat((CommandContext)p_392743_, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)p_392743_, (String)"seed"), true)))))))))));
    }

    public static int placeFeature(CommandSourceStack p_214576_, Holder.Reference<ConfiguredFeature<?, ?>> p_248822_, BlockPos p_214578_) throws CommandSyntaxException {
        ServerLevel $$3 = p_214576_.getLevel();
        ConfiguredFeature<?, ?> $$4 = p_248822_.value();
        ChunkPos $$5 = new ChunkPos(p_214578_);
        PlaceCommand.checkLoaded($$3, new ChunkPos($$5.x - 1, $$5.z - 1), new ChunkPos($$5.x + 1, $$5.z + 1));
        if (!$$4.place($$3, $$3.getChunkSource().getGenerator(), $$3.getRandom(), p_214578_)) {
            throw ERROR_FEATURE_FAILED.create();
        }
        String $$6 = p_248822_.key().location().toString();
        p_214576_.sendSuccess(() -> Component.translatable("commands.place.feature.success", $$6, p_214578_.getX(), p_214578_.getY(), p_214578_.getZ()), true);
        return 1;
    }

    public static int placeJigsaw(CommandSourceStack p_214570_, Holder<StructureTemplatePool> p_214571_, ResourceLocation p_214572_, int p_214573_, BlockPos p_214574_) throws CommandSyntaxException {
        ServerLevel $$5 = p_214570_.getLevel();
        ChunkPos $$6 = new ChunkPos(p_214574_);
        PlaceCommand.checkLoaded($$5, $$6, $$6);
        if (!JigsawPlacement.generateJigsaw($$5, p_214571_, p_214572_, p_214573_, p_214574_, false)) {
            throw ERROR_JIGSAW_FAILED.create();
        }
        p_214570_.sendSuccess(() -> Component.translatable("commands.place.jigsaw.success", p_214574_.getX(), p_214574_.getY(), p_214574_.getZ()), true);
        return 1;
    }

    public static int placeStructure(CommandSourceStack p_214588_, Holder.Reference<Structure> p_251799_, BlockPos p_214590_) throws CommandSyntaxException {
        ServerLevel $$3 = p_214588_.getLevel();
        Structure $$4 = p_251799_.value();
        ChunkGenerator $$5 = $$3.getChunkSource().getGenerator();
        StructureStart $$6 = $$4.generate(p_251799_, $$3.dimension(), p_214588_.registryAccess(), $$5, $$5.getBiomeSource(), $$3.getChunkSource().randomState(), $$3.getStructureManager(), $$3.getSeed(), new ChunkPos(p_214590_), 0, $$3, p_214580_ -> true);
        if (!$$6.isValid()) {
            throw ERROR_STRUCTURE_FAILED.create();
        }
        BoundingBox $$7 = $$6.getBoundingBox();
        ChunkPos $$8 = new ChunkPos(SectionPos.blockToSectionCoord($$7.minX()), SectionPos.blockToSectionCoord($$7.minZ()));
        ChunkPos $$9 = new ChunkPos(SectionPos.blockToSectionCoord($$7.maxX()), SectionPos.blockToSectionCoord($$7.maxZ()));
        PlaceCommand.checkLoaded($$3, $$8, $$9);
        ChunkPos.rangeClosed($$8, $$9).forEach(p_428126_ -> $$6.placeInChunk($$3, $$3.structureManager(), $$5, $$3.getRandom(), new BoundingBox(p_428126_.getMinBlockX(), $$3.getMinY(), p_428126_.getMinBlockZ(), p_428126_.getMaxBlockX(), $$3.getMaxY() + 1, p_428126_.getMaxBlockZ()), (ChunkPos)p_428126_));
        String $$10 = p_251799_.key().location().toString();
        p_214588_.sendSuccess(() -> Component.translatable("commands.place.structure.success", $$10, p_214590_.getX(), p_214590_.getY(), p_214590_.getZ()), true);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int placeTemplate(CommandSourceStack p_214562_, ResourceLocation p_214563_, BlockPos p_214564_, Rotation p_214565_, Mirror p_214566_, float p_214567_, int p_214568_, boolean p_394331_) throws CommandSyntaxException {
        boolean $$15;
        void $$12;
        ServerLevel $$8 = p_214562_.getLevel();
        StructureTemplateManager $$9 = $$8.getStructureManager();
        try {
            Optional<StructureTemplate> $$10 = $$9.get(p_214563_);
        }
        catch (ResourceLocationException $$11) {
            throw ERROR_TEMPLATE_INVALID.create((Object)p_214563_);
        }
        if ($$12.isEmpty()) {
            throw ERROR_TEMPLATE_INVALID.create((Object)p_214563_);
        }
        StructureTemplate $$13 = (StructureTemplate)$$12.get();
        PlaceCommand.checkLoaded($$8, new ChunkPos(p_214564_), new ChunkPos(p_214564_.offset($$13.getSize())));
        StructurePlaceSettings $$14 = new StructurePlaceSettings().setMirror(p_214566_).setRotation(p_214565_).setKnownShape(p_394331_);
        if (p_214567_ < 1.0f) {
            $$14.clearProcessors().addProcessor(new BlockRotProcessor(p_214567_)).setRandom(StructureBlockEntity.createRandom(p_214568_));
        }
        if (!($$15 = $$13.placeInWorld($$8, p_214564_, p_214564_, $$14, StructureBlockEntity.createRandom(p_214568_), 2 | (p_394331_ ? 816 : 0)))) {
            throw ERROR_TEMPLATE_FAILED.create();
        }
        p_214562_.sendSuccess(() -> Component.translatable("commands.place.template.success", Component.translationArg(p_214563_), p_214564_.getX(), p_214564_.getY(), p_214564_.getZ()), true);
        return 1;
    }

    private static void checkLoaded(ServerLevel p_214544_, ChunkPos p_214545_, ChunkPos p_214546_) throws CommandSyntaxException {
        if (ChunkPos.rangeClosed(p_214545_, p_214546_).filter(p_313494_ -> !p_214544_.isLoaded(p_313494_.getWorldPosition())).findAny().isPresent()) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
    }
}

