/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class FillCommand {
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_304218_, p_304219_) -> Component.translatableEscape("commands.fill.toobig", p_304218_, p_304219_));
    static final BlockInput HOLLOW_CORE = new BlockInput(Blocks.AIR.defaultBlockState(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.fill.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> p_214443_, CommandBuildContext p_214444_) {
        p_214443_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("fill").requires(Commands.hasPermission(2))).then(Commands.argument("from", BlockPosArgument.blockPos()).then(Commands.argument("to", BlockPosArgument.blockPos()).then(FillCommand.wrapWithMode(p_214444_, Commands.argument("block", BlockStateArgument.block(p_214444_)), p_392711_ -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392711_, "from"), p_392705_ -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392705_, "to"), p_392692_ -> BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392692_, "block"), p_392685_ -> null).then(((LiteralArgumentBuilder)Commands.literal("replace").executes(p_392698_ -> FillCommand.fillBlocks((CommandSourceStack)p_392698_.getSource(), BoundingBox.fromCorners(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392698_, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392698_, "to")), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392698_, "block"), Mode.REPLACE, null, false))).then(FillCommand.wrapWithMode(p_214444_, Commands.argument("filter", BlockPredicateArgument.blockPredicate(p_214444_)), p_392704_ -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392704_, "from"), p_392717_ -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392717_, "to"), p_392718_ -> BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392718_, "block"), p_392684_ -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)p_392684_, "filter")))).then(Commands.literal("keep").executes(p_392691_ -> FillCommand.fillBlocks((CommandSourceStack)p_392691_.getSource(), BoundingBox.fromCorners(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392691_, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)p_392691_, "to")), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)p_392691_, "block"), Mode.REPLACE, p_180225_ -> p_180225_.getLevel().isEmptyBlock(p_180225_.getPos()), false)))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithMode(CommandBuildContext p_394423_, ArgumentBuilder<CommandSourceStack, ?> p_393983_, InCommandFunction<CommandContext<CommandSourceStack>, BlockPos> p_397131_, InCommandFunction<CommandContext<CommandSourceStack>, BlockPos> p_397847_, InCommandFunction<CommandContext<CommandSourceStack>, BlockInput> p_397185_, NullableCommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> p_394036_) {
        return p_393983_.executes(p_396538_ -> FillCommand.fillBlocks((CommandSourceStack)p_396538_.getSource(), BoundingBox.fromCorners((Vec3i)p_397131_.apply(p_396538_), (Vec3i)p_397847_.apply(p_396538_)), (BlockInput)p_397185_.apply(p_396538_), Mode.REPLACE, (Predicate)p_394036_.apply(p_396538_), false)).then(Commands.literal("outline").executes(p_396553_ -> FillCommand.fillBlocks((CommandSourceStack)p_396553_.getSource(), BoundingBox.fromCorners((Vec3i)p_397131_.apply(p_396553_), (Vec3i)p_397847_.apply(p_396553_)), (BlockInput)p_397185_.apply(p_396553_), Mode.OUTLINE, (Predicate)p_394036_.apply(p_396553_), false))).then(Commands.literal("hollow").executes(p_396548_ -> FillCommand.fillBlocks((CommandSourceStack)p_396548_.getSource(), BoundingBox.fromCorners((Vec3i)p_397131_.apply(p_396548_), (Vec3i)p_397847_.apply(p_396548_)), (BlockInput)p_397185_.apply(p_396548_), Mode.HOLLOW, (Predicate)p_394036_.apply(p_396548_), false))).then(Commands.literal("destroy").executes(p_396543_ -> FillCommand.fillBlocks((CommandSourceStack)p_396543_.getSource(), BoundingBox.fromCorners((Vec3i)p_397131_.apply(p_396543_), (Vec3i)p_397847_.apply(p_396543_)), (BlockInput)p_397185_.apply(p_396543_), Mode.DESTROY, (Predicate)p_394036_.apply(p_396543_), false))).then(Commands.literal("strict").executes(p_396558_ -> FillCommand.fillBlocks((CommandSourceStack)p_396558_.getSource(), BoundingBox.fromCorners((Vec3i)p_397131_.apply(p_396558_), (Vec3i)p_397847_.apply(p_396558_)), (BlockInput)p_397185_.apply(p_396558_), Mode.REPLACE, (Predicate)p_394036_.apply(p_396558_), true)));
    }

    private static int fillBlocks(CommandSourceStack p_137386_, BoundingBox p_137387_, BlockInput p_137388_, Mode p_137389_, @Nullable Predicate<BlockInWorld> p_137390_, boolean p_393689_) throws CommandSyntaxException {
        record UpdatedPosition(BlockPos pos, BlockState oldState) {
        }
        int $$7;
        int $$6 = p_137387_.getXSpan() * p_137387_.getYSpan() * p_137387_.getZSpan();
        if ($$6 > ($$7 = p_137386_.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)$$7, (Object)$$6);
        }
        ArrayList $$8 = Lists.newArrayList();
        ServerLevel $$9 = p_137386_.getLevel();
        if ($$9.isDebug()) {
            throw ERROR_FAILED.create();
        }
        int $$10 = 0;
        for (BlockPos $$11 : BlockPos.betweenClosed(p_137387_.minX(), p_137387_.minY(), p_137387_.minZ(), p_137387_.maxX(), p_137387_.maxY(), p_137387_.maxZ())) {
            BlockInput $$14;
            if (p_137390_ != null && !p_137390_.test(new BlockInWorld($$9, $$11, true))) continue;
            BlockState $$12 = $$9.getBlockState($$11);
            boolean $$13 = false;
            if (p_137389_.affector.affect($$9, $$11)) {
                $$13 = true;
            }
            if (($$14 = p_137389_.filter.filter(p_137387_, $$11, p_137388_, $$9)) == null) {
                if (!$$13) continue;
                ++$$10;
                continue;
            }
            if (!$$14.place($$9, $$11, 2 | (p_393689_ ? 816 : 256))) {
                if (!$$13) continue;
                ++$$10;
                continue;
            }
            if (!p_393689_) {
                $$8.add(new UpdatedPosition($$11.immutable(), $$12));
            }
            ++$$10;
        }
        for (UpdatedPosition $$15 : $$8) {
            $$9.updateNeighboursOnBlockSet($$15.pos, $$15.oldState);
        }
        if ($$10 == 0) {
            throw ERROR_FAILED.create();
        }
        int $$16 = $$10;
        p_137386_.sendSuccess(() -> Component.translatable("commands.fill.success", $$16), true);
        return $$10;
    }

    @FunctionalInterface
    static interface NullableCommandFunction<T, R> {
        @Nullable
        public R apply(T var1) throws CommandSyntaxException;
    }

    static enum Mode {
        REPLACE(Affector.NOOP, Filter.NOOP),
        OUTLINE(Affector.NOOP, (p_137428_, p_137429_, p_137430_, p_137431_) -> {
            if (p_137429_.getX() == p_137428_.minX() || p_137429_.getX() == p_137428_.maxX() || p_137429_.getY() == p_137428_.minY() || p_137429_.getY() == p_137428_.maxY() || p_137429_.getZ() == p_137428_.minZ() || p_137429_.getZ() == p_137428_.maxZ()) {
                return p_137430_;
            }
            return null;
        }),
        HOLLOW(Affector.NOOP, (p_137423_, p_137424_, p_137425_, p_137426_) -> {
            if (p_137424_.getX() == p_137423_.minX() || p_137424_.getX() == p_137423_.maxX() || p_137424_.getY() == p_137423_.minY() || p_137424_.getY() == p_137423_.maxY() || p_137424_.getZ() == p_137423_.minZ() || p_137424_.getZ() == p_137423_.maxZ()) {
                return p_137425_;
            }
            return HOLLOW_CORE;
        }),
        DESTROY((p_392719_, p_392720_) -> p_392719_.destroyBlock(p_392720_, true), Filter.NOOP);

        public final Filter filter;
        public final Affector affector;

        private Mode(Affector p_394156_, Filter p_393770_) {
            this.affector = p_394156_;
            this.filter = p_393770_;
        }
    }

    @FunctionalInterface
    public static interface Affector {
        public static final Affector NOOP = (p_393846_, p_393551_) -> false;

        public boolean affect(ServerLevel var1, BlockPos var2);
    }

    @FunctionalInterface
    public static interface Filter {
        public static final Filter NOOP = (p_394191_, p_393566_, p_394115_, p_394030_) -> p_394115_;

        @Nullable
        public BlockInput filter(BoundingBox var1, BlockPos var2, BlockInput var3, ServerLevel var4);
    }
}

