/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EffectCommands {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.clear.specific.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> p_136954_, CommandBuildContext p_251610_) {
        p_136954_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("effect").requires(Commands.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("clear").executes(p_136984_ -> EffectCommands.clearEffects((CommandSourceStack)p_136984_.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)p_136984_.getSource()).getEntityOrException())))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).executes(p_136982_ -> EffectCommands.clearEffects((CommandSourceStack)p_136982_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_136982_, "targets")))).then(Commands.argument("effect", ResourceArgument.resource(p_251610_, Registries.MOB_EFFECT)).executes(p_248126_ -> EffectCommands.clearEffect((CommandSourceStack)p_248126_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_248126_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_248126_, "effect"))))))).then(Commands.literal("give").then(Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("effect", ResourceArgument.resource(p_251610_, Registries.MOB_EFFECT)).executes(p_248127_ -> EffectCommands.giveEffect((CommandSourceStack)p_248127_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_248127_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_248127_, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)Commands.argument("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(p_248124_ -> EffectCommands.giveEffect((CommandSourceStack)p_248124_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_248124_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_248124_, "effect"), IntegerArgumentType.getInteger((CommandContext)p_248124_, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)Commands.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(p_248123_ -> EffectCommands.giveEffect((CommandSourceStack)p_248123_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_248123_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_248123_, "effect"), IntegerArgumentType.getInteger((CommandContext)p_248123_, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)p_248123_, (String)"amplifier"), true))).then(Commands.argument("hideParticles", BoolArgumentType.bool()).executes(p_248125_ -> EffectCommands.giveEffect((CommandSourceStack)p_248125_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_248125_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_248125_, "effect"), IntegerArgumentType.getInteger((CommandContext)p_248125_, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)p_248125_, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)p_248125_, (String)"hideParticles"))))))).then(((LiteralArgumentBuilder)Commands.literal("infinite").executes(p_267907_ -> EffectCommands.giveEffect((CommandSourceStack)p_267907_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_267907_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_267907_, "effect"), -1, 0, true))).then(((RequiredArgumentBuilder)Commands.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(p_267908_ -> EffectCommands.giveEffect((CommandSourceStack)p_267908_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_267908_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_267908_, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)p_267908_, (String)"amplifier"), true))).then(Commands.argument("hideParticles", BoolArgumentType.bool()).executes(p_267909_ -> EffectCommands.giveEffect((CommandSourceStack)p_267909_.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)p_267909_, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)p_267909_, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)p_267909_, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)p_267909_, (String)"hideParticles"))))))))));
    }

    private static int giveEffect(CommandSourceStack p_250553_, Collection<? extends Entity> p_250411_, Holder<MobEffect> p_249495_, @Nullable Integer p_249652_, int p_251498_, boolean p_249944_) throws CommandSyntaxException {
        int $$12;
        MobEffect $$6 = p_249495_.value();
        int $$7 = 0;
        if (p_249652_ != null) {
            if ($$6.isInstantenous()) {
                int $$8 = p_249652_;
            } else if (p_249652_ == -1) {
                int $$9 = -1;
            } else {
                int $$10 = p_249652_ * 20;
            }
        } else if ($$6.isInstantenous()) {
            boolean $$11 = true;
        } else {
            $$12 = 600;
        }
        for (Entity entity : p_250411_) {
            MobEffectInstance $$14;
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).addEffect($$14 = new MobEffectInstance(p_249495_, $$12, p_251498_, false, p_249944_), p_250553_.getEntity())) continue;
            ++$$7;
        }
        if ($$7 == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (p_250411_.size() == 1) {
            p_250553_.sendSuccess(() -> Component.translatable("commands.effect.give.success.single", $$6.getDisplayName(), ((Entity)p_250411_.iterator().next()).getDisplayName(), $$12 / 20), true);
        } else {
            p_250553_.sendSuccess(() -> Component.translatable("commands.effect.give.success.multiple", $$6.getDisplayName(), p_250411_.size(), $$12 / 20), true);
        }
        return $$7;
    }

    private static int clearEffects(CommandSourceStack p_136960_, Collection<? extends Entity> p_136961_) throws CommandSyntaxException {
        int $$2 = 0;
        for (Entity entity : p_136961_) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeAllEffects()) continue;
            ++$$2;
        }
        if ($$2 == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (p_136961_.size() == 1) {
            p_136960_.sendSuccess(() -> Component.translatable("commands.effect.clear.everything.success.single", ((Entity)p_136961_.iterator().next()).getDisplayName()), true);
        } else {
            p_136960_.sendSuccess(() -> Component.translatable("commands.effect.clear.everything.success.multiple", p_136961_.size()), true);
        }
        return $$2;
    }

    private static int clearEffect(CommandSourceStack p_250069_, Collection<? extends Entity> p_248561_, Holder<MobEffect> p_249198_) throws CommandSyntaxException {
        MobEffect $$3 = p_249198_.value();
        int $$4 = 0;
        for (Entity entity : p_248561_) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeEffect(p_249198_)) continue;
            ++$$4;
        }
        if ($$4 == 0) {
            throw ERROR_CLEAR_SPECIFIC_FAILED.create();
        }
        if (p_248561_.size() == 1) {
            p_250069_.sendSuccess(() -> Component.translatable("commands.effect.clear.specific.success.single", $$3.getDisplayName(), ((Entity)p_248561_.iterator().next()).getDisplayName()), true);
        } else {
            p_250069_.sendSuccess(() -> Component.translatable("commands.effect.clear.specific.success.multiple", $$3.getDisplayName(), p_248561_.size()), true);
        }
        return $$4;
    }
}

