/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.ticks.LevelTicks;
import org.slf4j.Logger;

public class CloneCommands {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((p_304194_, p_304195_) -> Component.translatableEscape("commands.clone.toobig", p_304194_, p_304195_));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.failed"));
    public static final Predicate<BlockInWorld> FILTER_AIR = p_359534_ -> !p_359534_.getState().isAir();

    public static void register(CommandDispatcher<CommandSourceStack> p_214424_, CommandBuildContext p_214425_) {
        p_214424_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clone").requires(Commands.hasPermission(2))).then(CloneCommands.beginEndDestinationAndModeSuffix(p_214425_, p_264757_ -> ((CommandSourceStack)p_264757_.getSource()).getLevel()))).then(Commands.literal("from").then(Commands.argument("sourceDimension", DimensionArgument.dimension()).then(CloneCommands.beginEndDestinationAndModeSuffix(p_214425_, p_264743_ -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)p_264743_, "sourceDimension"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> beginEndDestinationAndModeSuffix(CommandBuildContext p_265681_, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> p_397938_) {
        return Commands.argument("begin", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("end", BlockPosArgument.blockPos()).then(CloneCommands.destinationAndStrictSuffix(p_265681_, p_397938_, p_264751_ -> ((CommandSourceStack)p_264751_.getSource()).getLevel()))).then(Commands.literal("to").then(Commands.argument("targetDimension", DimensionArgument.dimension()).then(CloneCommands.destinationAndStrictSuffix(p_265681_, p_397938_, p_264756_ -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)p_264756_, "targetDimension"))))));
    }

    private static DimensionAndPosition getLoadedDimensionAndPosition(CommandContext<CommandSourceStack> p_265513_, ServerLevel p_265183_, String p_265511_) throws CommandSyntaxException {
        BlockPos $$3 = BlockPosArgument.getLoadedBlockPos(p_265513_, p_265183_, p_265511_);
        return new DimensionAndPosition(p_265183_, $$3);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> destinationAndStrictSuffix(CommandBuildContext p_394289_, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> p_397860_, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> p_397792_) {
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> $$3 = p_396524_ -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)p_396524_, (ServerLevel)p_397860_.apply((CommandContext<CommandSourceStack>)p_396524_), "begin");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> $$4 = p_396503_ -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)p_396503_, (ServerLevel)p_397860_.apply((CommandContext<CommandSourceStack>)p_396503_), "end");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> $$5 = p_396505_ -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)p_396505_, (ServerLevel)p_397792_.apply((CommandContext<CommandSourceStack>)p_396505_), "destination");
        return CloneCommands.modeSuffix(p_394289_, $$3, $$4, $$5, false, Commands.argument("destination", BlockPosArgument.blockPos())).then(CloneCommands.modeSuffix(p_394289_, $$3, $$4, $$5, true, Commands.literal("strict")));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> modeSuffix(CommandBuildContext p_393631_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397485_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397966_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397447_, boolean p_394427_, ArgumentBuilder<CommandSourceStack, ?> p_394612_) {
        return p_394612_.executes(p_396510_ -> CloneCommands.clone((CommandSourceStack)p_396510_.getSource(), (DimensionAndPosition)p_397485_.apply(p_396510_), (DimensionAndPosition)p_397966_.apply(p_396510_), (DimensionAndPosition)p_397447_.apply(p_396510_), p_180041_ -> true, Mode.NORMAL, p_394427_)).then(CloneCommands.wrapWithCloneMode(p_397485_, p_397966_, p_397447_, p_264738_ -> p_180033_ -> true, p_394427_, Commands.literal("replace"))).then(CloneCommands.wrapWithCloneMode(p_397485_, p_397966_, p_397447_, p_264744_ -> FILTER_AIR, p_394427_, Commands.literal("masked"))).then(Commands.literal("filtered").then(CloneCommands.wrapWithCloneMode(p_397485_, p_397966_, p_397447_, p_264745_ -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)p_264745_, "filter"), p_394427_, Commands.argument("filter", BlockPredicateArgument.blockPredicate(p_393631_)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithCloneMode(InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397931_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397162_, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> p_397777_, InCommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> p_397479_, boolean p_394385_, ArgumentBuilder<CommandSourceStack, ?> p_265069_) {
        return p_265069_.executes(p_396516_ -> CloneCommands.clone((CommandSourceStack)p_396516_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396516_), (DimensionAndPosition)p_397162_.apply(p_396516_), (DimensionAndPosition)p_397777_.apply(p_396516_), (Predicate)p_397479_.apply(p_396516_), Mode.NORMAL, p_394385_)).then(Commands.literal("force").executes(p_396530_ -> CloneCommands.clone((CommandSourceStack)p_396530_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396530_), (DimensionAndPosition)p_397162_.apply(p_396530_), (DimensionAndPosition)p_397777_.apply(p_396530_), (Predicate)p_397479_.apply(p_396530_), Mode.FORCE, p_394385_))).then(Commands.literal("move").executes(p_396522_ -> CloneCommands.clone((CommandSourceStack)p_396522_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396522_), (DimensionAndPosition)p_397162_.apply(p_396522_), (DimensionAndPosition)p_397777_.apply(p_396522_), (Predicate)p_397479_.apply(p_396522_), Mode.MOVE, p_394385_))).then(Commands.literal("normal").executes(p_396501_ -> CloneCommands.clone((CommandSourceStack)p_396501_.getSource(), (DimensionAndPosition)p_397931_.apply(p_396501_), (DimensionAndPosition)p_397162_.apply(p_396501_), (DimensionAndPosition)p_397777_.apply(p_396501_), (Predicate)p_397479_.apply(p_396501_), Mode.NORMAL, p_394385_)));
    }

    private static int clone(CommandSourceStack p_265047_, DimensionAndPosition p_265232_, DimensionAndPosition p_265188_, DimensionAndPosition p_265594_, Predicate<BlockInWorld> p_265585_, Mode p_265530_, boolean p_394351_) throws CommandSyntaxException {
        int $$16;
        BlockPos $$7 = p_265232_.position();
        BlockPos $$8 = p_265188_.position();
        BoundingBox $$9 = BoundingBox.fromCorners($$7, $$8);
        BlockPos $$10 = p_265594_.position();
        BlockPos $$11 = $$10.offset($$9.getLength());
        BoundingBox $$12 = BoundingBox.fromCorners($$10, $$11);
        ServerLevel $$13 = p_265232_.dimension();
        ServerLevel $$14 = p_265594_.dimension();
        if (!p_265530_.canOverlap() && $$13 == $$14 && $$12.intersects($$9)) {
            throw ERROR_OVERLAP.create();
        }
        int $$15 = $$9.getXSpan() * $$9.getYSpan() * $$9.getZSpan();
        if ($$15 > ($$16 = p_265047_.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)$$16, (Object)$$15);
        }
        if (!$$13.hasChunksAt($$7, $$8) || !$$14.hasChunksAt($$10, $$11)) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
        if ($$14.isDebug()) {
            throw ERROR_FAILED.create();
        }
        ArrayList $$17 = Lists.newArrayList();
        ArrayList $$18 = Lists.newArrayList();
        ArrayList $$19 = Lists.newArrayList();
        LinkedList $$20 = Lists.newLinkedList();
        int $$21 = 0;
        try (ProblemReporter.ScopedCollector $$22 = new ProblemReporter.ScopedCollector(LOGGER);){
            BlockPos $$23 = new BlockPos($$12.minX() - $$9.minX(), $$12.minY() - $$9.minY(), $$12.minZ() - $$9.minZ());
            for (int $$24 = $$9.minZ(); $$24 <= $$9.maxZ(); ++$$24) {
                for (int $$25 = $$9.minY(); $$25 <= $$9.maxY(); ++$$25) {
                    for (int $$26 = $$9.minX(); $$26 <= $$9.maxX(); ++$$26) {
                        BlockPos $$27 = new BlockPos($$26, $$25, $$24);
                        BlockPos $$28 = $$27.offset($$23);
                        BlockInWorld $$29 = new BlockInWorld($$13, $$27, false);
                        BlockState $$30 = $$29.getState();
                        if (!p_265585_.test($$29)) continue;
                        BlockEntity $$31 = $$13.getBlockEntity($$27);
                        if ($$31 != null) {
                            TagValueOutput $$32 = TagValueOutput.createWithContext($$22.forChild($$31.problemPath()), p_265047_.registryAccess());
                            $$31.saveCustomOnly($$32);
                            CloneBlockEntityInfo $$33 = new CloneBlockEntityInfo($$32.buildResult(), $$31.components());
                            $$18.add(new CloneBlockInfo($$28, $$30, $$33, $$14.getBlockState($$28)));
                            $$20.addLast($$27);
                            continue;
                        }
                        if ($$30.isSolidRender() || $$30.isCollisionShapeFullBlock($$13, $$27)) {
                            $$17.add(new CloneBlockInfo($$28, $$30, null, $$14.getBlockState($$28)));
                            $$20.addLast($$27);
                            continue;
                        }
                        $$19.add(new CloneBlockInfo($$28, $$30, null, $$14.getBlockState($$28)));
                        $$20.addFirst($$27);
                    }
                }
            }
            int $$34 = 2 | (p_394351_ ? 816 : 0);
            if (p_265530_ == Mode.MOVE) {
                for (BlockPos $$35 : $$20) {
                    $$13.setBlock($$35, Blocks.BARRIER.defaultBlockState(), $$34 | 0x330);
                }
                int $$36 = p_394351_ ? $$34 : 3;
                for (BlockPos $$37 : $$20) {
                    $$13.setBlock($$37, Blocks.AIR.defaultBlockState(), $$36);
                }
            }
            ArrayList $$38 = Lists.newArrayList();
            $$38.addAll($$17);
            $$38.addAll($$18);
            $$38.addAll($$19);
            List $$39 = Lists.reverse((List)$$38);
            for (CloneBlockInfo $$40 : $$39) {
                $$14.setBlock($$40.pos, Blocks.BARRIER.defaultBlockState(), $$34 | 0x330);
            }
            for (CloneBlockInfo $$41 : $$38) {
                if (!$$14.setBlock($$41.pos, $$41.state, $$34)) continue;
                ++$$21;
            }
            for (CloneBlockInfo $$42 : $$18) {
                BlockEntity $$43 = $$14.getBlockEntity($$42.pos);
                if ($$42.blockEntityInfo != null && $$43 != null) {
                    $$43.loadCustomOnly(TagValueInput.create($$22.forChild($$43.problemPath()), (HolderLookup.Provider)$$14.registryAccess(), $$42.blockEntityInfo.tag));
                    $$43.setComponents($$42.blockEntityInfo.components);
                    $$43.setChanged();
                }
                $$14.setBlock($$42.pos, $$42.state, $$34);
            }
            if (!p_394351_) {
                for (CloneBlockInfo $$44 : $$39) {
                    $$14.updateNeighboursOnBlockSet($$44.pos, $$44.previousStateAtDestination);
                }
            }
            ((LevelTicks)$$14.getBlockTicks()).copyAreaFrom($$13.getBlockTicks(), $$9, $$23);
        }
        if ($$21 == 0) {
            throw ERROR_FAILED.create();
        }
        int $$45 = $$21;
        p_265047_.sendSuccess(() -> Component.translatable("commands.clone.success", $$45), true);
        return $$21;
    }

    record DimensionAndPosition(ServerLevel dimension, BlockPos position) {
    }

    static enum Mode {
        FORCE(true),
        MOVE(true),
        NORMAL(false);

        private final boolean canOverlap;

        private Mode(boolean p_136795_) {
            this.canOverlap = p_136795_;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }
    }

    record CloneBlockEntityInfo(CompoundTag tag, DataComponentMap components) {
    }

    record CloneBlockInfo(BlockPos pos, BlockState state, @Nullable CloneBlockEntityInfo blockEntityInfo, BlockState previousStateAtDestination) {
    }
}

