/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Queue;
import net.minecraft.util.ArrayListDeque;

public class SuppressedExceptionCollector {
    private static final int LATEST_ENTRY_COUNT = 8;
    private final Queue<LongEntry> latestEntries = new ArrayListDeque<LongEntry>();
    private final Object2IntLinkedOpenHashMap<ShortEntry> entryCounts = new Object2IntLinkedOpenHashMap();

    private static long currentTimeMs() {
        return System.currentTimeMillis();
    }

    public synchronized void addEntry(String p_363905_, Throwable p_364135_) {
        long $$2 = SuppressedExceptionCollector.currentTimeMs();
        String $$3 = p_364135_.getMessage();
        this.latestEntries.add(new LongEntry($$2, p_363905_, p_364135_.getClass(), $$3));
        while (this.latestEntries.size() > 8) {
            this.latestEntries.remove();
        }
        ShortEntry $$4 = new ShortEntry(p_363905_, p_364135_.getClass());
        int $$5 = this.entryCounts.getInt((Object)$$4);
        this.entryCounts.putAndMoveToFirst((Object)$$4, $$5 + 1);
    }

    public synchronized String dump() {
        long $$0 = SuppressedExceptionCollector.currentTimeMs();
        StringBuilder $$1 = new StringBuilder();
        if (!this.latestEntries.isEmpty()) {
            $$1.append("\n\t\tLatest entries:\n");
            for (LongEntry $$2 : this.latestEntries) {
                $$1.append("\t\t\t").append($$2.location).append(":").append($$2.cls).append(": ").append($$2.message).append(" (").append($$0 - $$2.timestampMs).append("ms ago)").append("\n");
            }
        }
        if (!this.entryCounts.isEmpty()) {
            if ($$1.isEmpty()) {
                $$1.append("\n");
            }
            $$1.append("\t\tEntry counts:\n");
            for (Object2IntMap.Entry $$3 : Object2IntMaps.fastIterable(this.entryCounts)) {
                $$1.append("\t\t\t").append(((ShortEntry)$$3.getKey()).location).append(":").append(((ShortEntry)$$3.getKey()).cls).append(" x ").append($$3.getIntValue()).append("\n");
            }
        }
        if ($$1.isEmpty()) {
            return "~~NONE~~";
        }
        return $$1.toString();
    }

    record LongEntry(long timestampMs, String location, Class<? extends Throwable> cls, String message) {
    }

    record ShortEntry(String location, Class<? extends Throwable> cls) {
    }
}

