/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class FileToIdConverter {
    private final String prefix;
    private final String extension;

    public FileToIdConverter(String p_248876_, String p_251478_) {
        this.prefix = p_248876_;
        this.extension = p_251478_;
    }

    public static FileToIdConverter json(String p_248754_) {
        return new FileToIdConverter(p_248754_, ".json");
    }

    public static FileToIdConverter registry(ResourceKey<? extends Registry<?>> p_387510_) {
        return FileToIdConverter.json(Registries.elementsDirPath(p_387510_));
    }

    public ResourceLocation idToFile(ResourceLocation p_251878_) {
        return p_251878_.withPath(this.prefix + "/" + p_251878_.getPath() + this.extension);
    }

    public ResourceLocation fileToId(ResourceLocation p_249595_) {
        String $$1 = p_249595_.getPath();
        return p_249595_.withPath($$1.substring(this.prefix.length() + 1, $$1.length() - this.extension.length()));
    }

    public Map<ResourceLocation, Resource> listMatchingResources(ResourceManager p_252045_) {
        return p_252045_.listResources(this.prefix, p_251986_ -> p_251986_.getPath().endsWith(this.extension));
    }

    public Map<ResourceLocation, List<Resource>> listMatchingResourceStacks(ResourceManager p_249881_) {
        return p_249881_.listResourceStacks(this.prefix, p_248700_ -> p_248700_.getPath().endsWith(this.extension));
    }
}

