/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.world.phys.Vec3;

public abstract class ServerboundMovePlayerPacket
implements Packet<ServerGamePacketListener> {
    private static final int FLAG_ON_GROUND = 1;
    private static final int FLAG_HORIZONTAL_COLLISION = 2;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final float yRot;
    protected final float xRot;
    protected final boolean onGround;
    protected final boolean horizontalCollision;
    protected final boolean hasPos;
    protected final boolean hasRot;

    static int packFlags(boolean p_364286_, boolean p_362130_) {
        int $$2 = 0;
        if (p_364286_) {
            $$2 |= 1;
        }
        if (p_362130_) {
            $$2 |= 2;
        }
        return $$2;
    }

    static boolean unpackOnGround(int p_361325_) {
        return (p_361325_ & 1) != 0;
    }

    static boolean unpackHorizontalCollision(int p_364739_) {
        return (p_364739_ & 2) != 0;
    }

    protected ServerboundMovePlayerPacket(double p_179675_, double p_179676_, double p_179677_, float p_179678_, float p_179679_, boolean p_179680_, boolean p_179681_, boolean p_179682_, boolean p_361185_) {
        this.x = p_179675_;
        this.y = p_179676_;
        this.z = p_179677_;
        this.yRot = p_179678_;
        this.xRot = p_179679_;
        this.onGround = p_179680_;
        this.horizontalCollision = p_179681_;
        this.hasPos = p_179682_;
        this.hasRot = p_361185_;
    }

    @Override
    public abstract PacketType<? extends ServerboundMovePlayerPacket> type();

    @Override
    public void handle(ServerGamePacketListener p_134138_) {
        p_134138_.handleMovePlayer(this);
    }

    public double getX(double p_134130_) {
        return this.hasPos ? this.x : p_134130_;
    }

    public double getY(double p_134141_) {
        return this.hasPos ? this.y : p_134141_;
    }

    public double getZ(double p_134147_) {
        return this.hasPos ? this.z : p_134147_;
    }

    public float getYRot(float p_134132_) {
        return this.hasRot ? this.yRot : p_134132_;
    }

    public float getXRot(float p_134143_) {
        return this.hasRot ? this.xRot : p_134143_;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean horizontalCollision() {
        return this.horizontalCollision;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public static class StatusOnly
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, StatusOnly> STREAM_CODEC = Packet.codec(StatusOnly::write, StatusOnly::read);

        public StatusOnly(boolean p_179692_, boolean p_363234_) {
            super(0.0, 0.0, 0.0, 0.0f, 0.0f, p_179692_, p_363234_, false, false);
        }

        private static StatusOnly read(FriendlyByteBuf p_179698_) {
            short $$1 = p_179698_.readUnsignedByte();
            boolean $$2 = ServerboundMovePlayerPacket.unpackOnGround($$1);
            boolean $$3 = ServerboundMovePlayerPacket.unpackHorizontalCollision($$1);
            return new StatusOnly($$2, $$3);
        }

        private void write(FriendlyByteBuf p_179694_) {
            p_179694_.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<StatusOnly> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_STATUS_ONLY;
        }
    }

    public static class Rot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Rot> STREAM_CODEC = Packet.codec(Rot::write, Rot::read);

        public Rot(float p_134176_, float p_134177_, boolean p_134178_, boolean p_363477_) {
            super(0.0, 0.0, 0.0, p_134176_, p_134177_, p_134178_, p_363477_, false, true);
        }

        private static Rot read(FriendlyByteBuf p_179690_) {
            float $$1 = p_179690_.readFloat();
            float $$2 = p_179690_.readFloat();
            short $$3 = p_179690_.readUnsignedByte();
            boolean $$4 = ServerboundMovePlayerPacket.unpackOnGround($$3);
            boolean $$5 = ServerboundMovePlayerPacket.unpackHorizontalCollision($$3);
            return new Rot($$1, $$2, $$4, $$5);
        }

        private void write(FriendlyByteBuf p_134184_) {
            p_134184_.writeFloat(this.yRot);
            p_134184_.writeFloat(this.xRot);
            p_134184_.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<Rot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_ROT;
        }
    }

    public static class Pos
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Pos> STREAM_CODEC = Packet.codec(Pos::write, Pos::read);

        public Pos(Vec3 p_410242_, boolean p_410769_, boolean p_410188_) {
            super(p_410242_.x, p_410242_.y, p_410242_.z, 0.0f, 0.0f, p_410769_, p_410188_, true, false);
        }

        public Pos(double p_134150_, double p_134151_, double p_134152_, boolean p_134153_, boolean p_361686_) {
            super(p_134150_, p_134151_, p_134152_, 0.0f, 0.0f, p_134153_, p_361686_, true, false);
        }

        private static Pos read(FriendlyByteBuf p_179686_) {
            double $$1 = p_179686_.readDouble();
            double $$2 = p_179686_.readDouble();
            double $$3 = p_179686_.readDouble();
            short $$4 = p_179686_.readUnsignedByte();
            boolean $$5 = ServerboundMovePlayerPacket.unpackOnGround($$4);
            boolean $$6 = ServerboundMovePlayerPacket.unpackHorizontalCollision($$4);
            return new Pos($$1, $$2, $$3, $$5, $$6);
        }

        private void write(FriendlyByteBuf p_134159_) {
            p_134159_.writeDouble(this.x);
            p_134159_.writeDouble(this.y);
            p_134159_.writeDouble(this.z);
            p_134159_.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<Pos> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS;
        }
    }

    public static class PosRot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, PosRot> STREAM_CODEC = Packet.codec(PosRot::write, PosRot::read);

        public PosRot(Vec3 p_410318_, float p_409896_, float p_410082_, boolean p_410593_, boolean p_409721_) {
            super(p_410318_.x, p_410318_.y, p_410318_.z, p_409896_, p_410082_, p_410593_, p_409721_, true, true);
        }

        public PosRot(double p_134162_, double p_134163_, double p_134164_, float p_134165_, float p_134166_, boolean p_134167_, boolean p_362765_) {
            super(p_134162_, p_134163_, p_134164_, p_134165_, p_134166_, p_134167_, p_362765_, true, true);
        }

        private static PosRot read(FriendlyByteBuf p_179688_) {
            double $$1 = p_179688_.readDouble();
            double $$2 = p_179688_.readDouble();
            double $$3 = p_179688_.readDouble();
            float $$4 = p_179688_.readFloat();
            float $$5 = p_179688_.readFloat();
            short $$6 = p_179688_.readUnsignedByte();
            boolean $$7 = ServerboundMovePlayerPacket.unpackOnGround($$6);
            boolean $$8 = ServerboundMovePlayerPacket.unpackHorizontalCollision($$6);
            return new PosRot($$1, $$2, $$3, $$4, $$5, $$7, $$8);
        }

        private void write(FriendlyByteBuf p_134173_) {
            p_134173_.writeDouble(this.x);
            p_134173_.writeDouble(this.y);
            p_134173_.writeDouble(this.z);
            p_134173_.writeFloat(this.yRot);
            p_134173_.writeFloat(this.xRot);
            p_134173_.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<PosRot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS_ROT;
        }
    }
}

