/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundCommandsPacket> STREAM_CODEC = Packet.codec(ClientboundCommandsPacket::write, ClientboundCommandsPacket::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte FLAG_RESTRICTED = 32;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public <S> ClientboundCommandsPacket(RootCommandNode<S> p_131861_, NodeInspector<S> p_426113_) {
        Object2IntMap<CommandNode<S>> $$2 = ClientboundCommandsPacket.enumerateNodes(p_131861_);
        this.entries = ClientboundCommandsPacket.createEntries($$2, p_426113_);
        this.rootIndex = $$2.getInt(p_131861_);
    }

    private ClientboundCommandsPacket(FriendlyByteBuf p_178805_) {
        this.entries = p_178805_.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = p_178805_.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    private void write(FriendlyByteBuf p_131886_) {
        p_131886_.writeCollection(this.entries, (p_237642_, p_237643_) -> p_237643_.write((FriendlyByteBuf)((Object)p_237642_)));
        p_131886_.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> p_237631_, BiPredicate<Entry, IntSet> p_237632_) {
        IntOpenHashSet $$2 = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)p_237631_.size()));
        while (!$$2.isEmpty()) {
            boolean $$3 = $$2.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(p_237632_, p_237631_, (IntSet)$$2, arg_0));
            if ($$3) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> p_237629_) {
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(p_237629_, Entry::canResolve);
    }

    private static <S> Object2IntMap<CommandNode<S>> enumerateNodes(RootCommandNode<S> p_131863_) {
        CommandNode $$3;
        Object2IntOpenHashMap $$1 = new Object2IntOpenHashMap();
        ArrayDeque<Object> $$2 = new ArrayDeque<Object>();
        $$2.add(p_131863_);
        while (($$3 = (CommandNode)$$2.poll()) != null) {
            if ($$1.containsKey((Object)$$3)) continue;
            int $$4 = $$1.size();
            $$1.put((Object)$$3, $$4);
            $$2.addAll($$3.getChildren());
            if ($$3.getRedirect() == null) continue;
            $$2.add($$3.getRedirect());
        }
        return $$1;
    }

    private static <S> List<Entry> createEntries(Object2IntMap<CommandNode<S>> p_237627_, NodeInspector<S> p_425698_) {
        ObjectArrayList $$2 = new ObjectArrayList(p_237627_.size());
        $$2.size(p_237627_.size());
        for (Object2IntMap.Entry $$3 : Object2IntMaps.fastIterable(p_237627_)) {
            $$2.set($$3.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode)$$3.getKey(), p_425698_, p_237627_));
        }
        return $$2;
    }

    private static Entry readNode(FriendlyByteBuf p_131888_) {
        byte $$1 = p_131888_.readByte();
        int[] $$2 = p_131888_.readVarIntArray();
        int $$3 = ($$1 & 8) != 0 ? p_131888_.readVarInt() : 0;
        NodeStub $$4 = ClientboundCommandsPacket.read(p_131888_, $$1);
        return new Entry($$4, $$1, $$3, $$2);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf p_237639_, byte p_237640_) {
        int $$2 = p_237640_ & 3;
        if ($$2 == 2) {
            String $$3 = p_237639_.readUtf();
            int $$4 = p_237639_.readVarInt();
            ArgumentTypeInfo $$5 = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId($$4);
            if ($$5 == null) {
                return null;
            }
            Object $$6 = $$5.deserializeFromNetwork(p_237639_);
            ResourceLocation $$7 = (p_237640_ & 0x10) != 0 ? p_237639_.readResourceLocation() : null;
            return new ArgumentNodeStub($$3, (ArgumentTypeInfo.Template<?>)$$6, $$7);
        }
        if ($$2 == 1) {
            String $$8 = p_237639_.readUtf();
            return new LiteralNodeStub($$8);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static <S> Entry createEntry(CommandNode<S> p_237622_, NodeInspector<S> p_425626_, Object2IntMap<CommandNode<S>> p_237623_) {
        void $$13;
        int $$5;
        int $$3 = 0;
        if (p_237622_.getRedirect() != null) {
            $$3 |= 8;
            int $$4 = p_237623_.getInt((Object)p_237622_.getRedirect());
        } else {
            $$5 = 0;
        }
        if (p_425626_.isExecutable(p_237622_)) {
            $$3 |= 4;
        }
        if (p_425626_.isRestricted(p_237622_)) {
            $$3 |= 0x20;
        }
        CommandNode<S> commandNode = p_237622_;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, ArgumentCommandNode.class, LiteralCommandNode.class}, commandNode2, n)) {
            case 0: {
                RootCommandNode $$6 = (RootCommandNode)commandNode2;
                $$3 |= 0;
                Object $$7 = null;
                break;
            }
            case 1: {
                ArgumentCommandNode $$8 = (ArgumentCommandNode)commandNode2;
                ResourceLocation $$9 = p_425626_.suggestionId($$8);
                ArgumentNodeStub $$10 = new ArgumentNodeStub($$8.getName(), ArgumentTypeInfos.unpack($$8.getType()), $$9);
                $$3 |= 2;
                if ($$9 != null) {
                    $$3 |= 0x10;
                }
                break;
            }
            case 2: {
                LiteralCommandNode $$11 = (LiteralCommandNode)commandNode2;
                LiteralNodeStub $$12 = new LiteralNodeStub($$11.getLiteral());
                $$3 |= 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(p_237622_));
            }
        }
        int[] $$14 = p_237622_.getChildren().stream().mapToInt(arg_0 -> p_237623_.getInt(arg_0)).toArray();
        return new Entry((NodeStub)$$13, $$3, $$5, $$14);
    }

    @Override
    public PacketType<ClientboundCommandsPacket> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    public void handle(ClientGamePacketListener p_131878_) {
        p_131878_.handleCommands(this);
    }

    public <S> RootCommandNode<S> getRoot(CommandBuildContext p_237625_, NodeBuilder<S> p_426329_) {
        return (RootCommandNode)new NodeResolver<S>(p_237625_, p_426329_, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate p_237634_, List p_237635_, IntSet p_237636_, int p_237637_) {
        return p_237634_.test((Entry)p_237635_.get(p_237637_), p_237636_);
    }

    public static interface NodeInspector<S> {
        @Nullable
        public ResourceLocation suggestionId(ArgumentCommandNode<S, ?> var1);

        public boolean isExecutable(CommandNode<S> var1);

        public boolean isRestricted(CommandNode<S> var1);
    }

    record Entry(@Nullable NodeStub stub, int flags, int redirect, int[] children) {
        public void write(FriendlyByteBuf p_237675_) {
            p_237675_.writeByte(this.flags);
            p_237675_.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                p_237675_.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(p_237675_);
            }
        }

        public boolean canBuild(IntSet p_237673_) {
            if ((this.flags & 8) != 0) {
                return !p_237673_.contains(this.redirect);
            }
            return true;
        }

        public boolean canResolve(IntSet p_237677_) {
            for (int $$1 : this.children) {
                if (!p_237677_.contains($$1)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var1, NodeBuilder<S> var2);

        public void write(FriendlyByteBuf var1);
    }

    record ArgumentNodeStub(String id, ArgumentTypeInfo.Template<?> argumentType, @Nullable ResourceLocation suggestionId) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext p_237656_, NodeBuilder<S> p_426292_) {
            Object $$2 = this.argumentType.instantiate(p_237656_);
            return p_426292_.createArgument(this.id, (ArgumentType<?>)$$2, this.suggestionId);
        }

        @Override
        public void write(FriendlyByteBuf p_237658_) {
            p_237658_.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(p_237658_, this.argumentType);
            if (this.suggestionId != null) {
                p_237658_.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf p_237660_, ArgumentTypeInfo.Template<A> p_237661_) {
            ArgumentNodeStub.serializeCap(p_237660_, p_237661_.type(), p_237661_);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf p_237663_, ArgumentTypeInfo<A, T> p_237664_, ArgumentTypeInfo.Template<A> p_237665_) {
            p_237663_.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(p_237664_));
            p_237664_.serializeToNetwork(p_237665_, p_237663_);
        }
    }

    record LiteralNodeStub(String id) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext p_237682_, NodeBuilder<S> p_426272_) {
            return p_426272_.createLiteral(this.id);
        }

        @Override
        public void write(FriendlyByteBuf p_237684_) {
            p_237684_.writeUtf(this.id);
        }
    }

    static class NodeResolver<S> {
        private final CommandBuildContext context;
        private final NodeBuilder<S> builder;
        private final List<Entry> entries;
        private final List<CommandNode<S>> nodes;

        NodeResolver(CommandBuildContext p_237689_, NodeBuilder<S> p_425914_, List<Entry> p_237690_) {
            this.context = p_237689_;
            this.builder = p_425914_;
            this.entries = p_237690_;
            ObjectArrayList $$3 = new ObjectArrayList();
            $$3.size(p_237690_.size());
            this.nodes = $$3;
        }

        public CommandNode<S> resolve(int p_237692_) {
            CommandNode $$7;
            CommandNode<S> $$1 = this.nodes.get(p_237692_);
            if ($$1 != null) {
                return $$1;
            }
            Entry $$2 = this.entries.get(p_237692_);
            if ($$2.stub == null) {
                RootCommandNode $$3 = new RootCommandNode();
            } else {
                ArgumentBuilder<S, ?> $$4 = $$2.stub.build(this.context, this.builder);
                if (($$2.flags & 8) != 0) {
                    $$4.redirect(this.resolve($$2.redirect));
                }
                boolean $$5 = ($$2.flags & 4) != 0;
                boolean $$6 = ($$2.flags & 0x20) != 0;
                $$7 = this.builder.configure($$4, $$5, $$6).build();
            }
            this.nodes.set(p_237692_, $$7);
            for (int $$8 : $$2.children) {
                CommandNode<S> $$9 = this.resolve($$8);
                if ($$9 instanceof RootCommandNode) continue;
                $$7.addChild($$9);
            }
            return $$7;
        }
    }

    public static interface NodeBuilder<S> {
        public ArgumentBuilder<S, ?> createLiteral(String var1);

        public ArgumentBuilder<S, ?> createArgument(String var1, ArgumentType<?> var2, @Nullable ResourceLocation var3);

        public ArgumentBuilder<S, ?> configure(ArgumentBuilder<S, ?> var1, boolean var2, boolean var3);
    }
}

