/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;

public record ScoreContents(Either<SelectorPattern, String> name, String objective) implements ComponentContents
{
    public static final MapCodec<ScoreContents> INNER_CODEC = RecordCodecBuilder.mapCodec(p_359467_ -> p_359467_.group((App)Codec.either(SelectorPattern.CODEC, (Codec)Codec.STRING).fieldOf("name").forGetter(ScoreContents::name), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreContents::objective)).apply((Applicative)p_359467_, ScoreContents::new));
    public static final MapCodec<ScoreContents> CODEC = INNER_CODEC.fieldOf("score");
    public static final ComponentContents.Type<ScoreContents> TYPE = new ComponentContents.Type<ScoreContents>(CODEC, "score");

    @Override
    public ComponentContents.Type<?> type() {
        return TYPE;
    }

    private ScoreHolder findTargetName(CommandSourceStack p_237442_) throws CommandSyntaxException {
        Optional $$1 = this.name.left();
        if ($$1.isPresent()) {
            List<? extends Entity> $$2 = ((SelectorPattern)$$1.get()).resolved().findEntities(p_237442_);
            if (!$$2.isEmpty()) {
                if ($$2.size() != 1) {
                    throw EntityArgument.ERROR_NOT_SINGLE_ENTITY.create();
                }
                return $$2.getFirst();
            }
            return ScoreHolder.forNameOnly(((SelectorPattern)$$1.get()).pattern());
        }
        return ScoreHolder.forNameOnly((String)this.name.right().orElseThrow());
    }

    private MutableComponent getScore(ScoreHolder p_313863_, CommandSourceStack p_237451_) {
        ReadOnlyScoreInfo $$5;
        ServerScoreboard $$3;
        Objective $$4;
        MinecraftServer $$2 = p_237451_.getServer();
        if ($$2 != null && ($$4 = ($$3 = $$2.getScoreboard()).getObjective(this.objective)) != null && ($$5 = $$3.getPlayerScoreInfo(p_313863_, $$4)) != null) {
            return $$5.formatValue($$4.numberFormatOrDefault(StyledFormat.NO_STYLE));
        }
        return Component.empty();
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack p_237444_, @Nullable Entity p_237445_, int p_237446_) throws CommandSyntaxException {
        if (p_237444_ == null) {
            return Component.empty();
        }
        ScoreHolder $$3 = this.findTargetName(p_237444_);
        ScoreHolder $$4 = p_237445_ != null && $$3.equals(ScoreHolder.WILDCARD) ? p_237445_ : $$3;
        return this.getScore($$4, p_237444_);
    }

    @Override
    public String toString() {
        return "score{name='" + String.valueOf(this.name) + "', objective='" + this.objective + "'}";
    }
}

