/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.parsing.packrat.commands.Grammar;

public class TagParser<T> {
    public static final SimpleCommandExceptionType ERROR_TRAILING_DATA = new SimpleCommandExceptionType((Message)Component.translatable("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_COMPOUND = new SimpleCommandExceptionType((Message)Component.translatable("argument.nbt.expected.compound"));
    public static final char ELEMENT_SEPARATOR = ',';
    public static final char NAME_VALUE_SEPARATOR = ':';
    private static final TagParser<Tag> NBT_OPS_PARSER = TagParser.create(NbtOps.INSTANCE);
    public static final Codec<CompoundTag> FLATTENED_CODEC = Codec.STRING.comapFlatMap(p_409150_ -> {
        try {
            Tag $$1 = NBT_OPS_PARSER.parseFully((String)p_409150_);
            if ($$1 instanceof CompoundTag) {
                CompoundTag $$2 = (CompoundTag)$$1;
                return DataResult.success((Object)$$2, (Lifecycle)Lifecycle.stable());
            }
            return DataResult.error(() -> "Expected compound tag, got " + String.valueOf($$1));
        }
        catch (CommandSyntaxException $$3) {
            return DataResult.error(() -> ((CommandSyntaxException)$$3).getMessage());
        }
    }, CompoundTag::toString);
    public static final Codec<CompoundTag> LENIENT_CODEC = Codec.withAlternative(FLATTENED_CODEC, CompoundTag.CODEC);
    private final DynamicOps<T> ops;
    private final Grammar<T> grammar;

    private TagParser(DynamicOps<T> p_412361_, Grammar<T> p_410792_) {
        this.ops = p_412361_;
        this.grammar = p_410792_;
    }

    public DynamicOps<T> getOps() {
        return this.ops;
    }

    public static <T> TagParser<T> create(DynamicOps<T> p_410391_) {
        return new TagParser<T>(p_410391_, SnbtGrammar.createParser(p_410391_));
    }

    private static CompoundTag castToCompoundOrThrow(StringReader p_400179_, Tag p_399751_) throws CommandSyntaxException {
        if (p_399751_ instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)p_399751_;
            return $$2;
        }
        throw ERROR_EXPECTED_COMPOUND.createWithContext((ImmutableStringReader)p_400179_);
    }

    public static CompoundTag parseCompoundFully(String p_399485_) throws CommandSyntaxException {
        StringReader $$1 = new StringReader(p_399485_);
        return TagParser.castToCompoundOrThrow($$1, NBT_OPS_PARSER.parseFully($$1));
    }

    public T parseFully(String p_400269_) throws CommandSyntaxException {
        return this.parseFully(new StringReader(p_400269_));
    }

    public T parseFully(StringReader p_399809_) throws CommandSyntaxException {
        T $$1 = this.grammar.parseForCommands(p_399809_);
        p_399809_.skipWhitespace();
        if (p_399809_.canRead()) {
            throw ERROR_TRAILING_DATA.createWithContext((ImmutableStringReader)p_399809_);
        }
        return $$1;
    }

    public T parseAsArgument(StringReader p_399865_) throws CommandSyntaxException {
        return this.grammar.parseForCommands(p_399865_);
    }

    public static CompoundTag parseCompoundAsArgument(StringReader p_399536_) throws CommandSyntaxException {
        Tag $$1 = NBT_OPS_PARSER.parseAsArgument(p_399536_);
        return TagParser.castToCompoundOrThrow(p_399536_, $$1);
    }
}

