/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;

public class StringTagVisitor
implements TagVisitor {
    private static final Pattern UNQUOTED_KEY_MATCH = Pattern.compile("[A-Za-z._]+[A-Za-z0-9._+-]*");
    private final StringBuilder builder = new StringBuilder();

    public String build() {
        return this.builder.toString();
    }

    @Override
    public void visitString(StringTag p_178186_) {
        this.builder.append(StringTag.quoteAndEscape(p_178186_.value()));
    }

    @Override
    public void visitByte(ByteTag p_178164_) {
        this.builder.append(p_178164_.value()).append('b');
    }

    @Override
    public void visitShort(ShortTag p_178184_) {
        this.builder.append(p_178184_.value()).append('s');
    }

    @Override
    public void visitInt(IntTag p_178176_) {
        this.builder.append(p_178176_.value());
    }

    @Override
    public void visitLong(LongTag p_178182_) {
        this.builder.append(p_178182_.value()).append('L');
    }

    @Override
    public void visitFloat(FloatTag p_178172_) {
        this.builder.append(p_178172_.value()).append('f');
    }

    @Override
    public void visitDouble(DoubleTag p_178168_) {
        this.builder.append(p_178168_.value()).append('d');
    }

    @Override
    public void visitByteArray(ByteArrayTag p_178162_) {
        this.builder.append("[B;");
        byte[] $$1 = p_178162_.getAsByteArray();
        for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
            if ($$2 != 0) {
                this.builder.append(',');
            }
            this.builder.append($$1[$$2]).append('B');
        }
        this.builder.append(']');
    }

    @Override
    public void visitIntArray(IntArrayTag p_178174_) {
        this.builder.append("[I;");
        int[] $$1 = p_178174_.getAsIntArray();
        for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
            if ($$2 != 0) {
                this.builder.append(',');
            }
            this.builder.append($$1[$$2]);
        }
        this.builder.append(']');
    }

    @Override
    public void visitLongArray(LongArrayTag p_178180_) {
        this.builder.append("[L;");
        long[] $$1 = p_178180_.getAsLongArray();
        for (int $$2 = 0; $$2 < $$1.length; ++$$2) {
            if ($$2 != 0) {
                this.builder.append(',');
            }
            this.builder.append($$1[$$2]).append('L');
        }
        this.builder.append(']');
    }

    @Override
    public void visitList(ListTag p_178178_) {
        this.builder.append('[');
        for (int $$1 = 0; $$1 < p_178178_.size(); ++$$1) {
            if ($$1 != 0) {
                this.builder.append(',');
            }
            p_178178_.get($$1).accept(this);
        }
        this.builder.append(']');
    }

    @Override
    public void visitCompound(CompoundTag p_178166_) {
        this.builder.append('{');
        ArrayList<Map.Entry<String, Tag>> $$1 = new ArrayList<Map.Entry<String, Tag>>(p_178166_.entrySet());
        $$1.sort(Map.Entry.comparingByKey());
        for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
            Map.Entry $$3 = (Map.Entry)$$1.get($$2);
            if ($$2 != 0) {
                this.builder.append(',');
            }
            this.handleKeyEscape((String)$$3.getKey());
            this.builder.append(':');
            ((Tag)$$3.getValue()).accept(this);
        }
        this.builder.append('}');
    }

    private void handleKeyEscape(String p_410226_) {
        if (!p_410226_.equalsIgnoreCase("true") && !p_410226_.equalsIgnoreCase("false") && UNQUOTED_KEY_MATCH.matcher(p_410226_).matches()) {
            this.builder.append(p_410226_);
        } else {
            StringTag.quoteAndEscape(p_410226_, this.builder);
        }
    }

    @Override
    public void visitEnd(EndTag p_178170_) {
        this.builder.append("END");
    }
}

