/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.SnbtOperations;
import net.minecraft.network.chat.Component;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.GreedyPatternParseRule;
import net.minecraft.util.parsing.packrat.commands.GreedyPredicateParseRule;
import net.minecraft.util.parsing.packrat.commands.NumberRunParseRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.UnquotedStringParseRule;

public class SnbtGrammar {
    private static final DynamicCommandExceptionType ERROR_NUMBER_PARSE_FAILURE = new DynamicCommandExceptionType(p_410234_ -> Component.translatableEscape("snbt.parser.number_parse_failure", p_410234_));
    static final DynamicCommandExceptionType ERROR_EXPECTED_HEX_ESCAPE = new DynamicCommandExceptionType(p_410336_ -> Component.translatableEscape("snbt.parser.expected_hex_escape", p_410336_));
    private static final DynamicCommandExceptionType ERROR_INVALID_CODEPOINT = new DynamicCommandExceptionType(p_411037_ -> Component.translatableEscape("snbt.parser.invalid_codepoint", p_411037_));
    private static final DynamicCommandExceptionType ERROR_NO_SUCH_OPERATION = new DynamicCommandExceptionType(p_411036_ -> Component.translatableEscape("snbt.parser.no_such_operation", p_411036_));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_INTEGER_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_integer_type")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_FLOAT_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_float_type")));
    static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_NON_NEGATIVE_NUMBER = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_non_negative_number")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_CHARACTER_NAME = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_character_name")));
    static final DelayedException<CommandSyntaxException> ERROR_INVALID_ARRAY_ELEMENT_TYPE = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_array_element_type")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_UNQUOTED_START = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_unquoted_start")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_UNQUOTED_STRING = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_unquoted_string")));
    private static final DelayedException<CommandSyntaxException> ERROR_INVALID_STRING_CONTENTS = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.invalid_string_contents")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_BINARY_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_binary_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_UNDESCORE_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.underscore_not_allowed")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_DECIMAL_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_decimal_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_EXPECTED_HEX_NUMERAL = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.expected_hex_numeral")));
    private static final DelayedException<CommandSyntaxException> ERROR_EMPTY_KEY = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.empty_key")));
    private static final DelayedException<CommandSyntaxException> ERROR_LEADING_ZERO_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.leading_zero_not_allowed")));
    private static final DelayedException<CommandSyntaxException> ERROR_INFINITY_NOT_ALLOWED = DelayedException.create(new SimpleCommandExceptionType((Message)Component.translatable("snbt.parser.infinity_not_allowed")));
    private static final HexFormat HEX_ESCAPE = HexFormat.of().withUpperCase();
    private static final NumberRunParseRule BINARY_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_BINARY_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char p_409763_) {
            return switch (p_409763_) {
                case '0', '1', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule DECIMAL_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_DECIMAL_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char p_410507_) {
            return switch (p_410507_) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule HEX_NUMERAL = new NumberRunParseRule((DelayedException)ERROR_EXPECTED_HEX_NUMERAL, (DelayedException)ERROR_UNDESCORE_NOT_ALLOWED){

        @Override
        protected boolean isAccepted(char p_410332_) {
            return switch (p_410332_) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '_', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    };
    private static final GreedyPredicateParseRule PLAIN_STRING_CHUNK = new GreedyPredicateParseRule(1, (DelayedException)ERROR_INVALID_STRING_CONTENTS){

        @Override
        protected boolean isAccepted(char p_410102_) {
            return switch (p_410102_) {
                case '\"', '\'', '\\' -> false;
                default -> true;
            };
        }
    };
    private static final StringReaderTerms.TerminalCharacters NUMBER_LOOKEAHEAD = new StringReaderTerms.TerminalCharacters(CharList.of()){

        @Override
        protected boolean isAccepted(char p_410066_) {
            return SnbtGrammar.canStartNumber(p_410066_);
        }
    };
    private static final Pattern UNICODE_NAME = Pattern.compile("[-a-zA-Z0-9 ]+");

    static DelayedException<CommandSyntaxException> createNumberParseError(NumberFormatException p_410491_) {
        return DelayedException.create(ERROR_NUMBER_PARSE_FAILURE, p_410491_.getMessage());
    }

    @Nullable
    public static String escapeControlCharacters(char p_410776_) {
        return switch (p_410776_) {
            case '\b' -> "b";
            case '\t' -> "t";
            case '\n' -> "n";
            case '\f' -> "f";
            case '\r' -> "r";
            default -> p_410776_ < ' ' ? "x" + HEX_ESCAPE.toHexDigits((byte)p_410776_) : null;
        };
    }

    private static boolean isAllowedToStartUnquotedString(char p_410198_) {
        return !SnbtGrammar.canStartNumber(p_410198_);
    }

    static boolean canStartNumber(char p_410692_) {
        return switch (p_410692_) {
            case '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> true;
            default -> false;
        };
    }

    static boolean needsUnderscoreRemoval(String p_410362_) {
        return p_410362_.indexOf(95) != -1;
    }

    private static void cleanAndAppend(StringBuilder p_409818_, String p_410616_) {
        SnbtGrammar.cleanAndAppend(p_409818_, p_410616_, SnbtGrammar.needsUnderscoreRemoval(p_410616_));
    }

    static void cleanAndAppend(StringBuilder p_410205_, String p_410044_, boolean p_410535_) {
        if (p_410535_) {
            for (char $$3 : p_410044_.toCharArray()) {
                if ($$3 == '_') continue;
                p_410205_.append($$3);
            }
        } else {
            p_410205_.append(p_410044_);
        }
    }

    static short parseUnsignedShort(String p_410720_, int p_409913_) {
        int $$2 = Integer.parseInt(p_410720_, p_409913_);
        if ($$2 >> 16 == 0) {
            return (short)$$2;
        }
        throw new NumberFormatException("out of range: " + $$2);
    }

    @Nullable
    private static <T> T createFloat(DynamicOps<T> p_410880_, Sign p_409652_, @Nullable String p_410345_, @Nullable String p_410114_, @Nullable Signed<String> p_409756_, @Nullable TypeSuffix p_410824_, ParseState<?> p_410041_) {
        StringBuilder $$7 = new StringBuilder();
        p_409652_.append($$7);
        if (p_410345_ != null) {
            SnbtGrammar.cleanAndAppend($$7, p_410345_);
        }
        if (p_410114_ != null) {
            $$7.append('.');
            SnbtGrammar.cleanAndAppend($$7, p_410114_);
        }
        if (p_409756_ != null) {
            $$7.append('e');
            p_409756_.sign().append($$7);
            SnbtGrammar.cleanAndAppend($$7, (String)p_409756_.value);
        }
        try {
            String $$8 = $$7.toString();
            TypeSuffix typeSuffix = p_410824_;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FLOAT", "DOUBLE"}, (TypeSuffix)typeSuffix, n)) {
                case 0 -> SnbtGrammar.convertFloat(p_410880_, p_410041_, $$8);
                case 1 -> SnbtGrammar.convertDouble(p_410880_, p_410041_, $$8);
                case -1 -> SnbtGrammar.convertDouble(p_410880_, p_410041_, $$8);
                default -> {
                    p_410041_.errorCollector().store(p_410041_.mark(), ERROR_EXPECTED_FLOAT_TYPE);
                    yield null;
                }
            };
        }
        catch (NumberFormatException $$9) {
            p_410041_.errorCollector().store(p_410041_.mark(), SnbtGrammar.createNumberParseError($$9));
            return null;
        }
    }

    @Nullable
    private static <T> T convertFloat(DynamicOps<T> p_411050_, ParseState<?> p_411078_, String p_411046_) {
        float $$3 = Float.parseFloat(p_411046_);
        if (!Float.isFinite($$3)) {
            p_411078_.errorCollector().store(p_411078_.mark(), ERROR_INFINITY_NOT_ALLOWED);
            return null;
        }
        return (T)p_411050_.createFloat($$3);
    }

    @Nullable
    private static <T> T convertDouble(DynamicOps<T> p_411053_, ParseState<?> p_411063_, String p_411059_) {
        double $$3 = Double.parseDouble(p_411059_);
        if (!Double.isFinite($$3)) {
            p_411063_.errorCollector().store(p_411063_.mark(), ERROR_INFINITY_NOT_ALLOWED);
            return null;
        }
        return (T)p_411053_.createDouble($$3);
    }

    private static String joinList(List<String> p_409729_) {
        return switch (p_409729_.size()) {
            case 0 -> "";
            case 1 -> p_409729_.getFirst();
            default -> String.join((CharSequence)"", p_409729_);
        };
    }

    public static <T> Grammar<T> createParser(DynamicOps<T> p_409979_) {
        Object $$1 = p_409979_.createBoolean(true);
        Object $$2 = p_409979_.createBoolean(false);
        Object $$3 = p_409979_.emptyMap();
        Object $$4 = p_409979_.emptyList();
        Dictionary<StringReader> $$5 = new Dictionary<StringReader>();
        Atom $$6 = Atom.of("sign");
        $$5.put($$6, Term.alternative(Term.sequence(StringReaderTerms.character('+'), Term.marker($$6, Sign.PLUS)), Term.sequence(StringReaderTerms.character('-'), Term.marker($$6, Sign.MINUS))), p_410526_ -> (Sign)((Object)((Object)p_410526_.getOrThrow($$6))));
        Atom $$7 = Atom.of("integer_suffix");
        $$5.put($$7, Term.alternative(Term.sequence(StringReaderTerms.characters('u', 'U'), Term.alternative(Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker($$7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker($$7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker($$7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker($$7, new IntegerSuffix(SignedPrefix.UNSIGNED, TypeSuffix.LONG))))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.alternative(Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker($$7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker($$7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker($$7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker($$7, new IntegerSuffix(SignedPrefix.SIGNED, TypeSuffix.LONG))))), Term.sequence(StringReaderTerms.characters('b', 'B'), Term.marker($$7, new IntegerSuffix(null, TypeSuffix.BYTE))), Term.sequence(StringReaderTerms.characters('s', 'S'), Term.marker($$7, new IntegerSuffix(null, TypeSuffix.SHORT))), Term.sequence(StringReaderTerms.characters('i', 'I'), Term.marker($$7, new IntegerSuffix(null, TypeSuffix.INT))), Term.sequence(StringReaderTerms.characters('l', 'L'), Term.marker($$7, new IntegerSuffix(null, TypeSuffix.LONG)))), p_409993_ -> (IntegerSuffix)p_409993_.getOrThrow($$7));
        Atom $$8 = Atom.of("binary_numeral");
        $$5.put($$8, BINARY_NUMERAL);
        Atom $$9 = Atom.of("decimal_numeral");
        $$5.put($$9, DECIMAL_NUMERAL);
        Atom $$10 = Atom.of("hex_numeral");
        $$5.put($$10, HEX_NUMERAL);
        Atom $$11 = Atom.of("integer_literal");
        NamedRule $$12 = $$5.put($$11, Term.sequence(Term.optional($$5.named($$6)), Term.alternative(Term.sequence(StringReaderTerms.character('0'), Term.cut(), Term.alternative(Term.sequence(StringReaderTerms.characters('x', 'X'), Term.cut(), $$5.named($$10)), Term.sequence(StringReaderTerms.characters('b', 'B'), $$5.named($$8)), Term.sequence($$5.named($$9), Term.cut(), Term.fail(ERROR_LEADING_ZERO_NOT_ALLOWED)), Term.marker($$9, "0"))), $$5.named($$9)), Term.optional($$5.named($$7))), p_409716_ -> {
            IntegerSuffix $$6 = p_409716_.getOrDefault($$7, IntegerSuffix.EMPTY);
            Sign $$7 = p_409716_.getOrDefault($$6, Sign.PLUS);
            String $$8 = (String)p_409716_.get($$9);
            if ($$8 != null) {
                return new IntegerLiteral($$7, Base.DECIMAL, $$8, $$6);
            }
            String $$9 = (String)p_409716_.get($$10);
            if ($$9 != null) {
                return new IntegerLiteral($$7, Base.HEX, $$9, $$6);
            }
            String $$10 = (String)p_409716_.getOrThrow($$8);
            return new IntegerLiteral($$7, Base.BINARY, $$10, $$6);
        });
        Atom $$13 = Atom.of("float_type_suffix");
        $$5.put($$13, Term.alternative(Term.sequence(StringReaderTerms.characters('f', 'F'), Term.marker($$13, TypeSuffix.FLOAT)), Term.sequence(StringReaderTerms.characters('d', 'D'), Term.marker($$13, TypeSuffix.DOUBLE))), p_410191_ -> (TypeSuffix)((Object)((Object)p_410191_.getOrThrow($$13))));
        Atom $$14 = Atom.of("float_exponent_part");
        $$5.put($$14, Term.sequence(StringReaderTerms.characters('e', 'E'), Term.optional($$5.named($$6)), $$5.named($$9)), p_410211_ -> new Signed<String>(p_410211_.getOrDefault($$6, Sign.PLUS), (String)p_410211_.getOrThrow($$9)));
        Atom $$15 = Atom.of("float_whole_part");
        Atom $$16 = Atom.of("float_fraction_part");
        Atom $$17 = Atom.of("float_literal");
        $$5.putComplex($$17, Term.sequence(Term.optional($$5.named($$6)), Term.alternative(Term.sequence($$5.namedWithAlias($$9, $$15), StringReaderTerms.character('.'), Term.cut(), Term.optional($$5.namedWithAlias($$9, $$16)), Term.optional($$5.named($$14)), Term.optional($$5.named($$13))), Term.sequence(StringReaderTerms.character('.'), Term.cut(), $$5.namedWithAlias($$9, $$16), Term.optional($$5.named($$14)), Term.optional($$5.named($$13))), Term.sequence($$5.namedWithAlias($$9, $$15), $$5.named($$14), Term.cut(), Term.optional($$5.named($$13))), Term.sequence($$5.namedWithAlias($$9, $$15), Term.optional($$5.named($$14)), $$5.named($$13)))), p_410250_ -> {
            Scope $$7 = p_410250_.scope();
            Sign $$8 = $$7.getOrDefault($$6, Sign.PLUS);
            String $$9 = (String)$$7.get($$15);
            String $$10 = (String)$$7.get($$16);
            Signed $$11 = (Signed)$$7.get($$14);
            TypeSuffix $$12 = (TypeSuffix)((Object)((Object)$$7.get($$13)));
            return SnbtGrammar.createFloat(p_409979_, $$8, $$9, $$10, $$11, $$12, p_410250_);
        });
        Atom $$18 = Atom.of("string_hex_2");
        $$5.put($$18, new SimpleHexLiteralParseRule(2));
        Atom $$19 = Atom.of("string_hex_4");
        $$5.put($$19, new SimpleHexLiteralParseRule(4));
        Atom $$20 = Atom.of("string_hex_8");
        $$5.put($$20, new SimpleHexLiteralParseRule(8));
        Atom $$21 = Atom.of("string_unicode_name");
        $$5.put($$21, new GreedyPatternParseRule(UNICODE_NAME, ERROR_INVALID_CHARACTER_NAME));
        Atom $$22 = Atom.of("string_escape_sequence");
        $$5.putComplex($$22, Term.alternative(Term.sequence(StringReaderTerms.character('b'), Term.marker($$22, "\b")), Term.sequence(StringReaderTerms.character('s'), Term.marker($$22, " ")), Term.sequence(StringReaderTerms.character('t'), Term.marker($$22, "\t")), Term.sequence(StringReaderTerms.character('n'), Term.marker($$22, "\n")), Term.sequence(StringReaderTerms.character('f'), Term.marker($$22, "\f")), Term.sequence(StringReaderTerms.character('r'), Term.marker($$22, "\r")), Term.sequence(StringReaderTerms.character('\\'), Term.marker($$22, "\\")), Term.sequence(StringReaderTerms.character('\''), Term.marker($$22, "'")), Term.sequence(StringReaderTerms.character('\"'), Term.marker($$22, "\"")), Term.sequence(StringReaderTerms.character('x'), $$5.named($$18)), Term.sequence(StringReaderTerms.character('u'), $$5.named($$19)), Term.sequence(StringReaderTerms.character('U'), $$5.named($$20)), Term.sequence(StringReaderTerms.character('N'), StringReaderTerms.character('{'), $$5.named($$21), StringReaderTerms.character('}'))), p_411035_ -> {
            void $$13;
            Scope $$6 = p_411035_.scope();
            String $$7 = (String)$$6.getAny($$22);
            if ($$7 != null) {
                return $$7;
            }
            String $$8 = (String)$$6.getAny($$18, $$19, $$20);
            if ($$8 != null) {
                int $$9 = HexFormat.fromHexDigits($$8);
                if (!Character.isValidCodePoint($$9)) {
                    p_411035_.errorCollector().store(p_411035_.mark(), DelayedException.create(ERROR_INVALID_CODEPOINT, String.format(Locale.ROOT, "U+%08X", $$9)));
                    return null;
                }
                return Character.toString($$9);
            }
            String $$10 = (String)$$6.getOrThrow($$21);
            try {
                int $$11 = Character.codePointOf($$10);
            }
            catch (IllegalArgumentException $$12) {
                p_411035_.errorCollector().store(p_411035_.mark(), ERROR_INVALID_CHARACTER_NAME);
                return null;
            }
            return Character.toString((int)$$13);
        });
        Atom $$23 = Atom.of("string_plain_contents");
        $$5.put($$23, PLAIN_STRING_CHUNK);
        Atom $$24 = Atom.of("string_chunks");
        Atom $$25 = Atom.of("string_contents");
        Atom $$26 = Atom.of("single_quoted_string_chunk");
        NamedRule $$27 = $$5.put($$26, Term.alternative($$5.namedWithAlias($$23, $$25), Term.sequence(StringReaderTerms.character('\\'), $$5.namedWithAlias($$22, $$25)), Term.sequence(StringReaderTerms.character('\"'), Term.marker($$25, "\""))), p_409868_ -> (String)p_409868_.getOrThrow($$25));
        Atom $$28 = Atom.of("single_quoted_string_contents");
        $$5.put($$28, Term.repeated($$27, $$24), p_410457_ -> SnbtGrammar.joinList((List)p_410457_.getOrThrow($$24)));
        Atom $$29 = Atom.of("double_quoted_string_chunk");
        NamedRule $$30 = $$5.put($$29, Term.alternative($$5.namedWithAlias($$23, $$25), Term.sequence(StringReaderTerms.character('\\'), $$5.namedWithAlias($$22, $$25)), Term.sequence(StringReaderTerms.character('\''), Term.marker($$25, "'"))), p_410420_ -> (String)p_410420_.getOrThrow($$25));
        Atom $$31 = Atom.of("double_quoted_string_contents");
        $$5.put($$31, Term.repeated($$30, $$24), p_409731_ -> SnbtGrammar.joinList((List)p_409731_.getOrThrow($$24)));
        Atom $$32 = Atom.of("quoted_string_literal");
        $$5.put($$32, Term.alternative(Term.sequence(StringReaderTerms.character('\"'), Term.cut(), Term.optional($$5.namedWithAlias($$31, $$25)), StringReaderTerms.character('\"')), Term.sequence(StringReaderTerms.character('\''), Term.optional($$5.namedWithAlias($$28, $$25)), StringReaderTerms.character('\''))), p_410273_ -> (String)p_410273_.getOrThrow($$25));
        Atom $$33 = Atom.of("unquoted_string");
        $$5.put($$33, new UnquotedStringParseRule(1, ERROR_EXPECTED_UNQUOTED_STRING));
        Atom $$34 = Atom.of("literal");
        Atom $$35 = Atom.of("arguments");
        $$5.put($$35, Term.repeatedWithTrailingSeparator($$5.forward($$34), $$35, StringReaderTerms.character(',')), p_410707_ -> (List)p_410707_.getOrThrow($$35));
        Atom $$36 = Atom.of("unquoted_string_or_builtin");
        $$5.putComplex($$36, Term.sequence($$5.named($$33), Term.optional(Term.sequence(StringReaderTerms.character('('), $$5.named($$35), StringReaderTerms.character(')')))), p_411043_ -> {
            Scope $$6 = p_411043_.scope();
            String $$7 = (String)$$6.getOrThrow($$33);
            if ($$7.isEmpty() || !SnbtGrammar.isAllowedToStartUnquotedString($$7.charAt(0))) {
                p_411043_.errorCollector().store(p_411043_.mark(), SnbtOperations.BUILTIN_IDS, ERROR_INVALID_UNQUOTED_START);
                return null;
            }
            List $$8 = (List)$$6.get($$35);
            if ($$8 != null) {
                SnbtOperations.BuiltinKey $$9 = new SnbtOperations.BuiltinKey($$7, $$8.size());
                SnbtOperations.BuiltinOperation $$10 = SnbtOperations.BUILTIN_OPERATIONS.get($$9);
                if ($$10 != null) {
                    return $$10.run(p_409979_, $$8, p_411043_);
                }
                p_411043_.errorCollector().store(p_411043_.mark(), DelayedException.create(ERROR_NO_SUCH_OPERATION, $$9.toString()));
                return null;
            }
            if ($$7.equalsIgnoreCase("true")) {
                return $$1;
            }
            if ($$7.equalsIgnoreCase("false")) {
                return $$2;
            }
            return p_409979_.createString($$7);
        });
        Atom $$37 = Atom.of("map_key");
        $$5.put($$37, Term.alternative($$5.named($$32), $$5.named($$33)), p_410385_ -> (String)p_410385_.getAnyOrThrow($$32, $$33));
        Atom $$38 = Atom.of("map_entry");
        NamedRule $$39 = $$5.putComplex($$38, Term.sequence($$5.named($$37), StringReaderTerms.character(':'), $$5.named($$34)), p_410737_ -> {
            Scope $$3 = p_410737_.scope();
            String $$4 = (String)$$3.getOrThrow($$37);
            if ($$4.isEmpty()) {
                p_410737_.errorCollector().store(p_410737_.mark(), ERROR_EMPTY_KEY);
                return null;
            }
            Object $$5 = $$3.getOrThrow($$34);
            return Map.entry($$4, $$5);
        });
        Atom $$40 = Atom.of("map_entries");
        $$5.put($$40, Term.repeatedWithTrailingSeparator($$39, $$40, StringReaderTerms.character(',')), p_410706_ -> (List)p_410706_.getOrThrow($$40));
        Atom $$41 = Atom.of("map_literal");
        $$5.put($$41, Term.sequence(StringReaderTerms.character('{'), $$5.named($$40), StringReaderTerms.character('}')), p_409658_ -> {
            List $$4 = (List)p_409658_.getOrThrow($$40);
            if ($$4.isEmpty()) {
                return $$3;
            }
            ImmutableMap.Builder $$5 = ImmutableMap.builderWithExpectedSize((int)$$4.size());
            for (Map.Entry $$6 : $$4) {
                $$5.put(p_409979_.createString((String)$$6.getKey()), $$6.getValue());
            }
            return p_409979_.createMap((Map)$$5.buildKeepingLast());
        });
        Atom $$42 = Atom.of("list_entries");
        $$5.put($$42, Term.repeatedWithTrailingSeparator($$5.forward($$34), $$42, StringReaderTerms.character(',')), p_410645_ -> (List)p_410645_.getOrThrow($$42));
        Atom $$43 = Atom.of("array_prefix");
        $$5.put($$43, Term.alternative(Term.sequence(StringReaderTerms.character('B'), Term.marker($$43, ArrayPrefix.BYTE)), Term.sequence(StringReaderTerms.character('L'), Term.marker($$43, ArrayPrefix.LONG)), Term.sequence(StringReaderTerms.character('I'), Term.marker($$43, ArrayPrefix.INT))), p_409638_ -> (ArrayPrefix)((Object)((Object)p_409638_.getOrThrow($$43))));
        Atom $$44 = Atom.of("int_array_entries");
        $$5.put($$44, Term.repeatedWithTrailingSeparator($$12, $$44, StringReaderTerms.character(',')), p_411029_ -> (List)p_411029_.getOrThrow($$44));
        Atom $$45 = Atom.of("list_literal");
        $$5.putComplex($$45, Term.sequence(StringReaderTerms.character('['), Term.alternative(Term.sequence($$5.named($$43), StringReaderTerms.character(';'), $$5.named($$44)), $$5.named($$42)), StringReaderTerms.character(']')), p_410065_ -> {
            Scope $$6 = p_410065_.scope();
            ArrayPrefix $$7 = (ArrayPrefix)((Object)((Object)$$6.get($$43)));
            if ($$7 != null) {
                List $$8 = (List)$$6.getOrThrow($$44);
                return $$8.isEmpty() ? $$7.create(p_409979_) : $$7.create(p_409979_, $$8, p_410065_);
            }
            List $$9 = (List)$$6.getOrThrow($$42);
            return $$9.isEmpty() ? $$4 : p_409979_.createList($$9.stream());
        });
        NamedRule $$46 = $$5.putComplex($$34, Term.alternative(Term.sequence(Term.positiveLookahead(NUMBER_LOOKEAHEAD), Term.alternative($$5.namedWithAlias($$17, $$34), $$5.named($$11))), Term.sequence(Term.positiveLookahead(StringReaderTerms.characters('\"', '\'')), Term.cut(), $$5.named($$32)), Term.sequence(Term.positiveLookahead(StringReaderTerms.character('{')), Term.cut(), $$5.namedWithAlias($$41, $$34)), Term.sequence(Term.positiveLookahead(StringReaderTerms.character('[')), Term.cut(), $$5.namedWithAlias($$45, $$34)), $$5.namedWithAlias($$36, $$34)), p_410054_ -> {
            Scope $$5 = p_410054_.scope();
            String $$6 = (String)$$5.get($$32);
            if ($$6 != null) {
                return p_409979_.createString($$6);
            }
            IntegerLiteral $$7 = (IntegerLiteral)$$5.get($$11);
            if ($$7 != null) {
                return $$7.create(p_409979_, p_410054_);
            }
            return $$5.getOrThrow($$34);
        });
        return new Grammar<Object>($$5, $$46);
    }

    static enum Sign {
        PLUS,
        MINUS;


        public void append(StringBuilder p_410045_) {
            if (this == MINUS) {
                p_410045_.append("-");
            }
        }
    }

    record Signed<T>(Sign sign, T value) {
    }

    static enum TypeSuffix {
        FLOAT,
        DOUBLE,
        BYTE,
        SHORT,
        INT,
        LONG;

    }

    record IntegerSuffix(@Nullable SignedPrefix signed, @Nullable TypeSuffix type) {
        public static final IntegerSuffix EMPTY = new IntegerSuffix(null, null);
    }

    static enum SignedPrefix {
        SIGNED,
        UNSIGNED;

    }

    static class SimpleHexLiteralParseRule
    extends GreedyPredicateParseRule {
        public SimpleHexLiteralParseRule(int p_410732_) {
            super(p_410732_, p_410732_, DelayedException.create(ERROR_EXPECTED_HEX_ESCAPE, String.valueOf(p_410732_)));
        }

        @Override
        protected boolean isAccepted(char p_410209_) {
            return switch (p_410209_) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    }

    static enum ArrayPrefix {
        BYTE(TypeSuffix.BYTE, new TypeSuffix[0]){
            private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);

            @Override
            public <T> T create(DynamicOps<T> p_410524_) {
                return (T)p_410524_.createByteList(EMPTY_BUFFER);
            }

            @Override
            @Nullable
            public <T> T create(DynamicOps<T> p_410319_, List<IntegerLiteral> p_410656_, ParseState<?> p_410578_) {
                ByteArrayList $$3 = new ByteArrayList();
                for (IntegerLiteral $$4 : p_410656_) {
                    Number $$5 = this.buildNumber($$4, p_410578_);
                    if ($$5 == null) {
                        return null;
                    }
                    $$3.add($$5.byteValue());
                }
                return (T)p_410319_.createByteList(ByteBuffer.wrap($$3.toByteArray()));
            }
        }
        ,
        INT(TypeSuffix.INT, new TypeSuffix[]{TypeSuffix.BYTE, TypeSuffix.SHORT}){

            @Override
            public <T> T create(DynamicOps<T> p_409691_) {
                return (T)p_409691_.createIntList(IntStream.empty());
            }

            @Override
            @Nullable
            public <T> T create(DynamicOps<T> p_409890_, List<IntegerLiteral> p_410031_, ParseState<?> p_409844_) {
                IntStream.Builder $$3 = IntStream.builder();
                for (IntegerLiteral $$4 : p_410031_) {
                    Number $$5 = this.buildNumber($$4, p_409844_);
                    if ($$5 == null) {
                        return null;
                    }
                    $$3.add($$5.intValue());
                }
                return (T)p_409890_.createIntList($$3.build());
            }
        }
        ,
        LONG(TypeSuffix.LONG, new TypeSuffix[]{TypeSuffix.BYTE, TypeSuffix.SHORT, TypeSuffix.INT}){

            @Override
            public <T> T create(DynamicOps<T> p_410179_) {
                return (T)p_410179_.createLongList(LongStream.empty());
            }

            @Override
            @Nullable
            public <T> T create(DynamicOps<T> p_410327_, List<IntegerLiteral> p_409793_, ParseState<?> p_410839_) {
                LongStream.Builder $$3 = LongStream.builder();
                for (IntegerLiteral $$4 : p_409793_) {
                    Number $$5 = this.buildNumber($$4, p_410839_);
                    if ($$5 == null) {
                        return null;
                    }
                    $$3.add($$5.longValue());
                }
                return (T)p_410327_.createLongList($$3.build());
            }
        };

        private final TypeSuffix defaultType;
        private final Set<TypeSuffix> additionalTypes;

        ArrayPrefix(TypeSuffix p_410014_, TypeSuffix ... p_410215_) {
            this.additionalTypes = Set.of(p_410215_);
            this.defaultType = p_410014_;
        }

        public boolean isAllowed(TypeSuffix p_410024_) {
            return p_410024_ == this.defaultType || this.additionalTypes.contains((Object)p_410024_);
        }

        public abstract <T> T create(DynamicOps<T> var1);

        @Nullable
        public abstract <T> T create(DynamicOps<T> var1, List<IntegerLiteral> var2, ParseState<?> var3);

        @Nullable
        protected Number buildNumber(IntegerLiteral p_410128_, ParseState<?> p_410405_) {
            TypeSuffix $$2 = this.computeType(p_410128_.suffix);
            if ($$2 == null) {
                p_410405_.errorCollector().store(p_410405_.mark(), ERROR_INVALID_ARRAY_ELEMENT_TYPE);
                return null;
            }
            return (Number)p_410128_.create(JavaOps.INSTANCE, $$2, p_410405_);
        }

        @Nullable
        private TypeSuffix computeType(IntegerSuffix p_409627_) {
            TypeSuffix $$1 = p_409627_.type();
            if ($$1 == null) {
                return this.defaultType;
            }
            if (!this.isAllowed($$1)) {
                return null;
            }
            return $$1;
        }
    }

    record IntegerLiteral(Sign sign, Base base, String digits, IntegerSuffix suffix) {
        private SignedPrefix signedOrDefault() {
            if (this.suffix.signed != null) {
                return this.suffix.signed;
            }
            return switch (this.base.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> SignedPrefix.UNSIGNED;
                case 1 -> SignedPrefix.SIGNED;
            };
        }

        private String cleanupDigits(Sign p_409828_) {
            boolean $$1 = SnbtGrammar.needsUnderscoreRemoval(this.digits);
            if (p_409828_ == Sign.MINUS || $$1) {
                StringBuilder $$2 = new StringBuilder();
                p_409828_.append($$2);
                SnbtGrammar.cleanAndAppend($$2, this.digits, $$1);
                return $$2.toString();
            }
            return this.digits;
        }

        @Nullable
        public <T> T create(DynamicOps<T> p_410386_, ParseState<?> p_409584_) {
            return this.create(p_410386_, Objects.requireNonNullElse(this.suffix.type, TypeSuffix.INT), p_409584_);
        }

        @Nullable
        public <T> T create(DynamicOps<T> p_409628_, TypeSuffix p_410472_, ParseState<?> p_410023_) {
            boolean $$3;
            boolean bl = $$3 = this.signedOrDefault() == SignedPrefix.SIGNED;
            if (!$$3 && this.sign == Sign.MINUS) {
                p_410023_.errorCollector().store(p_410023_.mark(), ERROR_EXPECTED_NON_NEGATIVE_NUMBER);
                return null;
            }
            String $$4 = this.cleanupDigits(this.sign);
            int $$5 = switch (this.base.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 2;
                case 1 -> 10;
                case 2 -> 16;
            };
            try {
                if ($$3) {
                    return (T)(switch (p_410472_.ordinal()) {
                        case 2 -> p_409628_.createByte(Byte.parseByte($$4, $$5));
                        case 3 -> p_409628_.createShort(Short.parseShort($$4, $$5));
                        case 4 -> p_409628_.createInt(Integer.parseInt($$4, $$5));
                        case 5 -> p_409628_.createLong(Long.parseLong($$4, $$5));
                        default -> {
                            p_410023_.errorCollector().store(p_410023_.mark(), ERROR_EXPECTED_INTEGER_TYPE);
                            yield null;
                        }
                    });
                }
                return (T)(switch (p_410472_.ordinal()) {
                    case 2 -> p_409628_.createByte(UnsignedBytes.parseUnsignedByte((String)$$4, (int)$$5));
                    case 3 -> p_409628_.createShort(SnbtGrammar.parseUnsignedShort($$4, $$5));
                    case 4 -> p_409628_.createInt(Integer.parseUnsignedInt($$4, $$5));
                    case 5 -> p_409628_.createLong(Long.parseUnsignedLong($$4, $$5));
                    default -> {
                        p_410023_.errorCollector().store(p_410023_.mark(), ERROR_EXPECTED_INTEGER_TYPE);
                        yield null;
                    }
                });
            }
            catch (NumberFormatException $$6) {
                p_410023_.errorCollector().store(p_410023_.mark(), SnbtGrammar.createNumberParseError($$6));
                return null;
            }
        }
    }

    static enum Base {
        BINARY,
        DECIMAL,
        HEX;

    }
}

