/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public final class NbtUtils {
    private static final Comparator<ListTag> YXZ_LISTTAG_INT_COMPARATOR = Comparator.comparingInt(p_409141_ -> p_409141_.getIntOr(1, 0)).thenComparingInt(p_409129_ -> p_409129_.getIntOr(0, 0)).thenComparingInt(p_409149_ -> p_409149_.getIntOr(2, 0));
    private static final Comparator<ListTag> YXZ_LISTTAG_DOUBLE_COMPARATOR = Comparator.comparingDouble(p_409131_ -> p_409131_.getDoubleOr(1, 0.0)).thenComparingDouble(p_409144_ -> p_409144_.getDoubleOr(0, 0.0)).thenComparingDouble(p_409143_ -> p_409143_.getDoubleOr(2, 0.0));
    private static final Codec<ResourceKey<Block>> BLOCK_NAME_CODEC = ResourceKey.codec(Registries.BLOCK);
    public static final String SNBT_DATA_TAG = "data";
    private static final char PROPERTIES_START = '{';
    private static final char PROPERTIES_END = '}';
    private static final String ELEMENT_SEPARATOR = ",";
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int INDENT = 2;
    private static final int NOT_FOUND = -1;

    private NbtUtils() {
    }

    @VisibleForTesting
    public static boolean compareNbt(@Nullable Tag p_129236_, @Nullable Tag p_129237_, boolean p_129238_) {
        if (p_129236_ == p_129237_) {
            return true;
        }
        if (p_129236_ == null) {
            return true;
        }
        if (p_129237_ == null) {
            return false;
        }
        if (!p_129236_.getClass().equals(p_129237_.getClass())) {
            return false;
        }
        if (p_129236_ instanceof CompoundTag) {
            CompoundTag $$3 = (CompoundTag)p_129236_;
            CompoundTag $$4 = (CompoundTag)p_129237_;
            if ($$4.size() < $$3.size()) {
                return false;
            }
            for (Map.Entry<String, Tag> $$5 : $$3.entrySet()) {
                Tag $$6 = $$5.getValue();
                if (NbtUtils.compareNbt($$6, $$4.get($$5.getKey()), p_129238_)) continue;
                return false;
            }
            return true;
        }
        if (p_129236_ instanceof ListTag) {
            ListTag $$7 = (ListTag)p_129236_;
            if (p_129238_) {
                ListTag $$8 = (ListTag)p_129237_;
                if ($$7.isEmpty()) {
                    return $$8.isEmpty();
                }
                if ($$8.size() < $$7.size()) {
                    return false;
                }
                for (Tag $$9 : $$7) {
                    boolean $$10 = false;
                    for (Tag $$11 : $$8) {
                        if (!NbtUtils.compareNbt($$9, $$11, p_129238_)) continue;
                        $$10 = true;
                        break;
                    }
                    if ($$10) continue;
                    return false;
                }
                return true;
            }
        }
        return p_129236_.equals(p_129237_);
    }

    public static BlockState readBlockState(HolderGetter<Block> p_256363_, CompoundTag p_250775_) {
        Optional $$2 = p_250775_.read("Name", BLOCK_NAME_CODEC).flatMap(p_256363_::get);
        if ($$2.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        Block $$3 = (Block)((Holder)$$2.get()).value();
        BlockState $$4 = $$3.defaultBlockState();
        Optional<CompoundTag> $$5 = p_250775_.getCompound("Properties");
        if ($$5.isPresent()) {
            StateDefinition<Block, BlockState> $$6 = $$3.getStateDefinition();
            for (String $$7 : $$5.get().keySet()) {
                Property<?> $$8 = $$6.getProperty($$7);
                if ($$8 == null) continue;
                $$4 = NbtUtils.setValueHelper($$4, $$8, $$7, $$5.get(), p_250775_);
            }
        }
        return $$4;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S p_129205_, Property<T> p_129206_, String p_129207_, CompoundTag p_129208_, CompoundTag p_129209_) {
        Optional $$5 = p_129208_.getString(p_129207_).flatMap(p_129206_::getValue);
        if ($$5.isPresent()) {
            return (S)((StateHolder)p_129205_.setValue(p_129206_, (Comparable)((Comparable)$$5.get())));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{p_129207_, p_129208_.get(p_129207_), p_129209_});
        return p_129205_;
    }

    public static CompoundTag writeBlockState(BlockState p_129203_) {
        CompoundTag $$1 = new CompoundTag();
        $$1.putString("Name", BuiltInRegistries.BLOCK.getKey(p_129203_.getBlock()).toString());
        Map<Property<?>, Comparable<?>> $$2 = p_129203_.getValues();
        if (!$$2.isEmpty()) {
            CompoundTag $$3 = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> $$4 : $$2.entrySet()) {
                Property<?> $$5 = $$4.getKey();
                $$3.putString($$5.getName(), NbtUtils.getName($$5, $$4.getValue()));
            }
            $$1.put("Properties", $$3);
        }
        return $$1;
    }

    public static CompoundTag writeFluidState(FluidState p_178023_) {
        CompoundTag $$1 = new CompoundTag();
        $$1.putString("Name", BuiltInRegistries.FLUID.getKey(p_178023_.getType()).toString());
        Map<Property<?>, Comparable<?>> $$2 = p_178023_.getValues();
        if (!$$2.isEmpty()) {
            CompoundTag $$3 = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> $$4 : $$2.entrySet()) {
                Property<?> $$5 = $$4.getKey();
                $$3.putString($$5.getName(), NbtUtils.getName($$5, $$4.getValue()));
            }
            $$1.put("Properties", $$3);
        }
        return $$1;
    }

    private static <T extends Comparable<T>> String getName(Property<T> p_129211_, Comparable<?> p_129212_) {
        return p_129211_.getName(p_129212_);
    }

    public static String prettyPrint(Tag p_178058_) {
        return NbtUtils.prettyPrint(p_178058_, false);
    }

    public static String prettyPrint(Tag p_178051_, boolean p_178052_) {
        return NbtUtils.prettyPrint(new StringBuilder(), p_178051_, 0, p_178052_).toString();
    }

    public static StringBuilder prettyPrint(StringBuilder p_178027_, Tag p_178028_, int p_178029_, boolean p_178030_) {
        Tag tag = p_178028_;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTag.class, EndTag.class, ByteArrayTag.class, ListTag.class, IntArrayTag.class, CompoundTag.class, LongArrayTag.class}, (Object)tag2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PrimitiveTag $$4 = (PrimitiveTag)tag2;
                yield p_178027_.append($$4);
            }
            case 1 -> {
                EndTag $$5 = (EndTag)tag2;
                yield p_178027_;
            }
            case 2 -> {
                ByteArrayTag $$6 = (ByteArrayTag)tag2;
                byte[] $$7 = $$6.getAsByteArray();
                int $$8 = $$7.length;
                NbtUtils.indent(p_178029_, p_178027_).append("byte[").append($$8).append("] {\n");
                if (p_178030_) {
                    NbtUtils.indent(p_178029_ + 1, p_178027_);
                    for (int $$9 = 0; $$9 < $$7.length; ++$$9) {
                        if ($$9 != 0) {
                            p_178027_.append(',');
                        }
                        if ($$9 % 16 == 0 && $$9 / 16 > 0) {
                            p_178027_.append('\n');
                            if ($$9 < $$7.length) {
                                NbtUtils.indent(p_178029_ + 1, p_178027_);
                            }
                        } else if ($$9 != 0) {
                            p_178027_.append(' ');
                        }
                        p_178027_.append(String.format(Locale.ROOT, "0x%02X", $$7[$$9] & 0xFF));
                    }
                } else {
                    NbtUtils.indent(p_178029_ + 1, p_178027_).append(" // Skipped, supply withBinaryBlobs true");
                }
                p_178027_.append('\n');
                NbtUtils.indent(p_178029_, p_178027_).append('}');
                yield p_178027_;
            }
            case 3 -> {
                ListTag $$10 = (ListTag)tag2;
                int $$11 = $$10.size();
                NbtUtils.indent(p_178029_, p_178027_).append("list").append("[").append($$11).append("] [");
                if ($$11 != 0) {
                    p_178027_.append('\n');
                }
                for (int $$12 = 0; $$12 < $$11; ++$$12) {
                    if ($$12 != 0) {
                        p_178027_.append(",\n");
                    }
                    NbtUtils.indent(p_178029_ + 1, p_178027_);
                    NbtUtils.prettyPrint(p_178027_, $$10.get($$12), p_178029_ + 1, p_178030_);
                }
                if ($$11 != 0) {
                    p_178027_.append('\n');
                }
                NbtUtils.indent(p_178029_, p_178027_).append(']');
                yield p_178027_;
            }
            case 4 -> {
                IntArrayTag $$13 = (IntArrayTag)tag2;
                int[] $$14 = $$13.getAsIntArray();
                int $$15 = 0;
                for (int $$16 : $$14) {
                    $$15 = Math.max($$15, String.format(Locale.ROOT, "%X", $$16).length());
                }
                int $$17 = $$14.length;
                NbtUtils.indent(p_178029_, p_178027_).append("int[").append($$17).append("] {\n");
                if (p_178030_) {
                    NbtUtils.indent(p_178029_ + 1, p_178027_);
                    for (int $$18 = 0; $$18 < $$14.length; ++$$18) {
                        if ($$18 != 0) {
                            p_178027_.append(',');
                        }
                        if ($$18 % 16 == 0 && $$18 / 16 > 0) {
                            p_178027_.append('\n');
                            if ($$18 < $$14.length) {
                                NbtUtils.indent(p_178029_ + 1, p_178027_);
                            }
                        } else if ($$18 != 0) {
                            p_178027_.append(' ');
                        }
                        p_178027_.append(String.format(Locale.ROOT, "0x%0" + $$15 + "X", $$14[$$18]));
                    }
                } else {
                    NbtUtils.indent(p_178029_ + 1, p_178027_).append(" // Skipped, supply withBinaryBlobs true");
                }
                p_178027_.append('\n');
                NbtUtils.indent(p_178029_, p_178027_).append('}');
                yield p_178027_;
            }
            case 5 -> {
                CompoundTag $$19 = (CompoundTag)tag2;
                ArrayList $$20 = Lists.newArrayList($$19.keySet());
                Collections.sort($$20);
                NbtUtils.indent(p_178029_, p_178027_).append('{');
                if (p_178027_.length() - p_178027_.lastIndexOf("\n") > 2 * (p_178029_ + 1)) {
                    p_178027_.append('\n');
                    NbtUtils.indent(p_178029_ + 1, p_178027_);
                }
                int $$21 = $$20.stream().mapToInt(String::length).max().orElse(0);
                String $$22 = Strings.repeat((String)" ", (int)$$21);
                for (int $$23 = 0; $$23 < $$20.size(); ++$$23) {
                    if ($$23 != 0) {
                        p_178027_.append(",\n");
                    }
                    String $$24 = (String)$$20.get($$23);
                    NbtUtils.indent(p_178029_ + 1, p_178027_).append('\"').append($$24).append('\"').append($$22, 0, $$22.length() - $$24.length()).append(": ");
                    NbtUtils.prettyPrint(p_178027_, $$19.get($$24), p_178029_ + 1, p_178030_);
                }
                if (!$$20.isEmpty()) {
                    p_178027_.append('\n');
                }
                NbtUtils.indent(p_178029_, p_178027_).append('}');
                yield p_178027_;
            }
            case 6 -> {
                LongArrayTag $$25 = (LongArrayTag)tag2;
                long[] $$26 = $$25.getAsLongArray();
                long $$27 = 0L;
                for (long $$28 : $$26) {
                    $$27 = Math.max($$27, (long)String.format(Locale.ROOT, "%X", $$28).length());
                }
                long $$29 = $$26.length;
                NbtUtils.indent(p_178029_, p_178027_).append("long[").append($$29).append("] {\n");
                if (p_178030_) {
                    NbtUtils.indent(p_178029_ + 1, p_178027_);
                    for (int $$30 = 0; $$30 < $$26.length; ++$$30) {
                        if ($$30 != 0) {
                            p_178027_.append(',');
                        }
                        if ($$30 % 16 == 0 && $$30 / 16 > 0) {
                            p_178027_.append('\n');
                            if ($$30 < $$26.length) {
                                NbtUtils.indent(p_178029_ + 1, p_178027_);
                            }
                        } else if ($$30 != 0) {
                            p_178027_.append(' ');
                        }
                        p_178027_.append(String.format(Locale.ROOT, "0x%0" + $$27 + "X", $$26[$$30]));
                    }
                } else {
                    NbtUtils.indent(p_178029_ + 1, p_178027_).append(" // Skipped, supply withBinaryBlobs true");
                }
                p_178027_.append('\n');
                NbtUtils.indent(p_178029_, p_178027_).append('}');
                yield p_178027_;
            }
        };
    }

    private static StringBuilder indent(int p_178020_, StringBuilder p_178021_) {
        int $$2 = p_178021_.lastIndexOf("\n") + 1;
        int $$3 = p_178021_.length() - $$2;
        for (int $$4 = 0; $$4 < 2 * p_178020_ - $$3; ++$$4) {
            p_178021_.append(' ');
        }
        return p_178021_;
    }

    public static Component toPrettyComponent(Tag p_178062_) {
        return new TextComponentTagVisitor("").visit(p_178062_);
    }

    public static String structureToSnbt(CompoundTag p_178064_) {
        return new SnbtPrinterTagVisitor().visit(NbtUtils.packStructureTemplate(p_178064_));
    }

    public static CompoundTag snbtToStructure(String p_178025_) throws CommandSyntaxException {
        return NbtUtils.unpackStructureTemplate(TagParser.parseCompoundFully(p_178025_));
    }

    @VisibleForTesting
    static CompoundTag packStructureTemplate(CompoundTag p_178068_) {
        Optional<ListTag> $$6;
        ListTag $$3;
        Optional<ListTag> $$1 = p_178068_.getList("palettes");
        if ($$1.isPresent()) {
            ListTag $$2 = $$1.get().getListOrEmpty(0);
        } else {
            $$3 = p_178068_.getListOrEmpty("palette");
        }
        ListTag $$4 = $$3.compoundStream().map(NbtUtils::packBlockState).map(StringTag::valueOf).collect(Collectors.toCollection(ListTag::new));
        p_178068_.put("palette", $$4);
        if ($$1.isPresent()) {
            ListTag $$5 = new ListTag();
            $$1.get().stream().flatMap(p_409134_ -> p_409134_.asList().stream()).forEach(p_409140_ -> {
                CompoundTag $$3 = new CompoundTag();
                for (int $$4 = 0; $$4 < p_409140_.size(); ++$$4) {
                    $$3.putString($$4.getString($$4).orElseThrow(), NbtUtils.packBlockState(p_409140_.getCompound($$4).orElseThrow()));
                }
                $$5.add($$3);
            });
            p_178068_.put("palettes", $$5);
        }
        if (($$6 = p_178068_.getList("entities")).isPresent()) {
            ListTag $$7 = $$6.get().compoundStream().sorted(Comparator.comparing(p_409130_ -> p_409130_.getList("pos"), Comparators.emptiesLast(YXZ_LISTTAG_DOUBLE_COMPARATOR))).collect(Collectors.toCollection(ListTag::new));
            p_178068_.put("entities", $$7);
        }
        ListTag $$8 = p_178068_.getList("blocks").stream().flatMap(ListTag::compoundStream).sorted(Comparator.comparing(p_409135_ -> p_409135_.getList("pos"), Comparators.emptiesLast(YXZ_LISTTAG_INT_COMPARATOR))).peek(p_409148_ -> p_409148_.putString("state", $$4.getString(p_409148_.getIntOr("state", 0)).orElseThrow())).collect(Collectors.toCollection(ListTag::new));
        p_178068_.put(SNBT_DATA_TAG, $$8);
        p_178068_.remove("blocks");
        return p_178068_;
    }

    @VisibleForTesting
    static CompoundTag unpackStructureTemplate(CompoundTag p_178072_) {
        ListTag $$1 = p_178072_.getListOrEmpty("palette");
        Map $$2 = (Map)$$1.stream().flatMap(p_409142_ -> p_409142_.asString().stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), NbtUtils::unpackBlockState));
        Optional<ListTag> $$3 = p_178072_.getList("palettes");
        if ($$3.isPresent()) {
            p_178072_.put("palettes", $$3.get().compoundStream().map(p_409137_ -> $$2.keySet().stream().map(p_409146_ -> p_409137_.getString((String)p_409146_).orElseThrow()).map(NbtUtils::unpackBlockState).collect(Collectors.toCollection(ListTag::new))).collect(Collectors.toCollection(ListTag::new)));
            p_178072_.remove("palette");
        } else {
            p_178072_.put("palette", $$2.values().stream().collect(Collectors.toCollection(ListTag::new)));
        }
        Optional<ListTag> $$4 = p_178072_.getList(SNBT_DATA_TAG);
        if ($$4.isPresent()) {
            Object2IntOpenHashMap $$5 = new Object2IntOpenHashMap();
            $$5.defaultReturnValue(-1);
            for (int $$6 = 0; $$6 < $$1.size(); ++$$6) {
                $$5.put((Object)$$1.getString($$6).orElseThrow(), $$6);
            }
            ListTag $$7 = $$4.get();
            for (int $$8 = 0; $$8 < $$7.size(); ++$$8) {
                CompoundTag $$9 = $$7.getCompound($$8).orElseThrow();
                String $$10 = $$9.getString("state").orElseThrow();
                int $$11 = $$5.getInt((Object)$$10);
                if ($$11 == -1) {
                    throw new IllegalStateException("Entry " + $$10 + " missing from palette");
                }
                $$9.putInt("state", $$11);
            }
            p_178072_.put("blocks", $$7);
            p_178072_.remove(SNBT_DATA_TAG);
        }
        return p_178072_;
    }

    @VisibleForTesting
    static String packBlockState(CompoundTag p_178076_) {
        StringBuilder $$1 = new StringBuilder(p_178076_.getString("Name").orElseThrow());
        p_178076_.getCompound("Properties").ifPresent(p_409133_ -> {
            String $$2 = p_409133_.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(p_409128_ -> (String)p_409128_.getKey() + ":" + ((Tag)p_409128_.getValue()).asString().orElseThrow()).collect(Collectors.joining(ELEMENT_SEPARATOR));
            $$1.append('{').append($$2).append('}');
        });
        return $$1.toString();
    }

    @VisibleForTesting
    static CompoundTag unpackBlockState(String p_178054_) {
        String $$6;
        CompoundTag $$1 = new CompoundTag();
        int $$2 = p_178054_.indexOf(123);
        if ($$2 >= 0) {
            String $$3 = p_178054_.substring(0, $$2);
            CompoundTag $$4 = new CompoundTag();
            if ($$2 + 2 <= p_178054_.length()) {
                String $$5 = p_178054_.substring($$2 + 1, p_178054_.indexOf(125, $$2));
                COMMA_SPLITTER.split((CharSequence)$$5).forEach(p_178040_ -> {
                    List $$3 = COLON_SPLITTER.splitToList((CharSequence)p_178040_);
                    if ($$3.size() == 2) {
                        $$4.putString((String)$$3.get(0), (String)$$3.get(1));
                    } else {
                        LOGGER.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)p_178054_);
                    }
                });
                $$1.put("Properties", $$4);
            }
        } else {
            $$6 = p_178054_;
        }
        $$1.putString("Name", $$6);
        return $$1;
    }

    public static CompoundTag addCurrentDataVersion(CompoundTag p_265050_) {
        int $$1 = SharedConstants.getCurrentVersion().dataVersion().version();
        return NbtUtils.addDataVersion(p_265050_, $$1);
    }

    public static CompoundTag addDataVersion(CompoundTag p_265534_, int p_265686_) {
        p_265534_.putInt("DataVersion", p_265686_);
        return p_265534_;
    }

    public static void addCurrentDataVersion(ValueOutput p_422165_) {
        int $$1 = SharedConstants.getCurrentVersion().dataVersion().version();
        NbtUtils.addDataVersion(p_422165_, $$1);
    }

    public static void addDataVersion(ValueOutput p_421820_, int p_422605_) {
        p_421820_.putInt("DataVersion", p_422605_);
    }

    public static int getDataVersion(CompoundTag p_265397_, int p_265399_) {
        return p_265397_.getIntOr("DataVersion", p_265399_);
    }

    public static int getDataVersion(Dynamic<?> p_405880_, int p_404676_) {
        return p_405880_.get("DataVersion").asInt(p_404676_);
    }
}

