/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public final class ListTag
extends AbstractList<Tag>
implements CollectionTag {
    private static final String WRAPPER_MARKER = "";
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListTag load(DataInput p_128792_, NbtAccounter p_128794_) throws IOException {
            p_128794_.pushDepth();
            try {
                ListTag listTag = 1.loadList(p_128792_, p_128794_);
                return listTag;
            }
            finally {
                p_128794_.popDepth();
            }
        }

        private static ListTag loadList(DataInput p_302382_, NbtAccounter p_302349_) throws IOException {
            p_302349_.accountBytes(36L);
            byte $$2 = p_302382_.readByte();
            int $$3 = 1.readListCount(p_302382_);
            if ($$2 == 0 && $$3 > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            p_302349_.accountBytes(4L, $$3);
            TagType<?> $$4 = TagTypes.getType($$2);
            ListTag $$5 = new ListTag(new ArrayList<Tag>($$3));
            for (int $$6 = 0; $$6 < $$3; ++$$6) {
                $$5.addAndUnwrap((Tag)$$4.load(p_302382_, p_302349_));
            }
            return $$5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput p_197491_, StreamTagVisitor p_197492_, NbtAccounter p_302333_) throws IOException {
            p_302333_.pushDepth();
            try {
                StreamTagVisitor.ValueResult valueResult = 1.parseList(p_197491_, p_197492_, p_302333_);
                return valueResult;
            }
            finally {
                p_302333_.popDepth();
            }
        }

        /*
         * Exception decompiling
         */
        private static StreamTagVisitor.ValueResult parseList(DataInput p_302369_, StreamTagVisitor p_302372_, NbtAccounter p_302361_) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 8[CASE]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static int readListCount(DataInput p_428726_) throws IOException {
            int $$1 = p_428726_.readInt();
            if ($$1 < 0) {
                throw new NbtFormatException("ListTag length cannot be negative: " + $$1);
            }
            return $$1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput p_302400_, NbtAccounter p_302390_) throws IOException {
            p_302390_.pushDepth();
            try {
                TagType<?> $$2 = TagTypes.getType(p_302400_.readByte());
                int $$3 = p_302400_.readInt();
                $$2.skip(p_302400_, $$3, p_302390_);
            }
            finally {
                p_302390_.popDepth();
            }
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final List<Tag> list;

    public ListTag() {
        this(new ArrayList<Tag>());
    }

    ListTag(List<Tag> p_128721_) {
        this.list = p_128721_;
    }

    private static Tag tryUnwrap(CompoundTag p_410108_) {
        Tag $$1;
        if (p_410108_.size() == 1 && ($$1 = p_410108_.get(WRAPPER_MARKER)) != null) {
            return $$1;
        }
        return p_410108_;
    }

    private static boolean isWrapper(CompoundTag p_410439_) {
        return p_410439_.size() == 1 && p_410439_.contains(WRAPPER_MARKER);
    }

    private static Tag wrapIfNeeded(byte p_410100_, Tag p_409984_) {
        CompoundTag $$2;
        if (p_410100_ != 10) {
            return p_409984_;
        }
        if (p_409984_ instanceof CompoundTag && !ListTag.isWrapper($$2 = (CompoundTag)p_409984_)) {
            return $$2;
        }
        return ListTag.wrapElement(p_409984_);
    }

    private static CompoundTag wrapElement(Tag p_410663_) {
        return new CompoundTag(Map.of(WRAPPER_MARKER, p_410663_));
    }

    @Override
    public void write(DataOutput p_128734_) throws IOException {
        byte $$1 = this.identifyRawElementType();
        p_128734_.writeByte($$1);
        p_128734_.writeInt(this.list.size());
        for (Tag $$2 : this.list) {
            ListTag.wrapIfNeeded($$1, $$2).write(p_128734_);
        }
    }

    @VisibleForTesting
    byte identifyRawElementType() {
        byte $$0 = 0;
        for (Tag $$1 : this.list) {
            byte $$2 = $$1.getId();
            if ($$0 == 0) {
                $$0 = $$2;
                continue;
            }
            if ($$0 == $$2) continue;
            return 10;
        }
        return $$0;
    }

    public void addAndUnwrap(Tag p_410164_) {
        if (p_410164_ instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)p_410164_;
            this.add(ListTag.tryUnwrap($$1));
        } else {
            this.add(p_410164_);
        }
    }

    @Override
    public int sizeInBytes() {
        int $$0 = 36;
        $$0 += 4 * this.list.size();
        for (Tag $$1 : this.list) {
            $$0 += $$1.sizeInBytes();
        }
        return $$0;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor $$0 = new StringTagVisitor();
        $$0.visitList(this);
        return $$0.build();
    }

    @Override
    public Tag remove(int p_128751_) {
        return this.list.remove(p_128751_);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Optional<CompoundTag> getCompound(int p_128729_) {
        Tag tag = this.getNullable(p_128729_);
        if (tag instanceof CompoundTag) {
            CompoundTag $$1 = (CompoundTag)tag;
            return Optional.of($$1);
        }
        return Optional.empty();
    }

    public CompoundTag getCompoundOrEmpty(int p_410248_) {
        return this.getCompound(p_410248_).orElseGet(CompoundTag::new);
    }

    public Optional<ListTag> getList(int p_128745_) {
        Tag tag = this.getNullable(p_128745_);
        if (tag instanceof ListTag) {
            ListTag $$1 = (ListTag)tag;
            return Optional.of($$1);
        }
        return Optional.empty();
    }

    public ListTag getListOrEmpty(int p_410667_) {
        return this.getList(p_410667_).orElseGet(ListTag::new);
    }

    public Optional<Short> getShort(int p_128758_) {
        return this.getOptional(p_128758_).flatMap(Tag::asShort);
    }

    public short getShortOr(int p_410773_, short p_410394_) {
        Tag tag = this.getNullable(p_410773_);
        if (tag instanceof NumericTag) {
            NumericTag $$2 = (NumericTag)tag;
            return $$2.shortValue();
        }
        return p_410394_;
    }

    public Optional<Integer> getInt(int p_128764_) {
        return this.getOptional(p_128764_).flatMap(Tag::asInt);
    }

    public int getIntOr(int p_409647_, int p_410162_) {
        Tag tag = this.getNullable(p_409647_);
        if (tag instanceof NumericTag) {
            NumericTag $$2 = (NumericTag)tag;
            return $$2.intValue();
        }
        return p_410162_;
    }

    public Optional<int[]> getIntArray(int p_128768_) {
        Tag tag = this.getNullable(p_128768_);
        if (tag instanceof IntArrayTag) {
            IntArrayTag $$1 = (IntArrayTag)tag;
            return Optional.of($$1.getAsIntArray());
        }
        return Optional.empty();
    }

    public Optional<long[]> getLongArray(int p_177992_) {
        Tag tag = this.getNullable(p_177992_);
        if (tag instanceof LongArrayTag) {
            LongArrayTag $$1 = (LongArrayTag)tag;
            return Optional.of($$1.getAsLongArray());
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(int p_128773_) {
        return this.getOptional(p_128773_).flatMap(Tag::asDouble);
    }

    public double getDoubleOr(int p_410727_, double p_410555_) {
        Tag tag = this.getNullable(p_410727_);
        if (tag instanceof NumericTag) {
            NumericTag $$2 = (NumericTag)tag;
            return $$2.doubleValue();
        }
        return p_410555_;
    }

    public Optional<Float> getFloat(int p_128776_) {
        return this.getOptional(p_128776_).flatMap(Tag::asFloat);
    }

    public float getFloatOr(int p_410012_, float p_409704_) {
        Tag tag = this.getNullable(p_410012_);
        if (tag instanceof NumericTag) {
            NumericTag $$2 = (NumericTag)tag;
            return $$2.floatValue();
        }
        return p_409704_;
    }

    public Optional<String> getString(int p_128779_) {
        return this.getOptional(p_128779_).flatMap(Tag::asString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStringOr(int p_410678_, String p_409906_) {
        Tag $$2 = this.getNullable(p_410678_);
        if (!($$2 instanceof StringTag)) return p_409906_;
        StringTag stringTag = (StringTag)$$2;
        try {
            String string = stringTag.value();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Nullable
    private Tag getNullable(int p_410208_) {
        return p_410208_ >= 0 && p_410208_ < this.list.size() ? this.list.get(p_410208_) : null;
    }

    private Optional<Tag> getOptional(int p_410804_) {
        return Optional.ofNullable(this.getNullable(p_410804_));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Tag get(int p_128781_) {
        return this.list.get(p_128781_);
    }

    @Override
    public Tag set(int p_128760_, Tag p_128761_) {
        return this.list.set(p_128760_, p_128761_);
    }

    @Override
    public void add(int p_128753_, Tag p_128754_) {
        this.list.add(p_128753_, p_128754_);
    }

    @Override
    public boolean setTag(int p_128731_, Tag p_128732_) {
        this.list.set(p_128731_, p_128732_);
        return true;
    }

    @Override
    public boolean addTag(int p_128747_, Tag p_128748_) {
        this.list.add(p_128747_, p_128748_);
        return true;
    }

    @Override
    public ListTag copy() {
        ArrayList<Tag> $$0 = new ArrayList<Tag>(this.list.size());
        for (Tag $$1 : this.list) {
            $$0.add($$1.copy());
        }
        return new ListTag($$0);
    }

    @Override
    public Optional<ListTag> asList() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object p_128766_) {
        if (this == p_128766_) {
            return true;
        }
        return p_128766_ instanceof ListTag && Objects.equals(this.list, ((ListTag)p_128766_).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public Stream<Tag> stream() {
        return super.stream();
    }

    public Stream<CompoundTag> compoundStream() {
        return this.stream().mapMulti((p_410763_, p_410503_) -> {
            if (p_410763_ instanceof CompoundTag) {
                CompoundTag $$2 = (CompoundTag)p_410763_;
                p_410503_.accept($$2);
            }
        });
    }

    @Override
    public void accept(TagVisitor p_177990_) {
        p_177990_.visitList(this);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor p_197487_) {
        byte $$1 = this.identifyRawElementType();
        switch (p_197487_.visitList(TagTypes.getType($$1), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return p_197487_.visitContainerEnd();
            }
        }
        block13: for (int $$2 = 0; $$2 < this.list.size(); ++$$2) {
            Tag $$3 = ListTag.wrapIfNeeded($$1, this.list.get($$2));
            switch (p_197487_.visitElement($$3.getType(), $$2)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case SKIP: {
                    continue block13;
                }
                case BREAK: {
                    return p_197487_.visitContainerEnd();
                }
                default: {
                    switch ($$3.accept(p_197487_)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return p_197487_.visitContainerEnd();
                        }
                    }
                }
            }
        }
        return p_197487_.visitContainerEnd();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

