/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.locale;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.locale.Language;
import net.minecraft.util.StrictJsonParser;
import org.slf4j.Logger;

public record DeprecatedTranslationsInfo(List<String> removed, Map<String, String> renamed) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeprecatedTranslationsInfo EMPTY = new DeprecatedTranslationsInfo(List.of(), Map.of());
    public static final Codec<DeprecatedTranslationsInfo> CODEC = RecordCodecBuilder.create(p_362449_ -> p_362449_.group((App)Codec.STRING.listOf().fieldOf("removed").forGetter(DeprecatedTranslationsInfo::removed), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("renamed").forGetter(DeprecatedTranslationsInfo::renamed)).apply((Applicative)p_362449_, DeprecatedTranslationsInfo::new));

    public static DeprecatedTranslationsInfo loadFromJson(InputStream p_362627_) {
        JsonElement $$1 = StrictJsonParser.parse(new InputStreamReader(p_362627_, StandardCharsets.UTF_8));
        return (DeprecatedTranslationsInfo)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$1).getOrThrow(p_362302_ -> new IllegalStateException("Failed to parse deprecated language data: " + p_362302_));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeprecatedTranslationsInfo loadFromResource(String p_364845_) {
        try (InputStream $$1 = Language.class.getResourceAsStream(p_364845_);){
            if ($$1 == null) return EMPTY;
            DeprecatedTranslationsInfo deprecatedTranslationsInfo = DeprecatedTranslationsInfo.loadFromJson($$1);
            return deprecatedTranslationsInfo;
        }
        catch (Exception $$2) {
            LOGGER.error("Failed to read {}", (Object)p_364845_, (Object)$$2);
        }
        return EMPTY;
    }

    public static DeprecatedTranslationsInfo loadFromDefaultResource() {
        return DeprecatedTranslationsInfo.loadFromResource("/assets/minecraft/lang/deprecated.json");
    }

    public void applyToMap(Map<String, String> p_364396_) {
        for (String $$1 : this.removed) {
            p_364396_.remove($$1);
        }
        this.renamed.forEach((p_363658_, p_364541_) -> {
            String $$3 = (String)p_364396_.remove(p_363658_);
            if ($$3 == null) {
                LOGGER.warn("Missing translation key for rename: {}", p_363658_);
                p_364396_.remove(p_364541_);
            } else {
                p_364396_.put((String)p_364541_, $$3);
            }
        });
    }
}

