/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestEvent;
import net.minecraft.gametest.framework.GameTestException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.network.chat.Component;

public class GameTestSequence {
    final GameTestInfo parent;
    private final List<GameTestEvent> events = Lists.newArrayList();
    private int lastTick;

    GameTestSequence(GameTestInfo p_177542_) {
        this.parent = p_177542_;
        this.lastTick = p_177542_.getTick();
    }

    public GameTestSequence thenWaitUntil(Runnable p_177553_) {
        this.events.add(GameTestEvent.create(p_177553_));
        return this;
    }

    public GameTestSequence thenWaitUntil(long p_177550_, Runnable p_177551_) {
        this.events.add(GameTestEvent.create(p_177550_, p_177551_));
        return this;
    }

    public GameTestSequence thenIdle(int p_177545_) {
        return this.thenExecuteAfter(p_177545_, () -> {});
    }

    public GameTestSequence thenExecute(Runnable p_177563_) {
        this.events.add(GameTestEvent.create(() -> this.executeWithoutFail(p_177563_)));
        return this;
    }

    public GameTestSequence thenExecuteAfter(int p_177547_, Runnable p_177548_) {
        this.events.add(GameTestEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + p_177547_) {
                throw new GameTestAssertException(Component.translatable("test.error.sequence.not_completed"), this.parent.getTick());
            }
            this.executeWithoutFail(p_177548_);
        }));
        return this;
    }

    public GameTestSequence thenExecuteFor(int p_177560_, Runnable p_177561_) {
        this.events.add(GameTestEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + p_177560_) {
                this.executeWithoutFail(p_177561_);
                throw new GameTestAssertException(Component.translatable("test.error.sequence.not_completed"), this.parent.getTick());
            }
        }));
        return this;
    }

    public void thenSucceed() {
        this.events.add(GameTestEvent.create(this.parent::succeed));
    }

    public void thenFail(Supplier<GameTestException> p_177555_) {
        this.events.add(GameTestEvent.create(() -> this.parent.fail((GameTestException)p_177555_.get())));
    }

    public Condition thenTrigger() {
        Condition $$0 = new Condition();
        this.events.add(GameTestEvent.create(() -> $$0.trigger(this.parent.getTick())));
        return $$0;
    }

    public void tickAndContinue(int p_397648_) {
        try {
            this.tick(p_397648_);
        }
        catch (GameTestAssertException gameTestAssertException) {
            // empty catch block
        }
    }

    public void tickAndFailIfNotComplete(int p_397228_) {
        try {
            this.tick(p_397228_);
        }
        catch (GameTestAssertException $$1) {
            this.parent.fail($$1);
        }
    }

    private void executeWithoutFail(Runnable p_177571_) {
        try {
            p_177571_.run();
        }
        catch (GameTestAssertException $$1) {
            this.parent.fail($$1);
        }
    }

    private void tick(int p_397986_) {
        Iterator<GameTestEvent> $$1 = this.events.iterator();
        while ($$1.hasNext()) {
            GameTestEvent $$2 = $$1.next();
            $$2.assertion.run();
            $$1.remove();
            int $$3 = p_397986_ - this.lastTick;
            int $$4 = this.lastTick;
            this.lastTick = p_397986_;
            if ($$2.expectedDelay == null || $$2.expectedDelay == (long)$$3) continue;
            this.parent.fail(new GameTestAssertException(Component.translatable("test.error.sequence.invalid_tick", (long)$$4 + $$2.expectedDelay), p_397986_));
            break;
        }
    }

    public class Condition {
        private static final int NOT_TRIGGERED = -1;
        private int triggerTime = -1;

        void trigger(int p_397972_) {
            if (this.triggerTime != -1) {
                throw new IllegalStateException("Condition already triggered at " + this.triggerTime);
            }
            this.triggerTime = p_397972_;
        }

        public void assertTriggeredThisTick() {
            int $$0 = GameTestSequence.this.parent.getTick();
            if (this.triggerTime != $$0) {
                if (this.triggerTime == -1) {
                    throw new GameTestAssertException(Component.translatable("test.error.sequence.condition_not_triggered"), $$0);
                }
                throw new GameTestAssertException(Component.translatable("test.error.sequence.condition_already_triggered", this.triggerTime), $$0);
            }
        }
    }
}

