/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.ReportGameListener;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class GameTestRunner {
    public static final int DEFAULT_TESTS_PER_ROW = 8;
    private static final Logger LOGGER = LogUtils.getLogger();
    final ServerLevel level;
    private final GameTestTicker testTicker;
    private final List<GameTestInfo> allTestInfos;
    private ImmutableList<GameTestBatch> batches;
    final List<GameTestBatchListener> batchListeners = Lists.newArrayList();
    private final List<GameTestInfo> scheduledForRerun = Lists.newArrayList();
    private final GameTestBatcher testBatcher;
    private boolean stopped = true;
    @Nullable
    private Holder<TestEnvironmentDefinition> currentEnvironment;
    private final StructureSpawner existingStructureSpawner;
    private final StructureSpawner newStructureSpawner;
    final boolean haltOnError;

    protected GameTestRunner(GameTestBatcher p_320713_, Collection<GameTestBatch> p_320022_, ServerLevel p_320570_, GameTestTicker p_320736_, StructureSpawner p_320336_, StructureSpawner p_320643_, boolean p_352218_) {
        this.level = p_320570_;
        this.testTicker = p_320736_;
        this.testBatcher = p_320713_;
        this.existingStructureSpawner = p_320336_;
        this.newStructureSpawner = p_320643_;
        this.batches = ImmutableList.copyOf(p_320022_);
        this.haltOnError = p_352218_;
        this.allTestInfos = this.batches.stream().flatMap(p_319468_ -> p_319468_.gameTestInfos().stream()).collect(Util.toMutableList());
        p_320736_.setRunner(this);
        this.allTestInfos.forEach(p_319464_ -> p_319464_.addListener(new ReportGameListener()));
    }

    public List<GameTestInfo> getTestInfos() {
        return this.allTestInfos;
    }

    public void start() {
        this.stopped = false;
        this.runBatch(0);
    }

    public void stop() {
        this.stopped = true;
        if (this.currentEnvironment != null) {
            this.endCurrentEnvironment();
        }
    }

    public void rerunTest(GameTestInfo p_320525_) {
        GameTestInfo $$1 = p_320525_.copyReset();
        p_320525_.getListeners().forEach(p_319467_ -> p_319467_.testAddedForRerun(p_320525_, $$1, this));
        this.allTestInfos.add($$1);
        this.scheduledForRerun.add($$1);
        if (this.stopped) {
            this.runScheduledRerunTests();
        }
    }

    void runBatch(final int p_319917_) {
        if (p_319917_ >= this.batches.size()) {
            this.endCurrentEnvironment();
            this.runScheduledRerunTests();
            return;
        }
        final GameTestBatch $$1 = (GameTestBatch)this.batches.get(p_319917_);
        this.existingStructureSpawner.onBatchStart(this.level);
        this.newStructureSpawner.onBatchStart(this.level);
        Collection<GameTestInfo> $$2 = this.createStructuresForBatch($$1.gameTestInfos());
        LOGGER.info("Running test environment '{}' batch {} ({} tests)...", new Object[]{$$1.environment().getRegisteredName(), $$1.index(), $$2.size()});
        if (this.currentEnvironment != $$1.environment()) {
            this.endCurrentEnvironment();
            this.currentEnvironment = $$1.environment();
            this.currentEnvironment.value().setup(this.level);
        }
        this.batchListeners.forEach(p_396390_ -> p_396390_.testBatchStarting($$1));
        final MultipleTestTracker $$3 = new MultipleTestTracker();
        $$2.forEach($$3::addTestToTrack);
        $$3.addListener(new GameTestListener(){

            private void testCompleted() {
                if ($$3.isDone()) {
                    GameTestRunner.this.batchListeners.forEach(p_396393_ -> p_396393_.testBatchFinished($$1));
                    LongArraySet $$0 = new LongArraySet(GameTestRunner.this.level.getForceLoadedChunks());
                    $$0.forEach(p_319954_ -> GameTestRunner.this.level.setChunkForced(ChunkPos.getX(p_319954_), ChunkPos.getZ(p_319954_), false));
                    GameTestRunner.this.runBatch(p_319917_ + 1);
                }
            }

            @Override
            public void testStructureLoaded(GameTestInfo p_320033_) {
            }

            @Override
            public void testPassed(GameTestInfo p_320625_, GameTestRunner p_320879_) {
                this.testCompleted();
            }

            @Override
            public void testFailed(GameTestInfo p_320900_, GameTestRunner p_320892_) {
                if (GameTestRunner.this.haltOnError) {
                    GameTestRunner.this.endCurrentEnvironment();
                    LongArraySet $$2 = new LongArraySet(GameTestRunner.this.level.getForceLoadedChunks());
                    $$2.forEach(p_351713_ -> GameTestRunner.this.level.setChunkForced(ChunkPos.getX(p_351713_), ChunkPos.getZ(p_351713_), false));
                    GameTestTicker.SINGLETON.clear();
                } else {
                    this.testCompleted();
                }
            }

            @Override
            public void testAddedForRerun(GameTestInfo p_320035_, GameTestInfo p_320699_, GameTestRunner p_320447_) {
            }
        });
        $$2.forEach(this.testTicker::add);
    }

    void endCurrentEnvironment() {
        if (this.currentEnvironment != null) {
            this.currentEnvironment.value().teardown(this.level);
            this.currentEnvironment = null;
        }
    }

    private void runScheduledRerunTests() {
        if (!this.scheduledForRerun.isEmpty()) {
            LOGGER.info("Starting re-run of tests: {}", (Object)this.scheduledForRerun.stream().map(p_396391_ -> p_396391_.id().toString()).collect(Collectors.joining(", ")));
            this.batches = ImmutableList.copyOf(this.testBatcher.batch(this.scheduledForRerun));
            this.scheduledForRerun.clear();
            this.stopped = false;
            this.runBatch(0);
        } else {
            this.batches = ImmutableList.of();
            this.stopped = true;
        }
    }

    public void addListener(GameTestBatchListener p_320573_) {
        this.batchListeners.add(p_320573_);
    }

    private Collection<GameTestInfo> createStructuresForBatch(Collection<GameTestInfo> p_320080_) {
        return p_320080_.stream().map(this::spawn).flatMap(Optional::stream).toList();
    }

    private Optional<GameTestInfo> spawn(GameTestInfo p_320187_) {
        if (p_320187_.getTestBlockPos() == null) {
            return this.newStructureSpawner.spawnStructure(p_320187_);
        }
        return this.existingStructureSpawner.spawnStructure(p_320187_);
    }

    public static void clearMarkers(ServerLevel p_127686_) {
        DebugPackets.sendGameTestClearPacket(p_127686_);
    }

    public static interface GameTestBatcher {
        public Collection<GameTestBatch> batch(Collection<GameTestInfo> var1);
    }

    public static interface StructureSpawner {
        public static final StructureSpawner IN_PLACE = p_423189_ -> Optional.ofNullable(p_423189_.prepareTestStructure()).map(p_423188_ -> p_423188_.startExecution(1));
        public static final StructureSpawner NOT_SET = p_320313_ -> Optional.empty();

        public Optional<GameTestInfo> spawnStructure(GameTestInfo var1);

        default public void onBatchStart(ServerLevel p_352207_) {
        }
    }

    public static class Builder {
        private final ServerLevel level;
        private final GameTestTicker testTicker = GameTestTicker.SINGLETON;
        private GameTestBatcher batcher = GameTestBatchFactory.fromGameTestInfo();
        private StructureSpawner existingStructureSpawner = StructureSpawner.IN_PLACE;
        private StructureSpawner newStructureSpawner = StructureSpawner.NOT_SET;
        private final Collection<GameTestBatch> batches;
        private boolean haltOnError = false;

        private Builder(Collection<GameTestBatch> p_320127_, ServerLevel p_320437_) {
            this.batches = p_320127_;
            this.level = p_320437_;
        }

        public static Builder fromBatches(Collection<GameTestBatch> p_319850_, ServerLevel p_320176_) {
            return new Builder(p_319850_, p_320176_);
        }

        public static Builder fromInfo(Collection<GameTestInfo> p_319878_, ServerLevel p_320046_) {
            return Builder.fromBatches(GameTestBatchFactory.fromGameTestInfo().batch(p_319878_), p_320046_);
        }

        public Builder haltOnError(boolean p_352186_) {
            this.haltOnError = p_352186_;
            return this;
        }

        public Builder newStructureSpawner(StructureSpawner p_320647_) {
            this.newStructureSpawner = p_320647_;
            return this;
        }

        public Builder existingStructureSpawner(StructureGridSpawner p_352321_) {
            this.existingStructureSpawner = p_352321_;
            return this;
        }

        public Builder batcher(GameTestBatcher p_352338_) {
            this.batcher = p_352338_;
            return this;
        }

        public GameTestRunner build() {
            return new GameTestRunner(this.batcher, this.batches, this.level, this.testTicker, this.existingStructureSpawner, this.newStructureSpawner, this.haltOnError);
        }
    }
}

