/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class NbtToSnbt
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Iterable<Path> inputFolders;
    private final PackOutput output;

    public NbtToSnbt(PackOutput p_250442_, Collection<Path> p_249158_) {
        this.inputFolders = p_249158_;
        this.output = p_250442_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254274_) {
        Path $$1 = this.output.getOutputFolder();
        ArrayList<CompletionStage> $$2 = new ArrayList<CompletionStage>();
        for (Path $$3 : this.inputFolders) {
            $$2.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> $$3 = Files.walk($$3, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])$$3.filter(p_126430_ -> p_126430_.toString().endsWith(".nbt")).map(p_372634_ -> CompletableFuture.runAsync(() -> NbtToSnbt.convertStructure(p_254274_, p_372634_, NbtToSnbt.getName($$3, p_372634_), $$1), Util.ioPool())).toArray(CompletableFuture[]::new));
                        if ($$3 == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if ($$3 != null) {
                                try {
                                    $$3.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException $$4) {
                            LOGGER.error("Failed to read structure input directory", (Throwable)$$4);
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    $$3.close();
                }
                return completableFuture;
            }, Util.backgroundExecutor().forName("NbtToSnbt")).thenCompose(p_253420_ -> p_253420_));
        }
        return CompletableFuture.allOf((CompletableFuture[])$$2.toArray(CompletableFuture[]::new));
    }

    @Override
    public final String getName() {
        return "NBT -> SNBT";
    }

    private static String getName(Path p_126436_, Path p_126437_) {
        String $$2 = p_126436_.relativize(p_126437_).toString().replaceAll("\\\\", "/");
        return $$2.substring(0, $$2.length() - ".nbt".length());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path convertStructure(CachedOutput p_236382_, Path p_236383_, String p_236384_, Path p_236385_) {
        try (InputStream $$4 = Files.newInputStream(p_236383_, new OpenOption[0]);){
            Path path;
            try (FastBufferedInputStream $$5 = new FastBufferedInputStream($$4);){
                Path $$6 = p_236385_.resolve(p_236384_ + ".snbt");
                NbtToSnbt.writeSnbt(p_236382_, $$6, NbtUtils.structureToSnbt(NbtIo.readCompressed($$5, NbtAccounter.unlimitedHeap())));
                LOGGER.info("Converted {} from NBT to SNBT", (Object)p_236384_);
                path = $$6;
            }
            return path;
        }
        catch (IOException $$7) {
            LOGGER.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{p_236384_, p_236383_, $$7});
            return null;
        }
    }

    public static void writeSnbt(CachedOutput p_236378_, Path p_236379_, String p_236380_) throws IOException {
        ByteArrayOutputStream $$3 = new ByteArrayOutputStream();
        HashingOutputStream $$4 = new HashingOutputStream(Hashing.sha1(), (OutputStream)$$3);
        $$4.write(p_236380_.getBytes(StandardCharsets.UTF_8));
        $$4.write(10);
        p_236378_.writeIfNeeded(p_236379_, $$3.toByteArray(), $$4.hash());
    }
}

