/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.EquipmentDispenseItemBehavior;
import net.minecraft.core.dispenser.MinecartDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public interface DispenseItemBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DispenseItemBehavior NOOP = (p_302424_, p_123401_) -> p_123401_;

    public ItemStack dispense(BlockSource var1, ItemStack var2);

    public static void bootStrap() {
        DispenserBlock.registerProjectileBehavior(Items.ARROW);
        DispenserBlock.registerProjectileBehavior(Items.TIPPED_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.SPECTRAL_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.EGG);
        DispenserBlock.registerProjectileBehavior(Items.BLUE_EGG);
        DispenserBlock.registerProjectileBehavior(Items.BROWN_EGG);
        DispenserBlock.registerProjectileBehavior(Items.SNOWBALL);
        DispenserBlock.registerProjectileBehavior(Items.EXPERIENCE_BOTTLE);
        DispenserBlock.registerProjectileBehavior(Items.SPLASH_POTION);
        DispenserBlock.registerProjectileBehavior(Items.LINGERING_POTION);
        DispenserBlock.registerProjectileBehavior(Items.FIREWORK_ROCKET);
        DispenserBlock.registerProjectileBehavior(Items.FIRE_CHARGE);
        DispenserBlock.registerProjectileBehavior(Items.WIND_CHARGE);
        DefaultDispenseItemBehavior $$0 = new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource p_338275_, ItemStack p_338216_) {
                Direction $$2 = p_338275_.state().getValue(DispenserBlock.FACING);
                EntityType<?> $$3 = ((SpawnEggItem)p_338216_.getItem()).getType(p_338275_.level().registryAccess(), p_338216_);
                try {
                    $$3.spawn(p_338275_.level(), p_338216_, null, p_338275_.pos().relative($$2), EntitySpawnReason.DISPENSER, $$2 != Direction.UP, false);
                }
                catch (Exception $$4) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)p_338275_.pos(), (Object)$$4);
                    return ItemStack.EMPTY;
                }
                p_338216_.shrink(1);
                p_338275_.level().gameEvent(null, GameEvent.ENTITY_PLACE, p_338275_.pos());
                return p_338216_;
            }
        };
        for (SpawnEggItem $$1 : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior($$1, $$0);
        }
        DispenserBlock.registerBehavior(Items.ARMOR_STAND, new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource p_338813_, ItemStack p_338809_) {
                Consumer<ArmorStand> $$5;
                Direction $$2 = p_338813_.state().getValue(DispenserBlock.FACING);
                BlockPos $$3 = p_338813_.pos().relative($$2);
                ServerLevel $$4 = p_338813_.level();
                ArmorStand $$6 = EntityType.ARMOR_STAND.spawn($$4, $$5 = EntityType.appendDefaultStackConfig(p_417692_ -> p_417692_.setYRot($$2.toYRot()), $$4, p_338809_, null), $$3, EntitySpawnReason.DISPENSER, false, false);
                if ($$6 != null) {
                    p_338809_.shrink(1);
                }
                return p_338809_;
            }
        });
        DispenserBlock.registerBehavior(Items.CHEST, new OptionalDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource p_338360_, ItemStack p_338306_) {
                BlockPos $$2 = p_338360_.pos().relative(p_338360_.state().getValue(DispenserBlock.FACING));
                List<AbstractChestedHorse> $$3 = p_338360_.level().getEntitiesOfClass(AbstractChestedHorse.class, new AABB($$2), p_426942_ -> p_426942_.isAlive() && !p_426942_.hasChest());
                for (AbstractChestedHorse $$4 : $$3) {
                    if (!$$4.isTamed() || !$$4.getSlot(499).set(p_338306_)) continue;
                    p_338306_.shrink(1);
                    this.setSuccess(true);
                    return p_338306_;
                }
                return super.execute(p_338360_, p_338306_);
            }
        });
        DispenserBlock.registerBehavior(Items.OAK_BOAT, new BoatDispenseItemBehavior(EntityType.OAK_BOAT));
        DispenserBlock.registerBehavior(Items.SPRUCE_BOAT, new BoatDispenseItemBehavior(EntityType.SPRUCE_BOAT));
        DispenserBlock.registerBehavior(Items.BIRCH_BOAT, new BoatDispenseItemBehavior(EntityType.BIRCH_BOAT));
        DispenserBlock.registerBehavior(Items.JUNGLE_BOAT, new BoatDispenseItemBehavior(EntityType.JUNGLE_BOAT));
        DispenserBlock.registerBehavior(Items.DARK_OAK_BOAT, new BoatDispenseItemBehavior(EntityType.DARK_OAK_BOAT));
        DispenserBlock.registerBehavior(Items.ACACIA_BOAT, new BoatDispenseItemBehavior(EntityType.ACACIA_BOAT));
        DispenserBlock.registerBehavior(Items.CHERRY_BOAT, new BoatDispenseItemBehavior(EntityType.CHERRY_BOAT));
        DispenserBlock.registerBehavior(Items.MANGROVE_BOAT, new BoatDispenseItemBehavior(EntityType.MANGROVE_BOAT));
        DispenserBlock.registerBehavior(Items.PALE_OAK_BOAT, new BoatDispenseItemBehavior(EntityType.PALE_OAK_BOAT));
        DispenserBlock.registerBehavior(Items.BAMBOO_RAFT, new BoatDispenseItemBehavior(EntityType.BAMBOO_RAFT));
        DispenserBlock.registerBehavior(Items.OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.SPRUCE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.SPRUCE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.BIRCH_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.BIRCH_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.JUNGLE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.JUNGLE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.DARK_OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.ACACIA_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.ACACIA_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.CHERRY_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.CHERRY_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.MANGROVE_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.MANGROVE_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.PALE_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(EntityType.PALE_OAK_CHEST_BOAT));
        DispenserBlock.registerBehavior(Items.BAMBOO_CHEST_RAFT, new BoatDispenseItemBehavior(EntityType.BAMBOO_CHEST_RAFT));
        DefaultDispenseItemBehavior $$2 = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public ItemStack execute(BlockSource p_338193_, ItemStack p_338600_) {
                DispensibleContainerItem $$2 = (DispensibleContainerItem)((Object)p_338600_.getItem());
                BlockPos $$3 = p_338193_.pos().relative(p_338193_.state().getValue(DispenserBlock.FACING));
                ServerLevel $$4 = p_338193_.level();
                if ($$2.emptyContents(null, $$4, $$3, null)) {
                    $$2.checkExtraContent(null, $$4, p_338600_, $$3);
                    return this.consumeWithRemainder(p_338193_, p_338600_, new ItemStack(Items.BUCKET));
                }
                return this.defaultDispenseItemBehavior.dispense(p_338193_, p_338600_);
            }
        };
        DispenserBlock.registerBehavior(Items.LAVA_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.WATER_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.POWDER_SNOW_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.SALMON_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.COD_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.PUFFERFISH_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.TROPICAL_FISH_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.AXOLOTL_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.TADPOLE_BUCKET, $$2);
        DispenserBlock.registerBehavior(Items.BUCKET, new DefaultDispenseItemBehavior(){

            /*
             * WARNING - void declaration
             */
            @Override
            public ItemStack execute(BlockSource p_338297_, ItemStack p_338735_) {
                void $$9;
                ItemStack $$7;
                BlockPos $$3;
                ServerLevel $$2 = p_338297_.level();
                BlockState $$4 = $$2.getBlockState($$3 = p_338297_.pos().relative(p_338297_.state().getValue(DispenserBlock.FACING)));
                Block $$5 = $$4.getBlock();
                if ($$5 instanceof BucketPickup) {
                    BucketPickup $$6 = (BucketPickup)((Object)$$5);
                    $$7 = $$6.pickupBlock(null, $$2, $$3, $$4);
                    if ($$7.isEmpty()) {
                        return super.execute(p_338297_, p_338735_);
                    }
                } else {
                    return super.execute(p_338297_, p_338735_);
                }
                $$2.gameEvent(null, GameEvent.FLUID_PICKUP, $$3);
                Item $$8 = $$7.getItem();
                return this.consumeWithRemainder(p_338297_, p_338735_, new ItemStack((ItemLike)$$9));
            }
        });
        DispenserBlock.registerBehavior(Items.FLINT_AND_STEEL, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource p_338850_, ItemStack p_338251_) {
                ServerLevel $$2 = p_338850_.level();
                this.setSuccess(true);
                Direction $$3 = p_338850_.state().getValue(DispenserBlock.FACING);
                BlockPos $$4 = p_338850_.pos().relative($$3);
                BlockState $$5 = $$2.getBlockState($$4);
                if (BaseFireBlock.canBePlacedAt($$2, $$4, $$3)) {
                    $$2.setBlockAndUpdate($$4, BaseFireBlock.getState($$2, $$4));
                    $$2.gameEvent(null, GameEvent.BLOCK_PLACE, $$4);
                } else if (CampfireBlock.canLight($$5) || CandleBlock.canLight($$5) || CandleCakeBlock.canLight($$5)) {
                    $$2.setBlockAndUpdate($$4, (BlockState)$$5.setValue(BlockStateProperties.LIT, true));
                    $$2.gameEvent(null, GameEvent.BLOCK_CHANGE, $$4);
                } else if ($$5.getBlock() instanceof TntBlock) {
                    if (TntBlock.prime($$2, $$4)) {
                        $$2.removeBlock($$4, false);
                    } else {
                        this.setSuccess(false);
                    }
                } else {
                    this.setSuccess(false);
                }
                if (this.isSuccess()) {
                    p_338251_.hurtAndBreak(1, $$2, null, p_397432_ -> {});
                }
                return p_338251_;
            }
        });
        DispenserBlock.registerBehavior(Items.BONE_MEAL, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource p_338386_, ItemStack p_338526_) {
                this.setSuccess(true);
                ServerLevel $$2 = p_338386_.level();
                BlockPos $$3 = p_338386_.pos().relative(p_338386_.state().getValue(DispenserBlock.FACING));
                if (BoneMealItem.growCrop(p_338526_, $$2, $$3) || BoneMealItem.growWaterPlant(p_338526_, $$2, $$3, null)) {
                    if (!$$2.isClientSide) {
                        $$2.levelEvent(1505, $$3, 15);
                    }
                } else {
                    this.setSuccess(false);
                }
                return p_338526_;
            }
        });
        DispenserBlock.registerBehavior(Blocks.TNT, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource p_338494_, ItemStack p_338444_) {
                ServerLevel $$2 = p_338494_.level();
                if (!$$2.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
                    this.setSuccess(false);
                    return p_338444_;
                }
                BlockPos $$3 = p_338494_.pos().relative(p_338494_.state().getValue(DispenserBlock.FACING));
                PrimedTnt $$4 = new PrimedTnt($$2, (double)$$3.getX() + 0.5, $$3.getY(), (double)$$3.getZ() + 0.5, null);
                $$2.addFreshEntity($$4);
                $$2.playSound(null, $$4.getX(), $$4.getY(), $$4.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                $$2.gameEvent(null, GameEvent.ENTITY_PLACE, $$3);
                p_338444_.shrink(1);
                this.setSuccess(true);
                return p_338444_;
            }
        });
        DispenserBlock.registerBehavior(Items.WITHER_SKELETON_SKULL, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource p_302450_, ItemStack p_123524_) {
                ServerLevel $$2 = p_302450_.level();
                Direction $$3 = p_302450_.state().getValue(DispenserBlock.FACING);
                BlockPos $$4 = p_302450_.pos().relative($$3);
                if ($$2.isEmptyBlock($$4) && WitherSkullBlock.canSpawnMob($$2, $$4, p_123524_)) {
                    $$2.setBlock($$4, (BlockState)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(SkullBlock.ROTATION, RotationSegment.convertToSegment($$3)), 3);
                    $$2.gameEvent(null, GameEvent.BLOCK_PLACE, $$4);
                    BlockEntity $$5 = $$2.getBlockEntity($$4);
                    if ($$5 instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn($$2, $$4, (SkullBlockEntity)$$5);
                    }
                    p_123524_.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(p_302450_, p_123524_));
                }
                return p_123524_;
            }
        });
        DispenserBlock.registerBehavior(Blocks.CARVED_PUMPKIN, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource p_302430_, ItemStack p_123462_) {
                ServerLevel $$2 = p_302430_.level();
                BlockPos $$3 = p_302430_.pos().relative(p_302430_.state().getValue(DispenserBlock.FACING));
                CarvedPumpkinBlock $$4 = (CarvedPumpkinBlock)Blocks.CARVED_PUMPKIN;
                if ($$2.isEmptyBlock($$3) && $$4.canSpawnGolem($$2, $$3)) {
                    if (!$$2.isClientSide) {
                        $$2.setBlock($$3, $$4.defaultBlockState(), 3);
                        $$2.gameEvent(null, GameEvent.BLOCK_PLACE, $$3);
                    }
                    p_123462_.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(EquipmentDispenseItemBehavior.dispenseEquipment(p_302430_, p_123462_));
                }
                return p_123462_;
            }
        });
        DispenserBlock.registerBehavior(Blocks.SHULKER_BOX.asItem(), new ShulkerBoxDispenseBehavior());
        for (DyeColor $$3 : DyeColor.values()) {
            DispenserBlock.registerBehavior(ShulkerBoxBlock.getBlockByColor($$3).asItem(), new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.registerBehavior(Items.GLASS_BOTTLE.asItem(), new OptionalDispenseItemBehavior(){

            private ItemStack takeLiquid(BlockSource p_397959_, ItemStack p_397930_, ItemStack p_397455_) {
                p_397959_.level().gameEvent(null, GameEvent.FLUID_PICKUP, p_397959_.pos());
                return this.consumeWithRemainder(p_397959_, p_397930_, p_397455_);
            }

            @Override
            public ItemStack execute(BlockSource p_302463_, ItemStack p_123530_) {
                this.setSuccess(false);
                ServerLevel $$2 = p_302463_.level();
                BlockPos $$3 = p_302463_.pos().relative(p_302463_.state().getValue(DispenserBlock.FACING));
                BlockState $$4 = $$2.getBlockState($$3);
                if ($$4.is(BlockTags.BEEHIVES, p_397621_ -> p_397621_.hasProperty(BeehiveBlock.HONEY_LEVEL) && p_397621_.getBlock() instanceof BeehiveBlock) && $$4.getValue(BeehiveBlock.HONEY_LEVEL) >= 5) {
                    ((BeehiveBlock)$$4.getBlock()).releaseBeesAndResetHoneyLevel($$2, $$4, $$3, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(p_302463_, p_123530_, new ItemStack(Items.HONEY_BOTTLE));
                }
                if ($$2.getFluidState($$3).is(FluidTags.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(p_302463_, p_123530_, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute(p_302463_, p_123530_);
            }
        });
        DispenserBlock.registerBehavior(Items.GLOWSTONE, new OptionalDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource p_302425_, ItemStack p_123536_) {
                Direction $$2 = p_302425_.state().getValue(DispenserBlock.FACING);
                BlockPos $$3 = p_302425_.pos().relative($$2);
                ServerLevel $$4 = p_302425_.level();
                BlockState $$5 = $$4.getBlockState($$3);
                this.setSuccess(true);
                if ($$5.is(Blocks.RESPAWN_ANCHOR)) {
                    if ($$5.getValue(RespawnAnchorBlock.CHARGE) != 4) {
                        RespawnAnchorBlock.charge(null, $$4, $$3, $$5);
                        p_123536_.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return p_123536_;
                }
                return super.execute(p_302425_, p_123536_);
            }
        });
        DispenserBlock.registerBehavior(Items.SHEARS.asItem(), new ShearsDispenseItemBehavior());
        DispenserBlock.registerBehavior(Items.BRUSH.asItem(), new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource p_302452_, ItemStack p_123542_) {
                BlockPos $$3;
                ServerLevel $$2 = p_302452_.level();
                List<Entity> $$4 = $$2.getEntitiesOfClass(Armadillo.class, new AABB($$3 = p_302452_.pos().relative(p_302452_.state().getValue(DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
                if ($$4.isEmpty()) {
                    this.setSuccess(false);
                    return p_123542_;
                }
                for (Armadillo armadillo : $$4) {
                    if (!armadillo.brushOffScute()) continue;
                    p_123542_.hurtAndBreak(16, $$2, null, p_397327_ -> {});
                    return p_123542_;
                }
                this.setSuccess(false);
                return p_123542_;
            }
        });
        DispenserBlock.registerBehavior(Items.HONEYCOMB, new OptionalDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource p_302433_, ItemStack p_123548_) {
                BlockPos $$2 = p_302433_.pos().relative(p_302433_.state().getValue(DispenserBlock.FACING));
                ServerLevel $$3 = p_302433_.level();
                BlockState $$4 = $$3.getBlockState($$2);
                Optional<BlockState> $$5 = HoneycombItem.getWaxed($$4);
                if ($$5.isPresent()) {
                    $$3.setBlockAndUpdate($$2, $$5.get());
                    $$3.levelEvent(3003, $$2, 0);
                    p_123548_.shrink(1);
                    this.setSuccess(true);
                    return p_123548_;
                }
                return super.execute(p_302433_, p_123548_);
            }
        });
        DispenserBlock.registerBehavior(Items.POTION, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public ItemStack execute(BlockSource p_302423_, ItemStack p_123557_) {
                PotionContents $$2 = p_123557_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!$$2.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense(p_302423_, p_123557_);
                }
                ServerLevel $$3 = p_302423_.level();
                BlockPos $$4 = p_302423_.pos();
                BlockPos $$5 = p_302423_.pos().relative(p_302423_.state().getValue(DispenserBlock.FACING));
                if ($$3.getBlockState($$5).is(BlockTags.CONVERTABLE_TO_MUD)) {
                    if (!$$3.isClientSide) {
                        for (int $$6 = 0; $$6 < 5; ++$$6) {
                            $$3.sendParticles(ParticleTypes.SPLASH, (double)$$4.getX() + $$3.random.nextDouble(), $$4.getY() + 1, (double)$$4.getZ() + $$3.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                    $$3.playSound(null, $$4, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    $$3.gameEvent(null, GameEvent.FLUID_PLACE, $$4);
                    $$3.setBlockAndUpdate($$5, Blocks.MUD.defaultBlockState());
                    return this.consumeWithRemainder(p_302423_, p_123557_, new ItemStack(Items.GLASS_BOTTLE));
                }
                return this.defaultDispenseItemBehavior.dispense(p_302423_, p_123557_);
            }
        });
        DispenserBlock.registerBehavior(Items.MINECART, new MinecartDispenseItemBehavior(EntityType.MINECART));
        DispenserBlock.registerBehavior(Items.CHEST_MINECART, new MinecartDispenseItemBehavior(EntityType.CHEST_MINECART));
        DispenserBlock.registerBehavior(Items.FURNACE_MINECART, new MinecartDispenseItemBehavior(EntityType.FURNACE_MINECART));
        DispenserBlock.registerBehavior(Items.TNT_MINECART, new MinecartDispenseItemBehavior(EntityType.TNT_MINECART));
        DispenserBlock.registerBehavior(Items.HOPPER_MINECART, new MinecartDispenseItemBehavior(EntityType.HOPPER_MINECART));
        DispenserBlock.registerBehavior(Items.COMMAND_BLOCK_MINECART, new MinecartDispenseItemBehavior(EntityType.COMMAND_BLOCK_MINECART));
    }
}

