/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public class BoatDispenseItemBehavior
extends DefaultDispenseItemBehavior {
    private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();
    private final EntityType<? extends AbstractBoat> type;

    public BoatDispenseItemBehavior(EntityType<? extends AbstractBoat> p_376583_) {
        this.type = p_376583_;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ItemStack execute(BlockSource p_302460_, ItemStack p_123376_) {
        Direction $$2 = p_302460_.state().getValue(DispenserBlock.FACING);
        ServerLevel $$3 = p_302460_.level();
        Vec3 $$4 = p_302460_.center();
        double $$5 = 0.5625 + (double)this.type.getWidth() / 2.0;
        double $$6 = $$4.x() + (double)$$2.getStepX() * $$5;
        double $$7 = $$4.y() + (double)((float)$$2.getStepY() * 1.125f);
        double $$8 = $$4.z() + (double)$$2.getStepZ() * $$5;
        BlockPos $$9 = p_302460_.pos().relative($$2);
        if ($$3.getFluidState($$9).is(FluidTags.WATER)) {
            double $$10 = 1.0;
        } else if ($$3.getBlockState($$9).isAir() && $$3.getFluidState($$9.below()).is(FluidTags.WATER)) {
            double $$11 = 0.0;
        } else {
            return this.defaultDispenseItemBehavior.dispense(p_302460_, p_123376_);
        }
        AbstractBoat $$13 = this.type.create($$3, EntitySpawnReason.DISPENSER);
        if ($$13 != null) {
            void $$12;
            $$13.setInitialPos($$6, $$7 + $$12, $$8);
            EntityType.createDefaultStackConfig($$3, p_123376_, null).accept($$13);
            $$13.setYRot($$2.toYRot());
            $$3.addFreshEntity($$13);
            p_123376_.shrink(1);
        }
        return p_123376_;
    }

    @Override
    protected void playSound(BlockSource p_302465_) {
        p_302465_.level().levelEvent(1000, p_302465_.pos(), 0);
    }
}

