/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public final class PatchedDataComponentMap
implements DataComponentMap {
    private final DataComponentMap prototype;
    private Reference2ObjectMap<DataComponentType<?>, Optional<?>> patch;
    private boolean copyOnWrite;

    public PatchedDataComponentMap(DataComponentMap p_332070_) {
        this(p_332070_, Reference2ObjectMaps.emptyMap(), true);
    }

    private PatchedDataComponentMap(DataComponentMap p_331644_, Reference2ObjectMap<DataComponentType<?>, Optional<?>> p_331707_, boolean p_331170_) {
        this.prototype = p_331644_;
        this.patch = p_331707_;
        this.copyOnWrite = p_331170_;
    }

    public static PatchedDataComponentMap fromPatch(DataComponentMap p_331807_, DataComponentPatch p_331890_) {
        if (PatchedDataComponentMap.isPatchSanitized(p_331807_, p_331890_.map)) {
            return new PatchedDataComponentMap(p_331807_, p_331890_.map, true);
        }
        PatchedDataComponentMap $$2 = new PatchedDataComponentMap(p_331807_);
        $$2.applyPatch(p_331890_);
        return $$2;
    }

    private static boolean isPatchSanitized(DataComponentMap p_331938_, Reference2ObjectMap<DataComponentType<?>, Optional<?>> p_330946_) {
        for (Map.Entry $$2 : Reference2ObjectMaps.fastIterable(p_330946_)) {
            Object $$3 = p_331938_.get((DataComponentType)$$2.getKey());
            Optional $$4 = (Optional)$$2.getValue();
            if ($$4.isPresent() && $$4.get().equals($$3)) {
                return false;
            }
            if (!$$4.isEmpty() || $$3 != null) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> p_331587_) {
        Optional $$1 = (Optional)this.patch.get(p_331587_);
        if ($$1 != null) {
            return $$1.orElse(null);
        }
        return this.prototype.get(p_331587_);
    }

    public boolean hasNonDefault(DataComponentType<?> p_389544_) {
        return this.patch.containsKey(p_389544_);
    }

    @Nullable
    public <T> T set(DataComponentType<T> p_330791_, @Nullable T p_330369_) {
        Optional $$4;
        this.ensureMapOwnership();
        T $$2 = this.prototype.get(p_330791_);
        if (Objects.equals(p_330369_, $$2)) {
            Optional $$3 = (Optional)this.patch.remove(p_330791_);
        } else {
            $$4 = (Optional)this.patch.put(p_330791_, Optional.ofNullable(p_330369_));
        }
        if ($$4 != null) {
            return $$4.orElse($$2);
        }
        return $$2;
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> p_330831_) {
        Optional $$3;
        this.ensureMapOwnership();
        T $$1 = this.prototype.get(p_330831_);
        if ($$1 != null) {
            Optional $$2 = (Optional)this.patch.put(p_330831_, Optional.empty());
        } else {
            $$3 = (Optional)this.patch.remove(p_330831_);
        }
        if ($$3 != null) {
            return $$3.orElse(null);
        }
        return $$1;
    }

    public void applyPatch(DataComponentPatch p_331964_) {
        this.ensureMapOwnership();
        for (Map.Entry $$1 : Reference2ObjectMaps.fastIterable(p_331964_.map)) {
            this.applyPatch((DataComponentType)$$1.getKey(), (Optional)$$1.getValue());
        }
    }

    private void applyPatch(DataComponentType<?> p_331724_, Optional<?> p_331550_) {
        Object $$2 = this.prototype.get(p_331724_);
        if (p_331550_.isPresent()) {
            if (p_331550_.get().equals($$2)) {
                this.patch.remove(p_331724_);
            } else {
                this.patch.put(p_331724_, p_331550_);
            }
        } else if ($$2 != null) {
            this.patch.put(p_331724_, Optional.empty());
        } else {
            this.patch.remove(p_331724_);
        }
    }

    public void restorePatch(DataComponentPatch p_341355_) {
        this.ensureMapOwnership();
        this.patch.clear();
        this.patch.putAll(p_341355_.map);
    }

    public void clearPatch() {
        this.ensureMapOwnership();
        this.patch.clear();
    }

    public void setAll(DataComponentMap p_331652_) {
        for (TypedDataComponent<?> $$1 : p_331652_) {
            $$1.applyTo(this);
        }
    }

    private void ensureMapOwnership() {
        if (this.copyOnWrite) {
            this.patch = new Reference2ObjectArrayMap(this.patch);
            this.copyOnWrite = false;
        }
    }

    @Override
    public Set<DataComponentType<?>> keySet() {
        if (this.patch.isEmpty()) {
            return this.prototype.keySet();
        }
        ReferenceArraySet $$0 = new ReferenceArraySet(this.prototype.keySet());
        for (Reference2ObjectMap.Entry $$1 : Reference2ObjectMaps.fastIterable(this.patch)) {
            Optional $$2 = (Optional)$$1.getValue();
            if ($$2.isPresent()) {
                $$0.add((DataComponentType)$$1.getKey());
                continue;
            }
            $$0.remove($$1.getKey());
        }
        return $$0;
    }

    @Override
    public Iterator<TypedDataComponent<?>> iterator() {
        if (this.patch.isEmpty()) {
            return this.prototype.iterator();
        }
        ArrayList<TypedDataComponent> $$0 = new ArrayList<TypedDataComponent>(this.patch.size() + this.prototype.size());
        for (Reference2ObjectMap.Entry $$1 : Reference2ObjectMaps.fastIterable(this.patch)) {
            if (!((Optional)$$1.getValue()).isPresent()) continue;
            $$0.add(TypedDataComponent.createUnchecked((DataComponentType)$$1.getKey(), ((Optional)$$1.getValue()).get()));
        }
        for (TypedDataComponent $$2 : this.prototype) {
            if (this.patch.containsKey($$2.type())) continue;
            $$0.add($$2);
        }
        return $$0.iterator();
    }

    @Override
    public int size() {
        int $$0 = this.prototype.size();
        for (Reference2ObjectMap.Entry $$1 : Reference2ObjectMaps.fastIterable(this.patch)) {
            boolean $$3;
            boolean $$2 = ((Optional)$$1.getValue()).isPresent();
            if ($$2 == ($$3 = this.prototype.has((DataComponentType)$$1.getKey()))) continue;
            $$0 += $$2 ? 1 : -1;
        }
        return $$0;
    }

    public DataComponentPatch asPatch() {
        if (this.patch.isEmpty()) {
            return DataComponentPatch.EMPTY;
        }
        this.copyOnWrite = true;
        return new DataComponentPatch(this.patch);
    }

    public PatchedDataComponentMap copy() {
        this.copyOnWrite = true;
        return new PatchedDataComponentMap(this.prototype, this.patch, true);
    }

    public DataComponentMap toImmutableMap() {
        if (this.patch.isEmpty()) {
            return this.prototype;
        }
        return this.copy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_332106_) {
        if (this == p_332106_) {
            return true;
        }
        if (!(p_332106_ instanceof PatchedDataComponentMap)) return false;
        PatchedDataComponentMap $$1 = (PatchedDataComponentMap)p_332106_;
        if (!this.prototype.equals($$1.prototype)) return false;
        if (!this.patch.equals($$1.patch)) return false;
        return true;
    }

    public int hashCode() {
        return this.prototype.hashCode() + this.patch.hashCode() * 31;
    }

    public String toString() {
        return "{" + this.stream().map(TypedDataComponent::toString).collect(Collectors.joining(", ")) + "}";
    }
}

