/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public interface Registry<T>
extends Keyable,
HolderLookup.RegistryLookup<T>,
IdMap<T> {
    @Override
    public ResourceKey<? extends Registry<T>> key();

    default public Codec<T> byNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(Holder.Reference::value, p_325515_ -> this.safeCastToReference(this.wrapAsHolder(p_325515_)));
    }

    default public Codec<Holder<T>> holderByNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(p_325516_ -> p_325516_, this::safeCastToReference);
    }

    private Codec<Holder.Reference<T>> referenceHolderWithLifecycle() {
        Codec $$0 = ResourceLocation.CODEC.comapFlatMap(p_367803_ -> this.get((ResourceLocation)p_367803_).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.key()) + ": " + String.valueOf(p_367803_))), p_325513_ -> p_325513_.key().location());
        return ExtraCodecs.overrideLifecycle($$0, p_325514_ -> this.registrationInfo(p_325514_.key()).map(RegistrationInfo::lifecycle).orElse(Lifecycle.experimental()));
    }

    private DataResult<Holder.Reference<T>> safeCastToReference(Holder<T> p_326365_) {
        DataResult dataResult;
        if (p_326365_ instanceof Holder.Reference) {
            Holder.Reference $$1 = (Holder.Reference)p_326365_;
            dataResult = DataResult.success((Object)$$1);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(this.key()) + ": " + String.valueOf(p_326365_));
        }
        return dataResult;
    }

    default public <U> Stream<U> keys(DynamicOps<U> p_123030_) {
        return this.keySet().stream().map(p_235784_ -> p_123030_.createString(p_235784_.toString()));
    }

    @Nullable
    public ResourceLocation getKey(T var1);

    public Optional<ResourceKey<T>> getResourceKey(T var1);

    @Override
    public int getId(@Nullable T var1);

    @Nullable
    public T getValue(@Nullable ResourceKey<T> var1);

    @Nullable
    public T getValue(@Nullable ResourceLocation var1);

    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> var1);

    default public Optional<T> getOptional(@Nullable ResourceLocation p_123007_) {
        return Optional.ofNullable(this.getValue(p_123007_));
    }

    default public Optional<T> getOptional(@Nullable ResourceKey<T> p_123010_) {
        return Optional.ofNullable(this.getValue(p_123010_));
    }

    public Optional<Holder.Reference<T>> getAny();

    default public T getValueOrThrow(ResourceKey<T> p_368664_) {
        T $$1 = this.getValue(p_368664_);
        if ($$1 == null) {
            throw new IllegalStateException("Missing key in " + String.valueOf(this.key()) + ": " + String.valueOf(p_368664_));
        }
        return $$1;
    }

    public Set<ResourceLocation> keySet();

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet();

    public Set<ResourceKey<T>> registryKeySet();

    public Optional<Holder.Reference<T>> getRandom(RandomSource var1);

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean containsKey(ResourceLocation var1);

    public boolean containsKey(ResourceKey<T> var1);

    public static <T> T register(Registry<? super T> p_122962_, String p_122963_, T p_122964_) {
        return Registry.register(p_122962_, ResourceLocation.parse(p_122963_), p_122964_);
    }

    public static <V, T extends V> T register(Registry<V> p_122966_, ResourceLocation p_122967_, T p_122968_) {
        return Registry.register(p_122966_, ResourceKey.create(p_122966_.key(), p_122967_), p_122968_);
    }

    public static <V, T extends V> T register(Registry<V> p_194580_, ResourceKey<V> p_194581_, T p_194582_) {
        ((WritableRegistry)p_194580_).register(p_194581_, p_194582_, RegistrationInfo.BUILT_IN);
        return p_194582_;
    }

    public static <T> Holder.Reference<T> registerForHolder(Registry<T> p_263347_, ResourceKey<T> p_263355_, T p_263428_) {
        return ((WritableRegistry)p_263347_).register(p_263355_, p_263428_, RegistrationInfo.BUILT_IN);
    }

    public static <T> Holder.Reference<T> registerForHolder(Registry<T> p_263351_, ResourceLocation p_263363_, T p_263423_) {
        return Registry.registerForHolder(p_263351_, ResourceKey.create(p_263351_.key(), p_263363_), p_263423_);
    }

    public Registry<T> freeze();

    public Holder.Reference<T> createIntrusiveHolder(T var1);

    public Optional<Holder.Reference<T>> get(int var1);

    public Optional<Holder.Reference<T>> get(ResourceLocation var1);

    public Holder<T> wrapAsHolder(T var1);

    default public Iterable<Holder<T>> getTagOrEmpty(TagKey<T> p_206059_) {
        return (Iterable)DataFixUtils.orElse((Optional)this.get(p_206059_), List.of());
    }

    default public Optional<Holder<T>> getRandomElementOf(TagKey<T> p_320357_, RandomSource p_320935_) {
        return this.get(p_320357_).flatMap(p_319421_ -> p_319421_.getRandomElement(p_320935_));
    }

    public Stream<HolderSet.Named<T>> getTags();

    default public IdMap<Holder<T>> asHolderIdMap() {
        return new IdMap<Holder<T>>(){

            @Override
            public int getId(Holder<T> p_259992_) {
                return Registry.this.getId(p_259992_.value());
            }

            @Override
            @Nullable
            public Holder<T> byId(int p_259972_) {
                return Registry.this.get(p_259972_).orElse(null);
            }

            @Override
            public int size() {
                return Registry.this.size();
            }

            @Override
            public Iterator<Holder<T>> iterator() {
                return Registry.this.listElements().map(p_260061_ -> p_260061_).iterator();
            }

            @Override
            @Nullable
            public /* synthetic */ Object byId(int n) {
                return this.byId(n);
            }
        };
    }

    public PendingTags<T> prepareTagReload(TagLoader.LoadResult<T> var1);

    public static interface PendingTags<T> {
        public ResourceKey<? extends Registry<? extends T>> key();

        public HolderLookup.RegistryLookup<T> lookup();

        public void apply();

        public int size();
    }
}

