/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.AbstractIterator;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.Util;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

@Immutable
public class BlockPos
extends Vec3i {
    public static final Codec<BlockPos> CODEC = Codec.INT_STREAM.comapFlatMap(p_337445_ -> Util.fixedSize(p_337445_, 3).map(p_175270_ -> new BlockPos(p_175270_[0], p_175270_[1], p_175270_[2])), p_121924_ -> IntStream.of(p_121924_.getX(), p_121924_.getY(), p_121924_.getZ())).stable();
    public static final StreamCodec<ByteBuf, BlockPos> STREAM_CODEC = new StreamCodec<ByteBuf, BlockPos>(){

        @Override
        public BlockPos decode(ByteBuf p_320431_) {
            return FriendlyByteBuf.readBlockPos(p_320431_);
        }

        @Override
        public void encode(ByteBuf p_320258_, BlockPos p_320532_) {
            FriendlyByteBuf.writeBlockPos(p_320258_, p_320532_);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (BlockPos)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BlockPos ZERO = new BlockPos(0, 0, 0);
    public static final int PACKED_HORIZONTAL_LENGTH = 1 + Mth.log2(Mth.smallestEncompassingPowerOfTwo(30000000));
    public static final int PACKED_Y_LENGTH = 64 - 2 * PACKED_HORIZONTAL_LENGTH;
    private static final long PACKED_X_MASK = (1L << PACKED_HORIZONTAL_LENGTH) - 1L;
    private static final long PACKED_Y_MASK = (1L << PACKED_Y_LENGTH) - 1L;
    private static final long PACKED_Z_MASK = (1L << PACKED_HORIZONTAL_LENGTH) - 1L;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET = PACKED_Y_LENGTH;
    private static final int X_OFFSET = PACKED_Y_LENGTH + PACKED_HORIZONTAL_LENGTH;
    public static final int MAX_HORIZONTAL_COORDINATE = (1 << PACKED_HORIZONTAL_LENGTH) / 2 - 1;

    public BlockPos(int p_121869_, int p_121870_, int p_121871_) {
        super(p_121869_, p_121870_, p_121871_);
    }

    public BlockPos(Vec3i p_121877_) {
        this(p_121877_.getX(), p_121877_.getY(), p_121877_.getZ());
    }

    public static long offset(long p_121916_, Direction p_121917_) {
        return BlockPos.offset(p_121916_, p_121917_.getStepX(), p_121917_.getStepY(), p_121917_.getStepZ());
    }

    public static long offset(long p_121911_, int p_121912_, int p_121913_, int p_121914_) {
        return BlockPos.asLong(BlockPos.getX(p_121911_) + p_121912_, BlockPos.getY(p_121911_) + p_121913_, BlockPos.getZ(p_121911_) + p_121914_);
    }

    public static int getX(long p_121984_) {
        return (int)(p_121984_ << 64 - X_OFFSET - PACKED_HORIZONTAL_LENGTH >> 64 - PACKED_HORIZONTAL_LENGTH);
    }

    public static int getY(long p_122009_) {
        return (int)(p_122009_ << 64 - PACKED_Y_LENGTH >> 64 - PACKED_Y_LENGTH);
    }

    public static int getZ(long p_122016_) {
        return (int)(p_122016_ << 64 - Z_OFFSET - PACKED_HORIZONTAL_LENGTH >> 64 - PACKED_HORIZONTAL_LENGTH);
    }

    public static BlockPos of(long p_122023_) {
        return new BlockPos(BlockPos.getX(p_122023_), BlockPos.getY(p_122023_), BlockPos.getZ(p_122023_));
    }

    public static BlockPos containing(double p_275310_, double p_275414_, double p_275737_) {
        return new BlockPos(Mth.floor(p_275310_), Mth.floor(p_275414_), Mth.floor(p_275737_));
    }

    public static BlockPos containing(Position p_275443_) {
        return BlockPos.containing(p_275443_.x(), p_275443_.y(), p_275443_.z());
    }

    public static BlockPos min(BlockPos p_333745_, BlockPos p_333943_) {
        return new BlockPos(Math.min(p_333745_.getX(), p_333943_.getX()), Math.min(p_333745_.getY(), p_333943_.getY()), Math.min(p_333745_.getZ(), p_333943_.getZ()));
    }

    public static BlockPos max(BlockPos p_334008_, BlockPos p_333743_) {
        return new BlockPos(Math.max(p_334008_.getX(), p_333743_.getX()), Math.max(p_334008_.getY(), p_333743_.getY()), Math.max(p_334008_.getZ(), p_333743_.getZ()));
    }

    public long asLong() {
        return BlockPos.asLong(this.getX(), this.getY(), this.getZ());
    }

    public static long asLong(int p_121883_, int p_121884_, int p_121885_) {
        long $$3 = 0L;
        $$3 |= ((long)p_121883_ & PACKED_X_MASK) << X_OFFSET;
        $$3 |= ((long)p_121884_ & PACKED_Y_MASK) << 0;
        return $$3 |= ((long)p_121885_ & PACKED_Z_MASK) << Z_OFFSET;
    }

    public static long getFlatIndex(long p_122028_) {
        return p_122028_ & 0xFFFFFFFFFFFFFFF0L;
    }

    @Override
    public BlockPos offset(int p_121973_, int p_121974_, int p_121975_) {
        if (p_121973_ == 0 && p_121974_ == 0 && p_121975_ == 0) {
            return this;
        }
        return new BlockPos(this.getX() + p_121973_, this.getY() + p_121974_, this.getZ() + p_121975_);
    }

    public Vec3 getCenter() {
        return Vec3.atCenterOf(this);
    }

    public Vec3 getBottomCenter() {
        return Vec3.atBottomCenterOf(this);
    }

    @Override
    public BlockPos offset(Vec3i p_121956_) {
        return this.offset(p_121956_.getX(), p_121956_.getY(), p_121956_.getZ());
    }

    @Override
    public BlockPos subtract(Vec3i p_121997_) {
        return this.offset(-p_121997_.getX(), -p_121997_.getY(), -p_121997_.getZ());
    }

    @Override
    public BlockPos multiply(int p_175263_) {
        if (p_175263_ == 1) {
            return this;
        }
        if (p_175263_ == 0) {
            return ZERO;
        }
        return new BlockPos(this.getX() * p_175263_, this.getY() * p_175263_, this.getZ() * p_175263_);
    }

    @Override
    public BlockPos above() {
        return this.relative(Direction.UP);
    }

    @Override
    public BlockPos above(int p_121972_) {
        return this.relative(Direction.UP, p_121972_);
    }

    @Override
    public BlockPos below() {
        return this.relative(Direction.DOWN);
    }

    @Override
    public BlockPos below(int p_122000_) {
        return this.relative(Direction.DOWN, p_122000_);
    }

    @Override
    public BlockPos north() {
        return this.relative(Direction.NORTH);
    }

    @Override
    public BlockPos north(int p_122014_) {
        return this.relative(Direction.NORTH, p_122014_);
    }

    @Override
    public BlockPos south() {
        return this.relative(Direction.SOUTH);
    }

    @Override
    public BlockPos south(int p_122021_) {
        return this.relative(Direction.SOUTH, p_122021_);
    }

    @Override
    public BlockPos west() {
        return this.relative(Direction.WEST);
    }

    @Override
    public BlockPos west(int p_122026_) {
        return this.relative(Direction.WEST, p_122026_);
    }

    @Override
    public BlockPos east() {
        return this.relative(Direction.EAST);
    }

    @Override
    public BlockPos east(int p_122031_) {
        return this.relative(Direction.EAST, p_122031_);
    }

    @Override
    public BlockPos relative(Direction p_121946_) {
        return new BlockPos(this.getX() + p_121946_.getStepX(), this.getY() + p_121946_.getStepY(), this.getZ() + p_121946_.getStepZ());
    }

    @Override
    public BlockPos relative(Direction p_121948_, int p_121949_) {
        if (p_121949_ == 0) {
            return this;
        }
        return new BlockPos(this.getX() + p_121948_.getStepX() * p_121949_, this.getY() + p_121948_.getStepY() * p_121949_, this.getZ() + p_121948_.getStepZ() * p_121949_);
    }

    @Override
    public BlockPos relative(Direction.Axis p_121943_, int p_121944_) {
        if (p_121944_ == 0) {
            return this;
        }
        int $$2 = p_121943_ == Direction.Axis.X ? p_121944_ : 0;
        int $$3 = p_121943_ == Direction.Axis.Y ? p_121944_ : 0;
        int $$4 = p_121943_ == Direction.Axis.Z ? p_121944_ : 0;
        return new BlockPos(this.getX() + $$2, this.getY() + $$3, this.getZ() + $$4);
    }

    public BlockPos rotate(Rotation p_121918_) {
        switch (p_121918_) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new BlockPos(-this.getZ(), this.getY(), this.getX());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-this.getX(), this.getY(), -this.getZ());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.getZ(), this.getY(), -this.getX());
    }

    @Override
    public BlockPos cross(Vec3i p_122011_) {
        return new BlockPos(this.getY() * p_122011_.getZ() - this.getZ() * p_122011_.getY(), this.getZ() * p_122011_.getX() - this.getX() * p_122011_.getZ(), this.getX() * p_122011_.getY() - this.getY() * p_122011_.getX());
    }

    public BlockPos atY(int p_175289_) {
        return new BlockPos(this.getX(), p_175289_, this.getZ());
    }

    public BlockPos immutable() {
        return this;
    }

    public MutableBlockPos mutable() {
        return new MutableBlockPos(this.getX(), this.getY(), this.getZ());
    }

    public Vec3 clampLocationWithin(Vec3 p_350293_) {
        return new Vec3(Mth.clamp(p_350293_.x, (double)((float)this.getX() + 1.0E-5f), (double)this.getX() + 1.0 - (double)1.0E-5f), Mth.clamp(p_350293_.y, (double)((float)this.getY() + 1.0E-5f), (double)this.getY() + 1.0 - (double)1.0E-5f), Mth.clamp(p_350293_.z, (double)((float)this.getZ() + 1.0E-5f), (double)this.getZ() + 1.0 - (double)1.0E-5f));
    }

    public static Iterable<BlockPos> randomInCube(RandomSource p_235651_, int p_235652_, BlockPos p_235653_, int p_235654_) {
        return BlockPos.randomBetweenClosed(p_235651_, p_235652_, p_235653_.getX() - p_235654_, p_235653_.getY() - p_235654_, p_235653_.getZ() - p_235654_, p_235653_.getX() + p_235654_, p_235653_.getY() + p_235654_, p_235653_.getZ() + p_235654_);
    }

    @Deprecated
    public static Stream<BlockPos> squareOutSouthEast(BlockPos p_284978_) {
        return Stream.of(p_284978_, p_284978_.south(), p_284978_.east(), p_284978_.south().east());
    }

    public static Iterable<BlockPos> randomBetweenClosed(final RandomSource p_235642_, final int p_235643_, final int p_235644_, final int p_235645_, final int p_235646_, int p_235647_, int p_235648_, int p_235649_) {
        final int $$8 = p_235647_ - p_235644_ + 1;
        final int $$9 = p_235648_ - p_235645_ + 1;
        final int $$10 = p_235649_ - p_235646_ + 1;
        return () -> new AbstractIterator<BlockPos>(){
            final MutableBlockPos nextPos = new MutableBlockPos();
            int counter = p_235643_;

            protected BlockPos computeNext() {
                if (this.counter <= 0) {
                    return (BlockPos)this.endOfData();
                }
                MutableBlockPos $$0 = this.nextPos.set(p_235644_ + p_235642_.nextInt($$8), p_235645_ + p_235642_.nextInt($$9), p_235646_ + p_235642_.nextInt($$10));
                --this.counter;
                return $$0;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<BlockPos> withinManhattan(BlockPos p_121926_, final int p_121927_, final int p_121928_, final int p_121929_) {
        final int $$4 = p_121927_ + p_121928_ + p_121929_;
        final int $$5 = p_121926_.getX();
        final int $$6 = p_121926_.getY();
        final int $$7 = p_121926_.getZ();
        return () -> new AbstractIterator<BlockPos>(){
            private final MutableBlockPos cursor = new MutableBlockPos();
            private int currentDepth;
            private int maxX;
            private int maxY;
            private int x;
            private int y;
            private boolean zMirror;

            protected BlockPos computeNext() {
                if (this.zMirror) {
                    this.zMirror = false;
                    this.cursor.setZ($$7 - (this.cursor.getZ() - $$7));
                    return this.cursor;
                }
                MutableBlockPos $$0 = null;
                while ($$0 == null) {
                    if (this.y > this.maxY) {
                        ++this.x;
                        if (this.x > this.maxX) {
                            ++this.currentDepth;
                            if (this.currentDepth > $$4) {
                                return (BlockPos)this.endOfData();
                            }
                            this.maxX = Math.min(p_121927_, this.currentDepth);
                            this.x = -this.maxX;
                        }
                        this.maxY = Math.min(p_121928_, this.currentDepth - Math.abs(this.x));
                        this.y = -this.maxY;
                    }
                    int $$1 = this.x;
                    int $$2 = this.y;
                    int $$3 = this.currentDepth - Math.abs($$1) - Math.abs($$2);
                    if ($$3 <= p_121929_) {
                        this.zMirror = $$3 != 0;
                        $$0 = this.cursor.set($$5 + $$1, $$6 + $$2, $$7 + $$3);
                    }
                    ++this.y;
                }
                return $$0;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Optional<BlockPos> findClosestMatch(BlockPos p_121931_, int p_121932_, int p_121933_, Predicate<BlockPos> p_121934_) {
        for (BlockPos $$4 : BlockPos.withinManhattan(p_121931_, p_121932_, p_121933_, p_121932_)) {
            if (!p_121934_.test($$4)) continue;
            return Optional.of($$4);
        }
        return Optional.empty();
    }

    public static Stream<BlockPos> withinManhattanStream(BlockPos p_121986_, int p_121987_, int p_121988_, int p_121989_) {
        return StreamSupport.stream(BlockPos.withinManhattan(p_121986_, p_121987_, p_121988_, p_121989_).spliterator(), false);
    }

    public static Iterable<BlockPos> betweenClosed(AABB p_361553_) {
        BlockPos $$1 = BlockPos.containing(p_361553_.minX, p_361553_.minY, p_361553_.minZ);
        BlockPos $$2 = BlockPos.containing(p_361553_.maxX, p_361553_.maxY, p_361553_.maxZ);
        return BlockPos.betweenClosed($$1, $$2);
    }

    public static Iterable<BlockPos> betweenClosed(BlockPos p_121941_, BlockPos p_121942_) {
        return BlockPos.betweenClosed(Math.min(p_121941_.getX(), p_121942_.getX()), Math.min(p_121941_.getY(), p_121942_.getY()), Math.min(p_121941_.getZ(), p_121942_.getZ()), Math.max(p_121941_.getX(), p_121942_.getX()), Math.max(p_121941_.getY(), p_121942_.getY()), Math.max(p_121941_.getZ(), p_121942_.getZ()));
    }

    public static Stream<BlockPos> betweenClosedStream(BlockPos p_121991_, BlockPos p_121992_) {
        return StreamSupport.stream(BlockPos.betweenClosed(p_121991_, p_121992_).spliterator(), false);
    }

    public static Stream<BlockPos> betweenClosedStream(BoundingBox p_121920_) {
        return BlockPos.betweenClosedStream(Math.min(p_121920_.minX(), p_121920_.maxX()), Math.min(p_121920_.minY(), p_121920_.maxY()), Math.min(p_121920_.minZ(), p_121920_.maxZ()), Math.max(p_121920_.minX(), p_121920_.maxX()), Math.max(p_121920_.minY(), p_121920_.maxY()), Math.max(p_121920_.minZ(), p_121920_.maxZ()));
    }

    public static Stream<BlockPos> betweenClosedStream(AABB p_121922_) {
        return BlockPos.betweenClosedStream(Mth.floor(p_121922_.minX), Mth.floor(p_121922_.minY), Mth.floor(p_121922_.minZ), Mth.floor(p_121922_.maxX), Mth.floor(p_121922_.maxY), Mth.floor(p_121922_.maxZ));
    }

    public static Stream<BlockPos> betweenClosedStream(int p_121887_, int p_121888_, int p_121889_, int p_121890_, int p_121891_, int p_121892_) {
        return StreamSupport.stream(BlockPos.betweenClosed(p_121887_, p_121888_, p_121889_, p_121890_, p_121891_, p_121892_).spliterator(), false);
    }

    public static Iterable<BlockPos> betweenClosed(final int p_121977_, final int p_121978_, final int p_121979_, int p_121980_, int p_121981_, int p_121982_) {
        final int $$6 = p_121980_ - p_121977_ + 1;
        final int $$7 = p_121981_ - p_121978_ + 1;
        int $$8 = p_121982_ - p_121979_ + 1;
        final int $$9 = $$6 * $$7 * $$8;
        return () -> new AbstractIterator<BlockPos>(){
            private final MutableBlockPos cursor = new MutableBlockPos();
            private int index;

            protected BlockPos computeNext() {
                if (this.index == $$9) {
                    return (BlockPos)this.endOfData();
                }
                int $$0 = this.index % $$6;
                int $$1 = this.index / $$6;
                int $$2 = $$1 % $$7;
                int $$3 = $$1 / $$7;
                ++this.index;
                return this.cursor.set(p_121977_ + $$0, p_121978_ + $$2, p_121979_ + $$3);
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<MutableBlockPos> spiralAround(final BlockPos p_121936_, final int p_121937_, final Direction p_121938_, final Direction p_121939_) {
        Validate.validState((p_121938_.getAxis() != p_121939_.getAxis() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<MutableBlockPos>(){
            private final Direction[] directions;
            private final MutableBlockPos cursor;
            private final int legs;
            private int leg;
            private int legSize;
            private int legIndex;
            private int lastX;
            private int lastY;
            private int lastZ;
            {
                this.directions = new Direction[]{p_121938_, p_121939_, p_121938_.getOpposite(), p_121939_.getOpposite()};
                this.cursor = p_121936_.mutable().move(p_121939_);
                this.legs = 4 * p_121937_;
                this.leg = -1;
                this.lastX = this.cursor.getX();
                this.lastY = this.cursor.getY();
                this.lastZ = this.cursor.getZ();
            }

            protected MutableBlockPos computeNext() {
                this.cursor.set(this.lastX, this.lastY, this.lastZ).move(this.directions[(this.leg + 4) % 4]);
                this.lastX = this.cursor.getX();
                this.lastY = this.cursor.getY();
                this.lastZ = this.cursor.getZ();
                if (this.legIndex >= this.legSize) {
                    if (this.leg >= this.legs) {
                        return (MutableBlockPos)this.endOfData();
                    }
                    ++this.leg;
                    this.legIndex = 0;
                    this.legSize = this.leg / 2 + 1;
                }
                ++this.legIndex;
                return this.cursor;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static int breadthFirstTraversal(BlockPos p_278078_, int p_277385_, int p_277666_, BiConsumer<BlockPos, Consumer<BlockPos>> p_277755_, Function<BlockPos, TraversalNodeStatus> p_382816_) {
        ArrayDeque<Pair> $$5 = new ArrayDeque<Pair>();
        LongOpenHashSet $$6 = new LongOpenHashSet();
        $$5.add(Pair.of((Object)p_278078_, (Object)0));
        int $$7 = 0;
        while (!$$5.isEmpty()) {
            TraversalNodeStatus $$12;
            Pair $$8 = (Pair)$$5.poll();
            BlockPos $$9 = (BlockPos)$$8.getLeft();
            int $$10 = (Integer)$$8.getRight();
            long $$11 = $$9.asLong();
            if (!$$6.add($$11) || ($$12 = p_382816_.apply($$9)) == TraversalNodeStatus.SKIP) continue;
            if ($$12 == TraversalNodeStatus.STOP) break;
            if (++$$7 >= p_277666_) {
                return $$7;
            }
            if ($$10 >= p_277385_) continue;
            p_277755_.accept($$9, p_277234_ -> $$5.add(Pair.of((Object)p_277234_, (Object)($$10 + 1))));
        }
        return $$7;
    }

    @Override
    public /* synthetic */ Vec3i cross(Vec3i vec3i) {
        return this.cross(vec3i);
    }

    @Override
    public /* synthetic */ Vec3i relative(Direction.Axis axis, int n) {
        return this.relative(axis, n);
    }

    @Override
    public /* synthetic */ Vec3i relative(Direction direction, int n) {
        return this.relative(direction, n);
    }

    @Override
    public /* synthetic */ Vec3i relative(Direction direction) {
        return this.relative(direction);
    }

    @Override
    public /* synthetic */ Vec3i east(int n) {
        return this.east(n);
    }

    @Override
    public /* synthetic */ Vec3i east() {
        return this.east();
    }

    @Override
    public /* synthetic */ Vec3i west(int n) {
        return this.west(n);
    }

    @Override
    public /* synthetic */ Vec3i west() {
        return this.west();
    }

    @Override
    public /* synthetic */ Vec3i south(int n) {
        return this.south(n);
    }

    @Override
    public /* synthetic */ Vec3i south() {
        return this.south();
    }

    @Override
    public /* synthetic */ Vec3i north(int n) {
        return this.north(n);
    }

    @Override
    public /* synthetic */ Vec3i north() {
        return this.north();
    }

    @Override
    public /* synthetic */ Vec3i below(int n) {
        return this.below(n);
    }

    @Override
    public /* synthetic */ Vec3i below() {
        return this.below();
    }

    @Override
    public /* synthetic */ Vec3i above(int n) {
        return this.above(n);
    }

    @Override
    public /* synthetic */ Vec3i above() {
        return this.above();
    }

    @Override
    public /* synthetic */ Vec3i multiply(int n) {
        return this.multiply(n);
    }

    @Override
    public /* synthetic */ Vec3i subtract(Vec3i vec3i) {
        return this.subtract(vec3i);
    }

    @Override
    public /* synthetic */ Vec3i offset(Vec3i vec3i) {
        return this.offset(vec3i);
    }

    @Override
    public /* synthetic */ Vec3i offset(int n, int n2, int n3) {
        return this.offset(n, n2, n3);
    }

    public static class MutableBlockPos
    extends BlockPos {
        public MutableBlockPos() {
            this(0, 0, 0);
        }

        public MutableBlockPos(int p_122130_, int p_122131_, int p_122132_) {
            super(p_122130_, p_122131_, p_122132_);
        }

        public MutableBlockPos(double p_122126_, double p_122127_, double p_122128_) {
            this(Mth.floor(p_122126_), Mth.floor(p_122127_), Mth.floor(p_122128_));
        }

        @Override
        public BlockPos offset(int p_122163_, int p_122164_, int p_122165_) {
            return super.offset(p_122163_, p_122164_, p_122165_).immutable();
        }

        @Override
        public BlockPos multiply(int p_175305_) {
            return super.multiply(p_175305_).immutable();
        }

        @Override
        public BlockPos relative(Direction p_122152_, int p_122153_) {
            return super.relative(p_122152_, p_122153_).immutable();
        }

        @Override
        public BlockPos relative(Direction.Axis p_122145_, int p_122146_) {
            return super.relative(p_122145_, p_122146_).immutable();
        }

        @Override
        public BlockPos rotate(Rotation p_122138_) {
            return super.rotate(p_122138_).immutable();
        }

        public MutableBlockPos set(int p_122179_, int p_122180_, int p_122181_) {
            this.setX(p_122179_);
            this.setY(p_122180_);
            this.setZ(p_122181_);
            return this;
        }

        public MutableBlockPos set(double p_122170_, double p_122171_, double p_122172_) {
            return this.set(Mth.floor(p_122170_), Mth.floor(p_122171_), Mth.floor(p_122172_));
        }

        public MutableBlockPos set(Vec3i p_122191_) {
            return this.set(p_122191_.getX(), p_122191_.getY(), p_122191_.getZ());
        }

        public MutableBlockPos set(long p_122189_) {
            return this.set(MutableBlockPos.getX(p_122189_), MutableBlockPos.getY(p_122189_), MutableBlockPos.getZ(p_122189_));
        }

        public MutableBlockPos set(AxisCycle p_122140_, int p_122141_, int p_122142_, int p_122143_) {
            return this.set(p_122140_.cycle(p_122141_, p_122142_, p_122143_, Direction.Axis.X), p_122140_.cycle(p_122141_, p_122142_, p_122143_, Direction.Axis.Y), p_122140_.cycle(p_122141_, p_122142_, p_122143_, Direction.Axis.Z));
        }

        public MutableBlockPos setWithOffset(Vec3i p_122160_, Direction p_122161_) {
            return this.set(p_122160_.getX() + p_122161_.getStepX(), p_122160_.getY() + p_122161_.getStepY(), p_122160_.getZ() + p_122161_.getStepZ());
        }

        public MutableBlockPos setWithOffset(Vec3i p_122155_, int p_122156_, int p_122157_, int p_122158_) {
            return this.set(p_122155_.getX() + p_122156_, p_122155_.getY() + p_122157_, p_122155_.getZ() + p_122158_);
        }

        public MutableBlockPos setWithOffset(Vec3i p_175307_, Vec3i p_175308_) {
            return this.set(p_175307_.getX() + p_175308_.getX(), p_175307_.getY() + p_175308_.getY(), p_175307_.getZ() + p_175308_.getZ());
        }

        public MutableBlockPos move(Direction p_122174_) {
            return this.move(p_122174_, 1);
        }

        public MutableBlockPos move(Direction p_122176_, int p_122177_) {
            return this.set(this.getX() + p_122176_.getStepX() * p_122177_, this.getY() + p_122176_.getStepY() * p_122177_, this.getZ() + p_122176_.getStepZ() * p_122177_);
        }

        public MutableBlockPos move(int p_122185_, int p_122186_, int p_122187_) {
            return this.set(this.getX() + p_122185_, this.getY() + p_122186_, this.getZ() + p_122187_);
        }

        public MutableBlockPos move(Vec3i p_122194_) {
            return this.set(this.getX() + p_122194_.getX(), this.getY() + p_122194_.getY(), this.getZ() + p_122194_.getZ());
        }

        public MutableBlockPos clamp(Direction.Axis p_122148_, int p_122149_, int p_122150_) {
            switch (p_122148_) {
                case X: {
                    return this.set(Mth.clamp(this.getX(), p_122149_, p_122150_), this.getY(), this.getZ());
                }
                case Y: {
                    return this.set(this.getX(), Mth.clamp(this.getY(), p_122149_, p_122150_), this.getZ());
                }
                case Z: {
                    return this.set(this.getX(), this.getY(), Mth.clamp(this.getZ(), p_122149_, p_122150_));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + String.valueOf(p_122148_));
        }

        @Override
        public MutableBlockPos setX(int p_175341_) {
            super.setX(p_175341_);
            return this;
        }

        @Override
        public MutableBlockPos setY(int p_175343_) {
            super.setY(p_175343_);
            return this;
        }

        @Override
        public MutableBlockPos setZ(int p_175345_) {
            super.setZ(p_175345_);
            return this;
        }

        @Override
        public BlockPos immutable() {
            return new BlockPos(this);
        }

        @Override
        public /* synthetic */ Vec3i cross(Vec3i vec3i) {
            return super.cross(vec3i);
        }

        @Override
        public /* synthetic */ Vec3i relative(Direction.Axis axis, int n) {
            return this.relative(axis, n);
        }

        @Override
        public /* synthetic */ Vec3i relative(Direction direction, int n) {
            return this.relative(direction, n);
        }

        @Override
        public /* synthetic */ Vec3i relative(Direction direction) {
            return super.relative(direction);
        }

        @Override
        public /* synthetic */ Vec3i east(int n) {
            return super.east(n);
        }

        @Override
        public /* synthetic */ Vec3i east() {
            return super.east();
        }

        @Override
        public /* synthetic */ Vec3i west(int n) {
            return super.west(n);
        }

        @Override
        public /* synthetic */ Vec3i west() {
            return super.west();
        }

        @Override
        public /* synthetic */ Vec3i south(int n) {
            return super.south(n);
        }

        @Override
        public /* synthetic */ Vec3i south() {
            return super.south();
        }

        @Override
        public /* synthetic */ Vec3i north(int n) {
            return super.north(n);
        }

        @Override
        public /* synthetic */ Vec3i north() {
            return super.north();
        }

        @Override
        public /* synthetic */ Vec3i below(int n) {
            return super.below(n);
        }

        @Override
        public /* synthetic */ Vec3i below() {
            return super.below();
        }

        @Override
        public /* synthetic */ Vec3i above(int n) {
            return super.above(n);
        }

        @Override
        public /* synthetic */ Vec3i above() {
            return super.above();
        }

        @Override
        public /* synthetic */ Vec3i multiply(int n) {
            return this.multiply(n);
        }

        @Override
        public /* synthetic */ Vec3i subtract(Vec3i vec3i) {
            return super.subtract(vec3i);
        }

        @Override
        public /* synthetic */ Vec3i offset(Vec3i vec3i) {
            return super.offset(vec3i);
        }

        @Override
        public /* synthetic */ Vec3i offset(int n, int n2, int n3) {
            return this.offset(n, n2, n3);
        }

        @Override
        public /* synthetic */ Vec3i setZ(int n) {
            return this.setZ(n);
        }

        @Override
        public /* synthetic */ Vec3i setY(int n) {
            return this.setY(n);
        }

        @Override
        public /* synthetic */ Vec3i setX(int n) {
            return this.setX(n);
        }
    }

    public static enum TraversalNodeStatus {
        ACCEPT,
        SKIP,
        STOP;

    }
}

