/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.commands.PermissionCheck;
import org.slf4j.Logger;

public class ArgumentUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final byte NUMBER_FLAG_MIN = 1;
    private static final byte NUMBER_FLAG_MAX = 2;

    public static int createNumberFlags(boolean p_235428_, boolean p_235429_) {
        int $$2 = 0;
        if (p_235428_) {
            $$2 |= 1;
        }
        if (p_235429_) {
            $$2 |= 2;
        }
        return $$2;
    }

    public static boolean numberHasMin(byte p_235403_) {
        return (p_235403_ & 1) != 0;
    }

    public static boolean numberHasMax(byte p_235431_) {
        return (p_235431_ & 2) != 0;
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeArgumentCap(JsonObject p_235411_, ArgumentTypeInfo<A, T> p_235412_, ArgumentTypeInfo.Template<A> p_235413_) {
        p_235412_.serializeToJson(p_235413_, p_235411_);
    }

    private static <T extends ArgumentType<?>> void serializeArgumentToJson(JsonObject p_235405_, T p_235406_) {
        ArgumentTypeInfo.Template<T> $$2 = ArgumentTypeInfos.unpack(p_235406_);
        p_235405_.addProperty("type", "argument");
        p_235405_.addProperty("parser", String.valueOf(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getKey($$2.type())));
        JsonObject $$3 = new JsonObject();
        ArgumentUtils.serializeArgumentCap($$3, $$2.type(), $$2);
        if (!$$3.isEmpty()) {
            p_235405_.add("properties", (JsonElement)$$3);
        }
    }

    public static <S> JsonObject serializeNodeToJson(CommandDispatcher<S> p_235415_, CommandNode<S> p_235416_) {
        Collection $$10;
        Object $$3;
        JsonObject $$2 = new JsonObject();
        CommandNode<S> commandNode = p_235416_;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, LiteralCommandNode.class, ArgumentCommandNode.class}, commandNode2, n)) {
            case 0: {
                $$3 = (RootCommandNode)commandNode2;
                $$2.addProperty("type", "root");
                break;
            }
            case 1: {
                LiteralCommandNode $$4 = (LiteralCommandNode)commandNode2;
                $$2.addProperty("type", "literal");
                break;
            }
            case 2: {
                ArgumentCommandNode $$5 = (ArgumentCommandNode)commandNode2;
                ArgumentUtils.serializeArgumentToJson($$2, $$5.getType());
                break;
            }
            default: {
                LOGGER.error("Could not serialize node {} ({})!", p_235416_, p_235416_.getClass());
                $$2.addProperty("type", "unknown");
            }
        }
        Collection $$6 = p_235416_.getChildren();
        if (!$$6.isEmpty()) {
            JsonObject $$7 = new JsonObject();
            $$3 = $$6.iterator();
            while ($$3.hasNext()) {
                CommandNode $$8 = (CommandNode)$$3.next();
                $$7.add($$8.getName(), (JsonElement)ArgumentUtils.serializeNodeToJson(p_235415_, $$8));
            }
            $$2.add("children", (JsonElement)$$7);
        }
        if (p_235416_.getCommand() != null) {
            $$2.addProperty("executable", Boolean.valueOf(true));
        }
        if (($$3 = p_235416_.getRequirement()) instanceof PermissionCheck) {
            PermissionCheck $$9 = (PermissionCheck)$$3;
            $$2.addProperty("required_level", (Number)$$9.requiredLevel());
        }
        if (p_235416_.getRedirect() != null && !($$10 = p_235415_.getPath(p_235416_.getRedirect())).isEmpty()) {
            JsonArray $$11 = new JsonArray();
            for (String $$12 : $$10) {
                $$11.add($$12);
            }
            $$2.add("redirect", (JsonElement)$$11);
        }
        return $$2;
    }

    public static <T> Set<ArgumentType<?>> findUsedArgumentTypes(CommandNode<T> p_235418_) {
        ReferenceOpenHashSet $$1 = new ReferenceOpenHashSet();
        HashSet $$2 = new HashSet();
        ArgumentUtils.findUsedArgumentTypes(p_235418_, $$2, $$1);
        return $$2;
    }

    private static <T> void findUsedArgumentTypes(CommandNode<T> p_235420_, Set<ArgumentType<?>> p_235421_, Set<CommandNode<T>> p_235422_) {
        if (!p_235422_.add(p_235420_)) {
            return;
        }
        if (p_235420_ instanceof ArgumentCommandNode) {
            ArgumentCommandNode $$3 = (ArgumentCommandNode)p_235420_;
            p_235421_.add($$3.getType());
        }
        p_235420_.getChildren().forEach(p_235426_ -> ArgumentUtils.findUsedArgumentTypes(p_235426_, p_235421_, p_235422_));
        CommandNode $$4 = p_235420_.getRedirect();
        if ($$4 != null) {
            ArgumentUtils.findUsedArgumentTypes($$4, p_235421_, p_235422_);
        }
    }
}

