/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtGrammar;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> EXAMPLES = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType ERROR_FAILED_TO_PARSE = new DynamicCommandExceptionType(p_335811_ -> Component.translatableEscape("argument.resource_or_id.failed_to_parse", p_335811_));
    public static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ELEMENT = new Dynamic2CommandExceptionType((p_421294_, p_421295_) -> Component.translatableEscape("argument.resource_or_id.no_such_element", p_421294_, p_421295_));
    public static final DynamicOps<Tag> OPS = NbtOps.INSTANCE;
    private final HolderLookup.Provider registryLookup;
    private final Optional<? extends HolderLookup.RegistryLookup<T>> elementLookup;
    private final Codec<T> codec;
    private final Grammar<Result<T, Tag>> grammar;
    private final ResourceKey<? extends Registry<T>> registryKey;

    protected ResourceOrIdArgument(CommandBuildContext p_335864_, ResourceKey<? extends Registry<T>> p_335475_, Codec<T> p_335632_) {
        this.registryLookup = p_335864_;
        this.elementLookup = p_335864_.lookup(p_335475_);
        this.registryKey = p_335475_;
        this.codec = p_335632_;
        this.grammar = ResourceOrIdArgument.createGrammar(p_335475_, OPS);
    }

    public static <T, O> Grammar<Result<T, O>> createGrammar(ResourceKey<? extends Registry<T>> p_422103_, DynamicOps<O> p_421543_) {
        Grammar<O> $$2 = SnbtGrammar.createParser(p_421543_);
        Dictionary<StringReader> $$3 = new Dictionary<StringReader>();
        Atom $$4 = Atom.of("result");
        Atom $$5 = Atom.of("id");
        Atom $$6 = Atom.of("value");
        $$3.put($$5, ResourceLocationParseRule.INSTANCE);
        $$3.put($$6, $$2.top().value());
        NamedRule $$7 = $$3.put($$4, Term.alternative($$3.named($$5), $$3.named($$6)), p_421293_ -> {
            ResourceLocation $$4 = (ResourceLocation)p_421293_.get($$5);
            if ($$4 != null) {
                return new ReferenceResult(ResourceKey.create(p_422103_, $$4));
            }
            Object $$5 = p_421293_.getOrThrow($$6);
            return new InlineResult($$5);
        });
        return new Grammar<Result<T, O>>($$3, $$7);
    }

    public static LootTableArgument lootTable(CommandBuildContext p_335938_) {
        return new LootTableArgument(p_335938_);
    }

    public static Holder<LootTable> getLootTable(CommandContext<CommandSourceStack> p_335373_, String p_336017_) throws CommandSyntaxException {
        return ResourceOrIdArgument.getResource(p_335373_, p_336017_);
    }

    public static LootModifierArgument lootModifier(CommandBuildContext p_335731_) {
        return new LootModifierArgument(p_335731_);
    }

    public static Holder<LootItemFunction> getLootModifier(CommandContext<CommandSourceStack> p_335678_, String p_336178_) {
        return ResourceOrIdArgument.getResource(p_335678_, p_336178_);
    }

    public static LootPredicateArgument lootPredicate(CommandBuildContext p_335891_) {
        return new LootPredicateArgument(p_335891_);
    }

    public static Holder<LootItemCondition> getLootPredicate(CommandContext<CommandSourceStack> p_336183_, String p_336098_) {
        return ResourceOrIdArgument.getResource(p_336183_, p_336098_);
    }

    public static DialogArgument dialog(CommandBuildContext p_425646_) {
        return new DialogArgument(p_425646_);
    }

    public static Holder<Dialog> getDialog(CommandContext<CommandSourceStack> p_426065_, String p_426142_) {
        return ResourceOrIdArgument.getResource(p_426065_, p_426142_);
    }

    private static <T> Holder<T> getResource(CommandContext<CommandSourceStack> p_336122_, String p_335417_) {
        return (Holder)p_336122_.getArgument(p_335417_, Holder.class);
    }

    @Nullable
    public Holder<T> parse(StringReader p_335906_) throws CommandSyntaxException {
        return this.parse(p_335906_, this.grammar, OPS);
    }

    @Nullable
    private <O> Holder<T> parse(StringReader p_412491_, Grammar<Result<T, O>> p_421894_, DynamicOps<O> p_421523_) throws CommandSyntaxException {
        Result<T, O> $$3 = p_421894_.parseForCommands(p_412491_);
        if (this.elementLookup.isEmpty()) {
            return null;
        }
        return $$3.parse((ImmutableStringReader)p_412491_, this.registryLookup, p_421523_, this.codec, this.elementLookup.get());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_425917_, SuggestionsBuilder p_425995_) {
        return SharedSuggestionProvider.listSuggestions(p_425917_, p_425995_, this.registryKey, SharedSuggestionProvider.ElementSuggestionType.ELEMENTS);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Nullable
    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class LootTableArgument
    extends ResourceOrIdArgument<LootTable> {
        protected LootTableArgument(CommandBuildContext p_335769_) {
            super(p_335769_, Registries.LOOT_TABLE, LootTable.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class LootModifierArgument
    extends ResourceOrIdArgument<LootItemFunction> {
        protected LootModifierArgument(CommandBuildContext p_335547_) {
            super(p_335547_, Registries.ITEM_MODIFIER, LootItemFunctions.ROOT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class LootPredicateArgument
    extends ResourceOrIdArgument<LootItemCondition> {
        protected LootPredicateArgument(CommandBuildContext p_336020_) {
            super(p_336020_, Registries.PREDICATE, LootItemCondition.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class DialogArgument
    extends ResourceOrIdArgument<Dialog> {
        protected DialogArgument(CommandBuildContext p_426177_) {
            super(p_426177_, Registries.DIALOG, Dialog.DIRECT_CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static sealed interface Result<T, O>
    permits InlineResult, ReferenceResult {
        public Holder<T> parse(ImmutableStringReader var1, HolderLookup.Provider var2, DynamicOps<O> var3, Codec<T> var4, HolderLookup.RegistryLookup<T> var5) throws CommandSyntaxException;
    }

    public record ReferenceResult<T, O>(ResourceKey<T> key) implements Result<T, O>
    {
        @Override
        public Holder<T> parse(ImmutableStringReader p_422449_, HolderLookup.Provider p_422045_, DynamicOps<O> p_421653_, Codec<T> p_422608_, HolderLookup.RegistryLookup<T> p_421710_) throws CommandSyntaxException {
            return p_421710_.get(this.key).orElseThrow(() -> ERROR_NO_SUCH_ELEMENT.createWithContext(p_422449_, (Object)this.key.location(), (Object)this.key.registry()));
        }
    }

    public record InlineResult<T, O>(O value) implements Result<T, O>
    {
        @Override
        public Holder<T> parse(ImmutableStringReader p_421858_, HolderLookup.Provider p_422417_, DynamicOps<O> p_421627_, Codec<T> p_422188_, HolderLookup.RegistryLookup<T> p_421743_) throws CommandSyntaxException {
            return Holder.direct(p_422188_.parse(p_422417_.createSerializationContext(p_421627_), this.value).getOrThrow(p_421517_ -> ERROR_FAILED_TO_PARSE.createWithContext(p_421858_, p_421517_)));
        }
    }
}

