/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.waypoints;

import com.mojang.datafixers.util.Either;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.waypoints.TrackedWaypoint;
import net.minecraft.world.waypoints.TrackedWaypointManager;
import net.minecraft.world.waypoints.Waypoint;

public class ClientWaypointManager
implements TrackedWaypointManager {
    private final Map<Either<UUID, String>, TrackedWaypoint> waypoints = new ConcurrentHashMap<Either<UUID, String>, TrackedWaypoint>();

    @Override
    public void trackWaypoint(TrackedWaypoint p_416480_) {
        this.waypoints.put(p_416480_.id(), p_416480_);
    }

    @Override
    public void updateWaypoint(TrackedWaypoint p_416549_) {
        this.waypoints.get(p_416549_.id()).update(p_416549_);
    }

    @Override
    public void untrackWaypoint(TrackedWaypoint p_416593_) {
        this.waypoints.remove(p_416593_.id());
    }

    public boolean hasWaypoints() {
        return !this.waypoints.isEmpty();
    }

    public void forEachWaypoint(Entity p_416430_, Consumer<TrackedWaypoint> p_416709_) {
        this.waypoints.values().stream().sorted(Comparator.comparingDouble(p_415538_ -> p_415538_.distanceSquared(p_416430_)).reversed()).forEachOrdered(p_416709_);
    }

    @Override
    public /* synthetic */ void untrackWaypoint(Waypoint waypoint) {
        this.untrackWaypoint((TrackedWaypoint)waypoint);
    }

    @Override
    public /* synthetic */ void trackWaypoint(Waypoint waypoint) {
        this.trackWaypoint((TrackedWaypoint)waypoint);
    }
}

