/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.world.item.ItemDisplayContext;

public interface ResolvedModel
extends ModelDebugName {
    public static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    public static final UnbakedModel.GuiLight DEFAULT_GUI_LIGHT = UnbakedModel.GuiLight.SIDE;

    public UnbakedModel wrapped();

    @Nullable
    public ResolvedModel parent();

    public static TextureSlots findTopTextureSlots(ResolvedModel p_405472_) {
        TextureSlots.Resolver $$2 = new TextureSlots.Resolver();
        for (ResolvedModel $$1 = p_405472_; $$1 != null; $$1 = $$1.parent()) {
            $$2.addLast($$1.wrapped().textureSlots());
        }
        return $$2.resolve(p_405472_);
    }

    default public TextureSlots getTopTextureSlots() {
        return ResolvedModel.findTopTextureSlots(this);
    }

    public static boolean findTopAmbientOcclusion(ResolvedModel p_404692_) {
        while (p_404692_ != null) {
            Boolean $$1 = p_404692_.wrapped().ambientOcclusion();
            if ($$1 != null) {
                return $$1;
            }
            p_404692_ = p_404692_.parent();
        }
        return true;
    }

    default public boolean getTopAmbientOcclusion() {
        return ResolvedModel.findTopAmbientOcclusion(this);
    }

    public static UnbakedModel.GuiLight findTopGuiLight(ResolvedModel p_405791_) {
        while (p_405791_ != null) {
            UnbakedModel.GuiLight $$1 = p_405791_.wrapped().guiLight();
            if ($$1 != null) {
                return $$1;
            }
            p_405791_ = p_405791_.parent();
        }
        return DEFAULT_GUI_LIGHT;
    }

    default public UnbakedModel.GuiLight getTopGuiLight() {
        return ResolvedModel.findTopGuiLight(this);
    }

    public static UnbakedGeometry findTopGeometry(ResolvedModel p_405270_) {
        while (p_405270_ != null) {
            UnbakedGeometry $$1 = p_405270_.wrapped().geometry();
            if ($$1 != null) {
                return $$1;
            }
            p_405270_ = p_405270_.parent();
        }
        return UnbakedGeometry.EMPTY;
    }

    default public UnbakedGeometry getTopGeometry() {
        return ResolvedModel.findTopGeometry(this);
    }

    default public QuadCollection bakeTopGeometry(TextureSlots p_405784_, ModelBaker p_405450_, ModelState p_405844_) {
        return this.getTopGeometry().bake(p_405784_, p_405450_, p_405844_, this);
    }

    public static TextureAtlasSprite resolveParticleSprite(TextureSlots p_404698_, ModelBaker p_405533_, ModelDebugName p_405824_) {
        return p_405533_.sprites().resolveSlot(p_404698_, "particle", p_405824_);
    }

    default public TextureAtlasSprite resolveParticleSprite(TextureSlots p_405126_, ModelBaker p_404926_) {
        return ResolvedModel.resolveParticleSprite(p_405126_, p_404926_, this);
    }

    public static ItemTransform findTopTransform(ResolvedModel p_404657_, ItemDisplayContext p_405330_) {
        while (p_404657_ != null) {
            ItemTransform $$3;
            ItemTransforms $$2 = p_404657_.wrapped().transforms();
            if ($$2 != null && ($$3 = $$2.getTransform(p_405330_)) != ItemTransform.NO_TRANSFORM) {
                return $$3;
            }
            p_404657_ = p_404657_.parent();
        }
        return ItemTransform.NO_TRANSFORM;
    }

    public static ItemTransforms findTopTransforms(ResolvedModel p_404681_) {
        ItemTransform $$1 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform $$2 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform $$3 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform $$4 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform $$5 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.HEAD);
        ItemTransform $$6 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.GUI);
        ItemTransform $$7 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.GROUND);
        ItemTransform $$8 = ResolvedModel.findTopTransform(p_404681_, ItemDisplayContext.FIXED);
        return new ItemTransforms($$1, $$2, $$3, $$4, $$5, $$6, $$7, $$8);
    }

    default public ItemTransforms getTopTransforms() {
        return ResolvedModel.findTopTransforms(this);
    }
}

