/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public class QuadCollection {
    public static final QuadCollection EMPTY = new QuadCollection(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
    private final List<BakedQuad> all;
    private final List<BakedQuad> unculled;
    private final List<BakedQuad> north;
    private final List<BakedQuad> south;
    private final List<BakedQuad> east;
    private final List<BakedQuad> west;
    private final List<BakedQuad> up;
    private final List<BakedQuad> down;

    QuadCollection(List<BakedQuad> p_405148_, List<BakedQuad> p_404733_, List<BakedQuad> p_405535_, List<BakedQuad> p_404824_, List<BakedQuad> p_405136_, List<BakedQuad> p_404979_, List<BakedQuad> p_404989_, List<BakedQuad> p_405866_) {
        this.all = p_405148_;
        this.unculled = p_404733_;
        this.north = p_405535_;
        this.south = p_404824_;
        this.east = p_405136_;
        this.west = p_404979_;
        this.up = p_404989_;
        this.down = p_405866_;
    }

    public List<BakedQuad> getQuads(@Nullable Direction p_405514_) {
        Direction direction = p_405514_;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "SOUTH", "EAST", "WEST", "UP", "DOWN"}, (Direction)direction, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> this.unculled;
            case 0 -> this.north;
            case 1 -> this.south;
            case 2 -> this.east;
            case 3 -> this.west;
            case 4 -> this.up;
            case 5 -> this.down;
        };
    }

    public List<BakedQuad> getAll() {
        return this.all;
    }

    public static class Builder {
        private final ImmutableList.Builder<BakedQuad> unculledFaces = ImmutableList.builder();
        private final Multimap<Direction, BakedQuad> culledFaces = ArrayListMultimap.create();

        public Builder addCulledFace(Direction p_405416_, BakedQuad p_405678_) {
            this.culledFaces.put((Object)p_405416_, (Object)p_405678_);
            return this;
        }

        public Builder addUnculledFace(BakedQuad p_405329_) {
            this.unculledFaces.add((Object)p_405329_);
            return this;
        }

        private static QuadCollection createFromSublists(List<BakedQuad> p_405742_, int p_405661_, int p_405665_, int p_405121_, int p_405725_, int p_404700_, int p_405215_, int p_404662_) {
            int $$8 = 0;
            List<BakedQuad> $$9 = p_405742_.subList($$8, $$8 += p_405661_);
            List<BakedQuad> $$10 = p_405742_.subList($$8, $$8 += p_405665_);
            List<BakedQuad> $$11 = p_405742_.subList($$8, $$8 += p_405121_);
            List<BakedQuad> $$12 = p_405742_.subList($$8, $$8 += p_405725_);
            List<BakedQuad> $$13 = p_405742_.subList($$8, $$8 += p_404700_);
            List<BakedQuad> $$14 = p_405742_.subList($$8, $$8 += p_405215_);
            List<BakedQuad> $$15 = p_405742_.subList($$8, $$8 + p_404662_);
            return new QuadCollection(p_405742_, $$9, $$10, $$11, $$12, $$13, $$14, $$15);
        }

        public QuadCollection build() {
            ImmutableList $$0 = this.unculledFaces.build();
            if (this.culledFaces.isEmpty()) {
                if ($$0.isEmpty()) {
                    return EMPTY;
                }
                return new QuadCollection((List<BakedQuad>)$$0, (List<BakedQuad>)$$0, List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
            }
            ImmutableList.Builder $$1 = ImmutableList.builder();
            $$1.addAll((Iterable)$$0);
            Collection $$2 = this.culledFaces.get((Object)Direction.NORTH);
            $$1.addAll((Iterable)$$2);
            Collection $$3 = this.culledFaces.get((Object)Direction.SOUTH);
            $$1.addAll((Iterable)$$3);
            Collection $$4 = this.culledFaces.get((Object)Direction.EAST);
            $$1.addAll((Iterable)$$4);
            Collection $$5 = this.culledFaces.get((Object)Direction.WEST);
            $$1.addAll((Iterable)$$5);
            Collection $$6 = this.culledFaces.get((Object)Direction.UP);
            $$1.addAll((Iterable)$$6);
            Collection $$7 = this.culledFaces.get((Object)Direction.DOWN);
            $$1.addAll((Iterable)$$7);
            return Builder.createFromSublists((List<BakedQuad>)$$1.build(), $$0.size(), $$2.size(), $$3.size(), $$4.size(), $$5.size(), $$6.size(), $$7.size());
        }
    }
}

