/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SpecialBlockModelRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.AtlasIds;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ClientItemInfoLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelDiscovery;
import net.minecraft.client.resources.model.ModelGroupCollector;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;

public class ModelManager
implements PreparableReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json("models");
    private static final Map<ResourceLocation, ResourceLocation> VANILLA_ATLASES = Map.of(Sheets.BANNER_SHEET, AtlasIds.BANNER_PATTERNS, Sheets.BED_SHEET, AtlasIds.BEDS, Sheets.CHEST_SHEET, AtlasIds.CHESTS, Sheets.SHIELD_SHEET, AtlasIds.SHIELD_PATTERNS, Sheets.SIGN_SHEET, AtlasIds.SIGNS, Sheets.SHULKER_SHEET, AtlasIds.SHULKER_BOXES, Sheets.ARMOR_TRIMS_SHEET, AtlasIds.ARMOR_TRIMS, Sheets.DECORATED_POT_SHEET, AtlasIds.DECORATED_POT, TextureAtlas.LOCATION_BLOCKS, AtlasIds.BLOCKS);
    private Map<ResourceLocation, ItemModel> bakedItemStackModels = Map.of();
    private Map<ResourceLocation, ClientItem.Properties> itemProperties = Map.of();
    private final AtlasSet atlases;
    private final BlockModelShaper blockModelShaper;
    private final BlockColors blockColors;
    private EntityModelSet entityModelSet = EntityModelSet.EMPTY;
    private SpecialBlockModelRenderer specialBlockModelRenderer = SpecialBlockModelRenderer.EMPTY;
    private int maxMipmapLevels;
    private ModelBakery.MissingModels missingModels;
    private Object2IntMap<BlockState> modelGroups = Object2IntMaps.emptyMap();

    public ModelManager(TextureManager p_119406_, BlockColors p_119407_, int p_119408_) {
        this.blockColors = p_119407_;
        this.maxMipmapLevels = p_119408_;
        this.blockModelShaper = new BlockModelShaper(this);
        this.atlases = new AtlasSet(VANILLA_ATLASES, p_119406_);
    }

    public BlockStateModel getMissingBlockStateModel() {
        return this.missingModels.block();
    }

    public ItemModel getItemModel(ResourceLocation p_387691_) {
        return this.bakedItemStackModels.getOrDefault(p_387691_, this.missingModels.item());
    }

    public ClientItem.Properties getItemProperties(ResourceLocation p_390438_) {
        return this.itemProperties.getOrDefault(p_390438_, ClientItem.Properties.DEFAULT);
    }

    public BlockModelShaper getBlockModelShaper() {
        return this.blockModelShaper;
    }

    @Override
    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_249079_, ResourceManager p_251134_, Executor p_250550_, Executor p_249221_) {
        CompletableFuture<EntityModelSet> $$4 = CompletableFuture.supplyAsync(EntityModelSet::vanilla, p_250550_);
        CompletionStage $$5 = $$4.thenApplyAsync(SpecialBlockModelRenderer::vanilla, p_250550_);
        CompletableFuture<Map<ResourceLocation, UnbakedModel>> $$6 = ModelManager.loadBlockModels(p_251134_, p_250550_);
        CompletableFuture<BlockStateModelLoader.LoadedModels> $$7 = BlockStateModelLoader.loadBlockStates(p_251134_, p_250550_);
        CompletableFuture<ClientItemInfoLoader.LoadedClientInfos> $$8 = ClientItemInfoLoader.scheduleLoad(p_251134_, p_250550_);
        CompletionStage $$9 = CompletableFuture.allOf($$6, $$7, $$8).thenApplyAsync(p_404152_ -> ModelManager.discoverModelDependencies((Map)$$6.join(), (BlockStateModelLoader.LoadedModels)$$7.join(), (ClientItemInfoLoader.LoadedClientInfos)$$8.join()), p_250550_);
        CompletionStage $$10 = $$7.thenApplyAsync(p_359309_ -> ModelManager.buildModelGroups(this.blockColors, p_359309_), p_250550_);
        Map<ResourceLocation, CompletableFuture<AtlasSet.StitchResult>> $$11 = this.atlases.scheduleLoad(p_251134_, this.maxMipmapLevels, p_250550_);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.concat($$11.values().stream(), Stream.of($$9, $$10, $$7, $$8, $$4, $$5, $$6)).toArray(CompletableFuture[]::new)).thenComposeAsync(arg_0 -> ModelManager.lambda$reload$4($$11, (CompletableFuture)$$9, (CompletableFuture)$$10, $$6, $$4, $$7, $$8, (CompletableFuture)$$5, p_250550_, arg_0), p_250550_)).thenCompose(p_252255_ -> p_252255_.readyForUpload.thenApply(p_251581_ -> p_252255_))).thenCompose(p_249079_::wait)).thenAcceptAsync(p_372566_ -> this.apply((ReloadState)p_372566_, Profiler.get()), p_249221_);
    }

    private static CompletableFuture<Map<ResourceLocation, UnbakedModel>> loadBlockModels(ResourceManager p_251361_, Executor p_252189_) {
        return CompletableFuture.supplyAsync(() -> MODEL_LISTER.listMatchingResources(p_251361_), p_252189_).thenCompose(p_250597_ -> {
            ArrayList<CompletableFuture<Pair>> $$2 = new ArrayList<CompletableFuture<Pair>>(p_250597_.size());
            for (Map.Entry $$3 : p_250597_.entrySet()) {
                $$2.add(CompletableFuture.supplyAsync(() -> {
                    Pair pair;
                    block8: {
                        ResourceLocation $$1 = MODEL_LISTER.fileToId((ResourceLocation)$$3.getKey());
                        BufferedReader $$2 = ((Resource)$$3.getValue()).openAsReader();
                        try {
                            pair = Pair.of((Object)$$1, (Object)BlockModel.fromStream($$2));
                            if ($$2 == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if ($$2 != null) {
                                    try {
                                        ((Reader)$$2).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception $$3) {
                                LOGGER.error("Failed to load model {}", $$3.getKey(), (Object)$$3);
                                return null;
                            }
                        }
                        ((Reader)$$2).close();
                    }
                    return pair;
                }, p_252189_));
            }
            return Util.sequence($$2).thenApply(p_250813_ -> p_250813_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private static ResolvedModels discoverModelDependencies(Map<ResourceLocation, UnbakedModel> p_363228_, BlockStateModelLoader.LoadedModels p_361624_, ClientItemInfoLoader.LoadedClientInfos p_390496_) {
        try (Zone $$3 = Profiler.get().zone("dependencies");){
            ModelDiscovery $$4 = new ModelDiscovery(p_363228_, MissingBlockModel.missingModel());
            $$4.addSpecialModel(ItemModelGenerator.GENERATED_ITEM_MODEL_ID, new ItemModelGenerator());
            p_361624_.models().values().forEach($$4::addRoot);
            p_390496_.contents().values().forEach(p_390109_ -> $$4.addRoot(p_390109_.model()));
            ResolvedModels resolvedModels = new ResolvedModels($$4.missingModel(), $$4.resolve());
            return resolvedModels;
        }
    }

    private static CompletableFuture<ReloadState> loadModels(final Map<ResourceLocation, AtlasSet.StitchResult> p_250646_, ModelBakery p_248945_, Object2IntMap<BlockState> p_363498_, EntityModelSet p_388110_, SpecialBlockModelRenderer p_387466_, Executor p_405316_) {
        CompletableFuture<Void> $$6 = CompletableFuture.allOf((CompletableFuture[])p_250646_.values().stream().map(AtlasSet.StitchResult::readyForUpload).toArray(CompletableFuture[]::new));
        final Multimap $$7 = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        final Multimap $$8 = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        return p_248945_.bakeModels(new SpriteGetter(){
            private final TextureAtlasSprite missingSprite;
            {
                this.missingSprite = ((AtlasSet.StitchResult)p_250646_.get(TextureAtlas.LOCATION_BLOCKS)).missing();
            }

            @Override
            public TextureAtlasSprite get(Material p_388183_, ModelDebugName p_388862_) {
                AtlasSet.StitchResult $$2 = (AtlasSet.StitchResult)p_250646_.get(p_388183_.atlasLocation());
                TextureAtlasSprite $$3 = $$2.getSprite(p_388183_.texture());
                if ($$3 != null) {
                    return $$3;
                }
                $$7.put((Object)p_388862_.debugName(), (Object)p_388183_);
                return $$2.missing();
            }

            @Override
            public TextureAtlasSprite reportMissingReference(String p_387702_, ModelDebugName p_387819_) {
                $$8.put((Object)p_387819_.debugName(), (Object)p_387702_);
                return this.missingSprite;
            }
        }, p_405316_).thenApply(p_404163_ -> {
            $$7.asMap().forEach((p_387727_, p_252017_) -> LOGGER.warn("Missing textures in model {}:\n{}", p_387727_, (Object)p_252017_.stream().sorted(Material.COMPARATOR).map(p_339314_ -> "    " + String.valueOf(p_339314_.atlasLocation()) + ":" + String.valueOf(p_339314_.texture())).collect(Collectors.joining("\n"))));
            $$8.asMap().forEach((p_386266_, p_386267_) -> LOGGER.warn("Missing texture references in model {}:\n{}", p_386266_, (Object)p_386267_.stream().sorted().map(p_386265_ -> "    " + p_386265_).collect(Collectors.joining("\n"))));
            Map<BlockState, BlockStateModel> $$8 = ModelManager.createBlockStateToModelDispatch(p_404163_.blockStateModels(), p_404163_.missingModels().block());
            return new ReloadState((ModelBakery.BakingResult)p_404163_, p_363498_, $$8, p_250646_, p_388110_, p_387466_, $$6);
        });
    }

    private static Map<BlockState, BlockStateModel> createBlockStateToModelDispatch(Map<BlockState, BlockStateModel> p_386989_, BlockStateModel p_405855_) {
        try (Zone $$2 = Profiler.get().zone("block state dispatch");){
            IdentityHashMap<BlockState, BlockStateModel> $$3 = new IdentityHashMap<BlockState, BlockStateModel>(p_386989_);
            for (Block $$4 : BuiltInRegistries.BLOCK) {
                $$4.getStateDefinition().getPossibleStates().forEach(p_404155_ -> {
                    if (p_386989_.putIfAbsent((BlockState)p_404155_, p_405855_) == null) {
                        LOGGER.warn("Missing model for variant: '{}'", p_404155_);
                    }
                });
            }
            IdentityHashMap<BlockState, BlockStateModel> identityHashMap = $$3;
            return identityHashMap;
        }
    }

    private static Object2IntMap<BlockState> buildModelGroups(BlockColors p_362057_, BlockStateModelLoader.LoadedModels p_362559_) {
        try (Zone $$2 = Profiler.get().zone("block groups");){
            Object2IntMap<BlockState> object2IntMap = ModelGroupCollector.build(p_362057_, p_362559_);
            return object2IntMap;
        }
    }

    private void apply(ReloadState p_248996_, ProfilerFiller p_251960_) {
        p_251960_.push("upload");
        p_248996_.atlasPreparations.values().forEach(AtlasSet.StitchResult::upload);
        ModelBakery.BakingResult $$2 = p_248996_.bakedModels;
        this.bakedItemStackModels = $$2.itemStackModels();
        this.itemProperties = $$2.itemProperties();
        this.modelGroups = p_248996_.modelGroups;
        this.missingModels = $$2.missingModels();
        p_251960_.popPush("cache");
        this.blockModelShaper.replaceCache(p_248996_.modelCache);
        this.specialBlockModelRenderer = p_248996_.specialBlockModelRenderer;
        this.entityModelSet = p_248996_.entityModelSet;
        p_251960_.pop();
    }

    public boolean requiresRender(BlockState p_119416_, BlockState p_119417_) {
        int $$3;
        if (p_119416_ == p_119417_) {
            return false;
        }
        int $$2 = this.modelGroups.getInt((Object)p_119416_);
        if ($$2 != -1 && $$2 == ($$3 = this.modelGroups.getInt((Object)p_119417_))) {
            FluidState $$5;
            FluidState $$4 = p_119416_.getFluidState();
            return $$4 != ($$5 = p_119417_.getFluidState());
        }
        return true;
    }

    public TextureAtlas getAtlas(ResourceLocation p_119429_) {
        return this.atlases.getAtlas(p_119429_);
    }

    @Override
    public void close() {
        this.atlases.close();
    }

    public void updateMaxMipLevel(int p_119411_) {
        this.maxMipmapLevels = p_119411_;
    }

    public Supplier<SpecialBlockModelRenderer> specialBlockModelRenderer() {
        return () -> this.specialBlockModelRenderer;
    }

    public Supplier<EntityModelSet> entityModels() {
        return () -> this.entityModelSet;
    }

    private static /* synthetic */ CompletionStage lambda$reload$4(Map p_404139_, CompletableFuture p_404140_, CompletableFuture p_404141_, CompletableFuture p_404142_, CompletableFuture p_404143_, CompletableFuture p_404144_, CompletableFuture p_404145_, CompletableFuture p_404146_, Executor p_404147_, Void p_404148_) {
        Map<ResourceLocation, AtlasSet.StitchResult> $$10 = Util.mapValues(p_404139_, CompletableFuture::join);
        ResolvedModels $$11 = (ResolvedModels)p_404140_.join();
        Object2IntMap $$12 = (Object2IntMap)p_404141_.join();
        Sets.SetView $$13 = Sets.difference(((Map)p_404142_.join()).keySet(), $$11.models.keySet());
        if (!$$13.isEmpty()) {
            LOGGER.debug("Unreferenced models: \n{}", (Object)$$13.stream().sorted().map(p_386272_ -> "\t" + String.valueOf(p_386272_) + "\n").collect(Collectors.joining()));
        }
        ModelBakery $$14 = new ModelBakery((EntityModelSet)p_404143_.join(), ((BlockStateModelLoader.LoadedModels)p_404144_.join()).models(), ((ClientItemInfoLoader.LoadedClientInfos)p_404145_.join()).contents(), $$11.models(), $$11.missing());
        return ModelManager.loadModels($$10, $$14, (Object2IntMap<BlockState>)$$12, (EntityModelSet)p_404143_.join(), (SpecialBlockModelRenderer)p_404146_.join(), p_404147_);
    }

    record ResolvedModels(ResolvedModel missing, Map<ResourceLocation, ResolvedModel> models) {
    }

    record ReloadState(ModelBakery.BakingResult bakedModels, Object2IntMap<BlockState> modelGroups, Map<BlockState, BlockStateModel> modelCache, Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations, EntityModelSet entityModelSet, SpecialBlockModelRenderer specialBlockModelRenderer, CompletableFuture<Void> readyForUpload) {
    }
}

