/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ModelDiscovery {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<ResourceLocation, ModelWrapper> modelWrappers = new Object2ObjectOpenHashMap();
    private final ModelWrapper missingModel;
    private final Object2ObjectFunction<ResourceLocation, ModelWrapper> uncachedResolver;
    private final ResolvableModel.Resolver resolver;
    private final Queue<ModelWrapper> parentDiscoveryQueue = new ArrayDeque<ModelWrapper>();

    public ModelDiscovery(Map<ResourceLocation, UnbakedModel> p_360750_, UnbakedModel p_365355_) {
        this.missingModel = new ModelWrapper(MissingBlockModel.LOCATION, p_365355_, true);
        this.modelWrappers.put((Object)MissingBlockModel.LOCATION, (Object)this.missingModel);
        this.uncachedResolver = p_404130_ -> {
            ResourceLocation $$2 = (ResourceLocation)p_404130_;
            UnbakedModel $$3 = (UnbakedModel)p_360750_.get($$2);
            if ($$3 == null) {
                LOGGER.warn("Missing block model: {}", (Object)$$2);
                return this.missingModel;
            }
            return this.createAndQueueWrapper($$2, $$3);
        };
        this.resolver = this::getOrCreateModel;
    }

    private static boolean isRoot(UnbakedModel p_405616_) {
        return p_405616_.parent() == null;
    }

    private ModelWrapper getOrCreateModel(ResourceLocation p_405299_) {
        return (ModelWrapper)this.modelWrappers.computeIfAbsent((Object)p_405299_, this.uncachedResolver);
    }

    private ModelWrapper createAndQueueWrapper(ResourceLocation p_405734_, UnbakedModel p_404997_) {
        boolean $$2 = ModelDiscovery.isRoot(p_404997_);
        ModelWrapper $$3 = new ModelWrapper(p_405734_, p_404997_, $$2);
        if (!$$2) {
            this.parentDiscoveryQueue.add($$3);
        }
        return $$3;
    }

    public void addRoot(ResolvableModel p_388596_) {
        p_388596_.resolveDependencies(this.resolver);
    }

    public void addSpecialModel(ResourceLocation p_405447_, UnbakedModel p_405251_) {
        if (!ModelDiscovery.isRoot(p_405251_)) {
            LOGGER.warn("Trying to add non-root special model {}, ignoring", (Object)p_405447_);
            return;
        }
        ModelWrapper $$2 = (ModelWrapper)this.modelWrappers.put((Object)p_405447_, (Object)this.createAndQueueWrapper(p_405447_, p_405251_));
        if ($$2 != null) {
            LOGGER.warn("Duplicate special model {}", (Object)p_405447_);
        }
    }

    public ResolvedModel missingModel() {
        return this.missingModel;
    }

    public Map<ResourceLocation, ResolvedModel> resolve() {
        ArrayList<ModelWrapper> $$0 = new ArrayList<ModelWrapper>();
        this.discoverDependencies($$0);
        ModelDiscovery.propagateValidity($$0);
        ImmutableMap.Builder $$1 = ImmutableMap.builder();
        this.modelWrappers.forEach((p_404132_, p_404133_) -> {
            if (p_404133_.valid) {
                $$1.put(p_404132_, p_404133_);
            } else {
                LOGGER.warn("Model {} ignored due to cyclic dependency", p_404132_);
            }
        });
        return $$1.build();
    }

    private void discoverDependencies(List<ModelWrapper> p_405689_) {
        ModelWrapper $$1;
        while (($$1 = this.parentDiscoveryQueue.poll()) != null) {
            ModelWrapper $$3;
            ResourceLocation $$2 = Objects.requireNonNull($$1.wrapped.parent());
            $$1.parent = $$3 = this.getOrCreateModel($$2);
            if ($$3.valid) {
                $$1.valid = true;
                continue;
            }
            p_405689_.add($$1);
        }
    }

    private static void propagateValidity(List<ModelWrapper> p_405440_) {
        boolean $$1 = true;
        while ($$1) {
            $$1 = false;
            Iterator<ModelWrapper> $$2 = p_405440_.iterator();
            while ($$2.hasNext()) {
                ModelWrapper $$3 = $$2.next();
                if (!Objects.requireNonNull($$3.parent).valid) continue;
                $$3.valid = true;
                $$2.remove();
                $$1 = true;
            }
        }
    }

    static class ModelWrapper
    implements ResolvedModel {
        private static final Slot<Boolean> KEY_AMBIENT_OCCLUSION = ModelWrapper.slot(0);
        private static final Slot<UnbakedModel.GuiLight> KEY_GUI_LIGHT = ModelWrapper.slot(1);
        private static final Slot<UnbakedGeometry> KEY_GEOMETRY = ModelWrapper.slot(2);
        private static final Slot<ItemTransforms> KEY_TRANSFORMS = ModelWrapper.slot(3);
        private static final Slot<TextureSlots> KEY_TEXTURE_SLOTS = ModelWrapper.slot(4);
        private static final Slot<TextureAtlasSprite> KEY_PARTICLE_SPRITE = ModelWrapper.slot(5);
        private static final Slot<QuadCollection> KEY_DEFAULT_GEOMETRY = ModelWrapper.slot(6);
        private static final int SLOT_COUNT = 7;
        private final ResourceLocation id;
        boolean valid;
        @Nullable
        ModelWrapper parent;
        final UnbakedModel wrapped;
        private final AtomicReferenceArray<Object> fixedSlots = new AtomicReferenceArray(7);
        private final Map<ModelState, QuadCollection> modelBakeCache = new ConcurrentHashMap<ModelState, QuadCollection>();

        private static <T> Slot<T> slot(int p_405746_) {
            Objects.checkIndex(p_405746_, 7);
            return new Slot(p_405746_);
        }

        ModelWrapper(ResourceLocation p_405048_, UnbakedModel p_404712_, boolean p_404729_) {
            this.id = p_405048_;
            this.wrapped = p_404712_;
            this.valid = p_404729_;
        }

        @Override
        public UnbakedModel wrapped() {
            return this.wrapped;
        }

        @Override
        @Nullable
        public ResolvedModel parent() {
            return this.parent;
        }

        @Override
        public String debugName() {
            return this.id.toString();
        }

        @Nullable
        private <T> T getSlot(Slot<T> p_405631_) {
            return (T)this.fixedSlots.get(p_405631_.index);
        }

        private <T> T updateSlot(Slot<T> p_404819_, T p_404859_) {
            T $$2 = this.fixedSlots.compareAndExchange(p_404819_.index, null, p_404859_);
            if ($$2 == null) {
                return p_404859_;
            }
            return $$2;
        }

        private <T> T getSimpleProperty(Slot<T> p_405509_, Function<ResolvedModel, T> p_405257_) {
            T $$2 = this.getSlot(p_405509_);
            if ($$2 != null) {
                return $$2;
            }
            return this.updateSlot(p_405509_, p_405257_.apply(this));
        }

        @Override
        public boolean getTopAmbientOcclusion() {
            return this.getSimpleProperty(KEY_AMBIENT_OCCLUSION, ResolvedModel::findTopAmbientOcclusion);
        }

        @Override
        public UnbakedModel.GuiLight getTopGuiLight() {
            return this.getSimpleProperty(KEY_GUI_LIGHT, ResolvedModel::findTopGuiLight);
        }

        @Override
        public ItemTransforms getTopTransforms() {
            return this.getSimpleProperty(KEY_TRANSFORMS, ResolvedModel::findTopTransforms);
        }

        @Override
        public UnbakedGeometry getTopGeometry() {
            return this.getSimpleProperty(KEY_GEOMETRY, ResolvedModel::findTopGeometry);
        }

        @Override
        public TextureSlots getTopTextureSlots() {
            return this.getSimpleProperty(KEY_TEXTURE_SLOTS, ResolvedModel::findTopTextureSlots);
        }

        @Override
        public TextureAtlasSprite resolveParticleSprite(TextureSlots p_405019_, ModelBaker p_405134_) {
            TextureAtlasSprite $$2 = this.getSlot(KEY_PARTICLE_SPRITE);
            if ($$2 != null) {
                return $$2;
            }
            return this.updateSlot(KEY_PARTICLE_SPRITE, ResolvedModel.resolveParticleSprite(p_405019_, p_405134_, this));
        }

        private QuadCollection bakeDefaultState(TextureSlots p_405546_, ModelBaker p_404641_, ModelState p_405363_) {
            QuadCollection $$3 = this.getSlot(KEY_DEFAULT_GEOMETRY);
            if ($$3 != null) {
                return $$3;
            }
            return this.updateSlot(KEY_DEFAULT_GEOMETRY, this.getTopGeometry().bake(p_405546_, p_404641_, p_405363_, this));
        }

        @Override
        public QuadCollection bakeTopGeometry(TextureSlots p_405587_, ModelBaker p_405166_, ModelState p_405646_) {
            if (p_405646_ == BlockModelRotation.X0_Y0) {
                return this.bakeDefaultState(p_405587_, p_405166_, p_405646_);
            }
            return this.modelBakeCache.computeIfAbsent(p_405646_, p_405723_ -> {
                UnbakedGeometry $$3 = this.getTopGeometry();
                return $$3.bake(p_405587_, p_405166_, (ModelState)p_405723_, this);
            });
        }
    }

    record Slot<T>(int index) {
    }
}

