/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.MissingItemModel;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.ParallelMapTransform;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class ModelBakery {
    public static final Material FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_0"));
    public static final Material FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/fire_1"));
    public static final Material LAVA_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/lava_flow"));
    public static final Material WATER_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_flow"));
    public static final Material WATER_OVERLAY = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("block/water_overlay"));
    public static final Material BANNER_BASE = new Material(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("entity/banner_base"));
    public static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base"));
    public static final Material NO_PATTERN_SHIELD = new Material(Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("entity/shield_base_nopattern"));
    public static final int DESTROY_STAGE_COUNT = 10;
    public static final List<ResourceLocation> DESTROY_STAGES = IntStream.range(0, 10).mapToObj(p_349912_ -> ResourceLocation.withDefaultNamespace("block/destroy_stage_" + p_349912_)).collect(Collectors.toList());
    public static final List<ResourceLocation> BREAKING_LOCATIONS = DESTROY_STAGES.stream().map(p_349910_ -> p_349910_.withPath(p_349911_ -> "textures/" + p_349911_ + ".png")).collect(Collectors.toList());
    public static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(RenderType::crumbling).collect(Collectors.toList());
    static final Logger LOGGER = LogUtils.getLogger();
    private final EntityModelSet entityModelSet;
    private final Map<BlockState, BlockStateModel.UnbakedRoot> unbakedBlockStateModels;
    private final Map<ResourceLocation, ClientItem> clientInfos;
    final Map<ResourceLocation, ResolvedModel> resolvedModels;
    final ResolvedModel missingModel;

    public ModelBakery(EntityModelSet p_388903_, Map<BlockState, BlockStateModel.UnbakedRoot> p_251087_, Map<ResourceLocation, ClientItem> p_250416_, Map<ResourceLocation, ResolvedModel> p_388404_, ResolvedModel p_404940_) {
        this.entityModelSet = p_388903_;
        this.unbakedBlockStateModels = p_251087_;
        this.clientInfos = p_250416_;
        this.resolvedModels = p_388404_;
        this.missingModel = p_404940_;
    }

    public CompletableFuture<BakingResult> bakeModels(SpriteGetter p_404922_, Executor p_405407_) {
        MissingModels $$2 = MissingModels.bake(this.missingModel, p_404922_);
        ModelBakerImpl $$3 = new ModelBakerImpl(p_404922_);
        CompletableFuture<Map<BlockState, BlockStateModel>> $$4 = ParallelMapTransform.schedule(this.unbakedBlockStateModels, (p_409109_, p_409110_) -> {
            try {
                return p_409110_.bake((BlockState)p_409109_, $$3);
            }
            catch (Exception $$3) {
                LOGGER.warn("Unable to bake model: '{}': {}", p_409109_, (Object)$$3);
                return null;
            }
        }, p_405407_);
        CompletableFuture<Map<ResourceLocation, ItemModel>> $$5 = ParallelMapTransform.schedule(this.clientInfos, (p_404123_, p_404124_) -> {
            try {
                return p_404124_.model().bake(new ItemModel.BakingContext($$3, this.entityModelSet, p_404122_.item, p_404124_.registrySwapper()));
            }
            catch (Exception $$4) {
                LOGGER.warn("Unable to bake item model: '{}'", p_404123_, (Object)$$4);
                return null;
            }
        }, p_405407_);
        HashMap $$6 = new HashMap(this.clientInfos.size());
        this.clientInfos.forEach((p_404116_, p_404117_) -> {
            ClientItem.Properties $$3 = p_404117_.properties();
            if (!$$3.equals(ClientItem.Properties.DEFAULT)) {
                $$6.put(p_404116_, $$3);
            }
        });
        return $$4.thenCombine($$5, (p_404127_, p_404128_) -> new BakingResult($$2, (Map<BlockState, BlockStateModel>)p_404127_, (Map<ResourceLocation, ItemModel>)p_404128_, $$6));
    }

    public record MissingModels(BlockStateModel block, ItemModel item) {
        public static MissingModels bake(ResolvedModel p_405089_, final SpriteGetter p_405847_) {
            ModelBaker $$2 = new ModelBaker(){

                @Override
                public ResolvedModel getModel(ResourceLocation p_405277_) {
                    throw new IllegalStateException("Missing model can't have dependencies, but asked for " + String.valueOf(p_405277_));
                }

                @Override
                public <T> T compute(ModelBaker.SharedOperationKey<T> p_410289_) {
                    return p_410289_.compute(this);
                }

                @Override
                public SpriteGetter sprites() {
                    return p_405847_;
                }
            };
            TextureSlots $$3 = p_405089_.getTopTextureSlots();
            boolean $$4 = p_405089_.getTopAmbientOcclusion();
            boolean $$5 = p_405089_.getTopGuiLight().lightLikeBlock();
            ItemTransforms $$6 = p_405089_.getTopTransforms();
            QuadCollection $$7 = p_405089_.bakeTopGeometry($$3, $$2, BlockModelRotation.X0_Y0);
            TextureAtlasSprite $$8 = p_405089_.resolveParticleSprite($$3, $$2);
            SingleVariant $$9 = new SingleVariant(new SimpleModelWrapper($$7, $$4, $$8));
            MissingItemModel $$10 = new MissingItemModel($$7.getAll(), new ModelRenderProperties($$5, $$8, $$6));
            return new MissingModels($$9, $$10);
        }
    }

    class ModelBakerImpl
    implements ModelBaker {
        private final SpriteGetter sprites;
        private final Map<ModelBaker.SharedOperationKey<Object>, Object> operationCache = new ConcurrentHashMap<ModelBaker.SharedOperationKey<Object>, Object>();
        private final Function<ModelBaker.SharedOperationKey<Object>, Object> cacheComputeFunction = p_410129_ -> p_410129_.compute(this);

        ModelBakerImpl(SpriteGetter p_405481_) {
            this.sprites = p_405481_;
        }

        @Override
        public SpriteGetter sprites() {
            return this.sprites;
        }

        @Override
        public ResolvedModel getModel(ResourceLocation p_248568_) {
            ResolvedModel $$1 = ModelBakery.this.resolvedModels.get(p_248568_);
            if ($$1 == null) {
                LOGGER.warn("Requested a model that was not discovered previously: {}", (Object)p_248568_);
                return ModelBakery.this.missingModel;
            }
            return $$1;
        }

        @Override
        public <T> T compute(ModelBaker.SharedOperationKey<T> p_409780_) {
            return (T)this.operationCache.computeIfAbsent(p_409780_, this.cacheComputeFunction);
        }
    }

    public record BakingResult(MissingModels missingModels, Map<BlockState, BlockStateModel> blockStateModels, Map<ResourceLocation, ItemModel> itemStackModels, Map<ResourceLocation, ClientItem.Properties> itemProperties) {
    }
}

