/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.resources.model.BlockStateDefinitions;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.slf4j.Logger;

public class BlockStateModelLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter BLOCKSTATE_LISTER = FileToIdConverter.json("blockstates");

    public static CompletableFuture<LoadedModels> loadBlockStates(ResourceManager p_387674_, Executor p_388736_) {
        Function<ResourceLocation, StateDefinition<Block, BlockState>> $$2 = BlockStateDefinitions.definitionLocationToBlockStateMapper();
        return CompletableFuture.supplyAsync(() -> BLOCKSTATE_LISTER.listMatchingResourceStacks(p_387674_), p_388736_).thenCompose(p_404112_ -> {
            ArrayList<CompletableFuture<LoadedModels>> $$3 = new ArrayList<CompletableFuture<LoadedModels>>(p_404112_.size());
            for (Map.Entry $$4 : p_404112_.entrySet()) {
                $$3.add(CompletableFuture.supplyAsync(() -> {
                    ResourceLocation $$2 = BLOCKSTATE_LISTER.fileToId((ResourceLocation)$$4.getKey());
                    StateDefinition $$3 = (StateDefinition)$$2.apply($$2);
                    if ($$3 == null) {
                        LOGGER.debug("Discovered unknown block state definition {}, ignoring", (Object)$$2);
                        return null;
                    }
                    List $$4 = (List)$$4.getValue();
                    ArrayList<LoadedBlockModelDefinition> $$5 = new ArrayList<LoadedBlockModelDefinition>($$4.size());
                    for (Resource $$6 : $$4) {
                        try {
                            BufferedReader $$7 = $$6.openAsReader();
                            try {
                                JsonElement $$8 = StrictJsonParser.parse($$7);
                                BlockModelDefinition $$9 = (BlockModelDefinition)BlockModelDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$8).getOrThrow(JsonParseException::new);
                                $$5.add(new LoadedBlockModelDefinition($$6.sourcePackId(), $$9));
                            }
                            finally {
                                if ($$7 == null) continue;
                                ((Reader)$$7).close();
                            }
                        }
                        catch (Exception $$10) {
                            LOGGER.error("Failed to load blockstate definition {} from pack {}", new Object[]{$$2, $$6.sourcePackId(), $$10});
                        }
                    }
                    try {
                        return BlockStateModelLoader.loadBlockStateDefinitionStack($$2, $$3, $$5);
                    }
                    catch (Exception $$11) {
                        LOGGER.error("Failed to load blockstate definition {}", (Object)$$2, (Object)$$11);
                        return null;
                    }
                }, p_388736_));
            }
            return Util.sequence($$3).thenApply(p_404105_ -> {
                IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot> $$1 = new IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot>();
                for (LoadedModels $$2 : p_404105_) {
                    if ($$2 == null) continue;
                    $$1.putAll($$2.models());
                }
                return new LoadedModels($$1);
            });
        });
    }

    private static LoadedModels loadBlockStateDefinitionStack(ResourceLocation p_362931_, StateDefinition<Block, BlockState> p_363315_, List<LoadedBlockModelDefinition> p_360590_) {
        IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot> $$3 = new IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot>();
        for (LoadedBlockModelDefinition $$4 : p_360590_) {
            $$3.putAll($$4.contents.instantiate(p_363315_, () -> String.valueOf(p_362931_) + "/" + p_404107_.source));
        }
        return new LoadedModels($$3);
    }

    record LoadedBlockModelDefinition(String source, BlockModelDefinition contents) {
    }

    public record LoadedModels(Map<BlockState, BlockStateModel.UnbakedRoot> models) {
    }
}

