/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;

public record WaypointStyle(int nearDistance, int farDistance, List<ResourceLocation> sprites, List<ResourceLocation> spriteLocations) {
    public static final int DEFAULT_NEAR_DISTANCE = 128;
    public static final int DEFAULT_FAR_DISTANCE = 332;
    private static final Codec<Integer> DISTANCE_CODEC = Codec.intRange((int)0, (int)60000000);
    public static final Codec<WaypointStyle> CODEC = RecordCodecBuilder.create(p_419703_ -> p_419703_.group((App)DISTANCE_CODEC.optionalFieldOf("near_distance", (Object)128).forGetter(WaypointStyle::nearDistance), (App)DISTANCE_CODEC.optionalFieldOf("far_distance", (Object)332).forGetter(WaypointStyle::farDistance), (App)ExtraCodecs.nonEmptyList(ResourceLocation.CODEC.listOf()).fieldOf("sprites").forGetter(WaypointStyle::sprites)).apply((Applicative)p_419703_, WaypointStyle::new)).validate(WaypointStyle::validate);

    public WaypointStyle(int p_419759_, int p_419537_, List<ResourceLocation> p_420059_) {
        this(p_419759_, p_419537_, p_420059_, p_420059_.stream().map(p_420007_ -> p_420007_.withPrefix("hud/locator_bar_dot/")).toList());
    }

    private DataResult<WaypointStyle> validate() {
        if (this.nearDistance >= this.farDistance) {
            return DataResult.error(() -> "Far distance (" + this.farDistance + ") cannot be closer or equal to near distance (" + this.nearDistance + ")");
        }
        return DataResult.success((Object)this);
    }

    public ResourceLocation sprite(float p_419860_) {
        if (p_419860_ <= (float)this.nearDistance) {
            return this.spriteLocations.getFirst();
        }
        if (p_419860_ >= (float)this.farDistance) {
            return this.spriteLocations.getLast();
        }
        int $$1 = Mth.lerpInt((p_419860_ - (float)this.nearDistance) / (float)(this.farDistance - this.nearDistance), 0, this.spriteLocations.size());
        return this.spriteLocations.get($$1);
    }
}

