/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas.sources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import org.slf4j.Logger;

public record Unstitcher(ResourceLocation resource, List<Region> regions, double xDivisor, double yDivisor) implements SpriteSource
{
    static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<Unstitcher> MAP_CODEC = RecordCodecBuilder.mapCodec(p_262047_ -> p_262047_.group((App)ResourceLocation.CODEC.fieldOf("resource").forGetter(Unstitcher::resource), (App)ExtraCodecs.nonEmptyList(Region.CODEC.listOf()).fieldOf("regions").forGetter(Unstitcher::regions), (App)Codec.DOUBLE.optionalFieldOf("divisor_x", (Object)1.0).forGetter(Unstitcher::xDivisor), (App)Codec.DOUBLE.optionalFieldOf("divisor_y", (Object)1.0).forGetter(Unstitcher::yDivisor)).apply((Applicative)p_262047_, Unstitcher::new));

    @Override
    public void run(ResourceManager p_261498_, SpriteSource.Output p_261828_) {
        ResourceLocation $$2 = TEXTURE_ID_CONVERTER.idToFile(this.resource);
        Optional<Resource> $$3 = p_261498_.getResource($$2);
        if ($$3.isPresent()) {
            LazyLoadedImage $$4 = new LazyLoadedImage($$2, $$3.get(), this.regions.size());
            for (Region $$5 : this.regions) {
                p_261828_.add($$5.sprite, new RegionInstance($$4, $$5, this.xDivisor, this.yDivisor));
            }
        } else {
            LOGGER.warn("Missing sprite: {}", (Object)$$2);
        }
    }

    public MapCodec<Unstitcher> codec() {
        return MAP_CODEC;
    }

    public record Region(ResourceLocation sprite, double x, double y, double width, double height) {
        public static final Codec<Region> CODEC = RecordCodecBuilder.create(p_261521_ -> p_261521_.group((App)ResourceLocation.CODEC.fieldOf("sprite").forGetter(Region::sprite), (App)Codec.DOUBLE.fieldOf("x").forGetter(Region::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(Region::y), (App)Codec.DOUBLE.fieldOf("width").forGetter(Region::width), (App)Codec.DOUBLE.fieldOf("height").forGetter(Region::height)).apply((Applicative)p_261521_, Region::new));
    }

    static class RegionInstance
    implements SpriteSource.SpriteSupplier {
        private final LazyLoadedImage image;
        private final Region region;
        private final double xDivisor;
        private final double yDivisor;

        RegionInstance(LazyLoadedImage p_266678_, Region p_267197_, double p_266911_, double p_266789_) {
            this.image = p_266678_;
            this.region = p_267197_;
            this.xDivisor = p_266911_;
            this.yDivisor = p_266789_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SpriteContents apply(SpriteResourceLoader p_296272_) {
            try {
                NativeImage $$1 = this.image.get();
                double $$2 = (double)$$1.getWidth() / this.xDivisor;
                double $$3 = (double)$$1.getHeight() / this.yDivisor;
                int $$4 = Mth.floor(this.region.x * $$2);
                int $$5 = Mth.floor(this.region.y * $$3);
                int $$6 = Mth.floor(this.region.width * $$2);
                int $$7 = Mth.floor(this.region.height * $$3);
                NativeImage $$8 = new NativeImage(NativeImage.Format.RGBA, $$6, $$7, false);
                $$1.copyRect($$8, $$4, $$5, 0, 0, $$6, $$7, false, false);
                SpriteContents spriteContents = new SpriteContents(this.region.sprite, new FrameSize($$6, $$7), $$8, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (Exception $$9) {
                LOGGER.error("Failed to unstitch region {}", (Object)this.region.sprite, (Object)$$9);
            }
            finally {
                this.image.release();
            }
            return MissingTextureAtlasSprite.create();
        }

        @Override
        public void discard() {
            this.image.release();
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.apply((SpriteResourceLoader)object);
        }
    }
}

