/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.gui.screens.AddRealmPopupScreen;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class TextureManager
implements PreparableReloadListener,
Tickable,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation INTENTIONAL_MISSING_TEXTURE = ResourceLocation.withDefaultNamespace("");
    private final Map<ResourceLocation, AbstractTexture> byPath = new HashMap<ResourceLocation, AbstractTexture>();
    private final Set<Tickable> tickableTextures = new HashSet<Tickable>();
    private final ResourceManager resourceManager;

    public TextureManager(ResourceManager p_118474_) {
        this.resourceManager = p_118474_;
        NativeImage $$1 = MissingTextureAtlasSprite.generateMissingImage();
        this.register(MissingTextureAtlasSprite.getLocation(), new DynamicTexture(() -> "(intentionally-)Missing Texture", $$1));
    }

    public void registerAndLoad(ResourceLocation p_389410_, ReloadableTexture p_389421_) {
        try {
            p_389421_.apply(this.loadContentsSafe(p_389410_, p_389421_));
        }
        catch (Throwable $$2) {
            CrashReport $$3 = CrashReport.forThrowable($$2, "Uploading texture");
            CrashReportCategory $$4 = $$3.addCategory("Uploaded texture");
            $$4.setDetail("Resource location", p_389421_.resourceId());
            $$4.setDetail("Texture id", p_389410_);
            throw new ReportedException($$3);
        }
        this.register(p_389410_, p_389421_);
    }

    private TextureContents loadContentsSafe(ResourceLocation p_390395_, ReloadableTexture p_390396_) {
        try {
            return TextureManager.loadContents(this.resourceManager, p_390395_, p_390396_);
        }
        catch (Exception $$2) {
            LOGGER.error("Failed to load texture {} into slot {}", new Object[]{p_390396_.resourceId(), p_390395_, $$2});
            return TextureContents.createMissing();
        }
    }

    public void registerForNextReload(ResourceLocation p_389634_) {
        this.register(p_389634_, new SimpleTexture(p_389634_));
    }

    public void register(ResourceLocation p_118496_, AbstractTexture p_118497_) {
        AbstractTexture $$2 = this.byPath.put(p_118496_, p_118497_);
        if ($$2 != p_118497_) {
            if ($$2 != null) {
                this.safeClose(p_118496_, $$2);
            }
            if (p_118497_ instanceof Tickable) {
                Tickable $$3 = (Tickable)((Object)p_118497_);
                this.tickableTextures.add($$3);
            }
        }
    }

    private void safeClose(ResourceLocation p_118509_, AbstractTexture p_118510_) {
        this.tickableTextures.remove(p_118510_);
        try {
            p_118510_.close();
        }
        catch (Exception $$2) {
            LOGGER.warn("Failed to close texture {}", (Object)p_118509_, (Object)$$2);
        }
    }

    public AbstractTexture getTexture(ResourceLocation p_118507_) {
        AbstractTexture $$1 = this.byPath.get(p_118507_);
        if ($$1 != null) {
            return $$1;
        }
        SimpleTexture $$2 = new SimpleTexture(p_118507_);
        this.registerAndLoad(p_118507_, $$2);
        return $$2;
    }

    @Override
    public void tick() {
        for (Tickable $$0 : this.tickableTextures) {
            $$0.tick();
        }
    }

    public void release(ResourceLocation p_118514_) {
        AbstractTexture $$1 = this.byPath.remove(p_118514_);
        if ($$1 != null) {
            this.safeClose(p_118514_, $$1);
        }
    }

    @Override
    public void close() {
        this.byPath.forEach(this::safeClose);
        this.byPath.clear();
        this.tickableTextures.clear();
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_118476_, ResourceManager p_118477_, Executor p_118480_, Executor p_118481_) {
        ArrayList $$4 = new ArrayList();
        this.byPath.forEach((p_389356_, p_389357_) -> {
            if (p_389357_ instanceof ReloadableTexture) {
                ReloadableTexture $$5 = (ReloadableTexture)p_389357_;
                $$4.add(TextureManager.scheduleLoad(p_118477_, p_389356_, $$5, p_118480_));
            }
        });
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])$$4.stream().map(PendingReload::newContents).toArray(CompletableFuture[]::new)).thenCompose(p_118476_::wait)).thenAcceptAsync(p_389351_ -> {
            AddRealmPopupScreen.updateCarouselImages(this.resourceManager);
            for (PendingReload $$2 : $$4) {
                $$2.texture.apply($$2.newContents.join());
            }
        }, p_118481_);
    }

    public void dumpAllSheets(Path p_276129_) {
        try {
            Files.createDirectories(p_276129_, new FileAttribute[0]);
        }
        catch (IOException $$1) {
            LOGGER.error("Failed to create directory {}", (Object)p_276129_, (Object)$$1);
            return;
        }
        this.byPath.forEach((p_276101_, p_276102_) -> {
            if (p_276102_ instanceof Dumpable) {
                Dumpable $$3 = (Dumpable)((Object)p_276102_);
                try {
                    $$3.dumpContents((ResourceLocation)p_276101_, p_276129_);
                }
                catch (IOException $$4) {
                    LOGGER.error("Failed to dump texture {}", p_276101_, (Object)$$4);
                }
            }
        });
    }

    private static TextureContents loadContents(ResourceManager p_389428_, ResourceLocation p_389405_, ReloadableTexture p_389480_) throws IOException {
        try {
            return p_389480_.loadContents(p_389428_);
        }
        catch (FileNotFoundException $$3) {
            if (p_389405_ != INTENTIONAL_MISSING_TEXTURE) {
                LOGGER.warn("Missing resource {} referenced from {}", (Object)p_389480_.resourceId(), (Object)p_389405_);
            }
            return TextureContents.createMissing();
        }
    }

    private static PendingReload scheduleLoad(ResourceManager p_389696_, ResourceLocation p_389555_, ReloadableTexture p_389691_, Executor p_389430_) {
        return new PendingReload(p_389691_, CompletableFuture.supplyAsync(() -> {
            try {
                return TextureManager.loadContents(p_389696_, p_389555_, p_389691_);
            }
            catch (IOException $$3) {
                throw new UncheckedIOException($$3);
            }
        }, p_389430_));
    }

    record PendingReload(ReloadableTexture texture, CompletableFuture<TextureContents> newContents) {
    }
}

