/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.slf4j.Logger;

public class SkinTextureDownloader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SKIN_WIDTH = 64;
    private static final int SKIN_HEIGHT = 64;
    private static final int LEGACY_SKIN_HEIGHT = 32;

    public static CompletableFuture<ResourceLocation> downloadAndRegisterSkin(ResourceLocation p_389586_, Path p_389600_, String p_389645_, boolean p_389477_) {
        return CompletableFuture.supplyAsync(() -> {
            void $$5;
            try {
                NativeImage $$3 = SkinTextureDownloader.downloadSkin(p_389600_, p_389645_);
            }
            catch (IOException $$4) {
                throw new UncheckedIOException($$4);
            }
            return p_389477_ ? SkinTextureDownloader.processLegacySkin((NativeImage)$$5, p_389645_) : $$5;
        }, Util.nonCriticalIoPool().forName("downloadTexture")).thenCompose(p_389457_ -> SkinTextureDownloader.registerTextureInManager(p_389586_, p_389457_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeImage downloadSkin(Path p_389493_, String p_389422_) throws IOException {
        if (Files.isRegularFile(p_389493_, new LinkOption[0])) {
            LOGGER.debug("Loading HTTP texture from local cache ({})", (Object)p_389493_);
            try (InputStream $$2 = Files.newInputStream(p_389493_, new OpenOption[0]);){
                NativeImage nativeImage = NativeImage.read($$2);
                return nativeImage;
            }
        }
        HttpURLConnection $$3 = null;
        LOGGER.debug("Downloading HTTP texture from {} to {}", (Object)p_389422_, (Object)p_389493_);
        URI $$4 = URI.create(p_389422_);
        try {
            $$3 = (HttpURLConnection)$$4.toURL().openConnection(Minecraft.getInstance().getProxy());
            $$3.setDoInput(true);
            $$3.setDoOutput(false);
            $$3.connect();
            int $$5 = $$3.getResponseCode();
            if ($$5 / 100 != 2) {
                throw new IOException("Failed to open " + String.valueOf($$4) + ", HTTP error code: " + $$5);
            }
            byte[] $$6 = $$3.getInputStream().readAllBytes();
            try {
                FileUtil.createDirectoriesSafe(p_389493_.getParent());
                Files.write(p_389493_, $$6, new OpenOption[0]);
            }
            catch (IOException $$7) {
                LOGGER.warn("Failed to cache texture {} in {}", (Object)p_389422_, (Object)p_389493_);
            }
            NativeImage nativeImage = NativeImage.read($$6);
            return nativeImage;
        }
        finally {
            if ($$3 != null) {
                $$3.disconnect();
            }
        }
    }

    private static CompletableFuture<ResourceLocation> registerTextureInManager(ResourceLocation p_389574_, NativeImage p_389628_) {
        Minecraft $$2 = Minecraft.getInstance();
        return CompletableFuture.supplyAsync(() -> {
            DynamicTexture $$3 = new DynamicTexture(p_389574_::toString, p_389628_);
            $$2.getTextureManager().register(p_389574_, $$3);
            return p_389574_;
        }, $$2);
    }

    private static NativeImage processLegacySkin(NativeImage p_389593_, String p_389622_) {
        boolean $$4;
        int $$2 = p_389593_.getHeight();
        int $$3 = p_389593_.getWidth();
        if ($$3 != 64 || $$2 != 32 && $$2 != 64) {
            p_389593_.close();
            throw new IllegalStateException("Discarding incorrectly sized (" + $$3 + "x" + $$2 + ") skin texture from " + p_389622_);
        }
        boolean bl = $$4 = $$2 == 32;
        if ($$4) {
            NativeImage $$5 = new NativeImage(64, 64, true);
            $$5.copyFrom(p_389593_);
            p_389593_.close();
            p_389593_ = $$5;
            p_389593_.fillRect(0, 32, 64, 32, 0);
            p_389593_.copyRect(4, 16, 16, 32, 4, 4, true, false);
            p_389593_.copyRect(8, 16, 16, 32, 4, 4, true, false);
            p_389593_.copyRect(0, 20, 24, 32, 4, 12, true, false);
            p_389593_.copyRect(4, 20, 16, 32, 4, 12, true, false);
            p_389593_.copyRect(8, 20, 8, 32, 4, 12, true, false);
            p_389593_.copyRect(12, 20, 16, 32, 4, 12, true, false);
            p_389593_.copyRect(44, 16, -8, 32, 4, 4, true, false);
            p_389593_.copyRect(48, 16, -8, 32, 4, 4, true, false);
            p_389593_.copyRect(40, 20, 0, 32, 4, 12, true, false);
            p_389593_.copyRect(44, 20, -8, 32, 4, 12, true, false);
            p_389593_.copyRect(48, 20, -16, 32, 4, 12, true, false);
            p_389593_.copyRect(52, 20, -8, 32, 4, 12, true, false);
        }
        SkinTextureDownloader.setNoAlpha(p_389593_, 0, 0, 32, 16);
        if ($$4) {
            SkinTextureDownloader.doNotchTransparencyHack(p_389593_, 32, 0, 64, 32);
        }
        SkinTextureDownloader.setNoAlpha(p_389593_, 0, 16, 64, 32);
        SkinTextureDownloader.setNoAlpha(p_389593_, 16, 48, 48, 64);
        return p_389593_;
    }

    private static void doNotchTransparencyHack(NativeImage p_389443_, int p_389442_, int p_389419_, int p_389424_, int p_389559_) {
        for (int $$5 = p_389442_; $$5 < p_389424_; ++$$5) {
            for (int $$6 = p_389419_; $$6 < p_389559_; ++$$6) {
                int $$7 = p_389443_.getPixel($$5, $$6);
                if (ARGB.alpha($$7) >= 128) continue;
                return;
            }
        }
        for (int $$8 = p_389442_; $$8 < p_389424_; ++$$8) {
            for (int $$9 = p_389419_; $$9 < p_389559_; ++$$9) {
                p_389443_.setPixel($$8, $$9, p_389443_.getPixel($$8, $$9) & 0xFFFFFF);
            }
        }
    }

    private static void setNoAlpha(NativeImage p_389456_, int p_389475_, int p_389579_, int p_389725_, int p_389657_) {
        for (int $$5 = p_389475_; $$5 < p_389725_; ++$$5) {
            for (int $$6 = p_389579_; $$6 < p_389657_; ++$$6) {
                p_389456_.setPixel($$5, $$6, ARGB.opaque(p_389456_.getPixel($$5, $$6)));
            }
        }
    }
}

