/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.TextureFormat;
import java.io.IOException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public abstract class ReloadableTexture
extends AbstractTexture {
    private final ResourceLocation resourceId;

    public ReloadableTexture(ResourceLocation p_389687_) {
        this.resourceId = p_389687_;
    }

    public ResourceLocation resourceId() {
        return this.resourceId;
    }

    public void apply(TextureContents p_389491_) {
        boolean $$1 = p_389491_.clamp();
        boolean $$2 = p_389491_.blur();
        try (NativeImage $$3 = p_389491_.image();){
            this.doLoad($$3, $$2, $$1);
        }
    }

    protected void doLoad(NativeImage p_389473_, boolean p_389455_, boolean p_389621_) {
        GpuDevice $$3 = RenderSystem.getDevice();
        this.close();
        this.texture = $$3.createTexture(this.resourceId::toString, 5, TextureFormat.RGBA8, p_389473_.getWidth(), p_389473_.getHeight(), 1, 1);
        this.textureView = $$3.createTextureView(this.texture);
        this.setFilter(p_389455_, false);
        this.setClamp(p_389621_);
        $$3.createCommandEncoder().writeToTexture(this.texture, p_389473_);
    }

    public abstract TextureContents loadContents(ResourceManager var1) throws IOException;
}

