/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class DynamicTexture
extends AbstractTexture
implements Dumpable {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private NativeImage pixels;

    public DynamicTexture(Supplier<String> p_404638_, NativeImage p_404902_) {
        this.pixels = p_404902_;
        this.createTexture(p_404638_);
        this.upload();
    }

    public DynamicTexture(String p_405039_, int p_405248_, int p_405417_, boolean p_405707_) {
        this.pixels = new NativeImage(p_405248_, p_405417_, p_405707_);
        this.createTexture(p_405039_);
    }

    public DynamicTexture(Supplier<String> p_405362_, int p_404897_, int p_404881_, boolean p_405310_) {
        this.pixels = new NativeImage(p_404897_, p_404881_, p_405310_);
        this.createTexture(p_405362_);
    }

    private void createTexture(Supplier<String> p_418333_) {
        GpuDevice $$1 = RenderSystem.getDevice();
        this.texture = $$1.createTexture(p_418333_, 5, TextureFormat.RGBA8, this.pixels.getWidth(), this.pixels.getHeight(), 1, 1);
        this.texture.setTextureFilter(FilterMode.NEAREST, false);
        this.textureView = $$1.createTextureView(this.texture);
    }

    private void createTexture(String p_418300_) {
        GpuDevice $$1 = RenderSystem.getDevice();
        this.texture = $$1.createTexture(p_418300_, 5, TextureFormat.RGBA8, this.pixels.getWidth(), this.pixels.getHeight(), 1, 1);
        this.texture.setTextureFilter(FilterMode.NEAREST, false);
        this.textureView = $$1.createTextureView(this.texture);
    }

    public void upload() {
        if (this.pixels != null && this.texture != null) {
            RenderSystem.getDevice().createCommandEncoder().writeToTexture(this.texture, this.pixels);
        } else {
            LOGGER.warn("Trying to upload disposed texture {}", (Object)this.getTexture().getLabel());
        }
    }

    @Nullable
    public NativeImage getPixels() {
        return this.pixels;
    }

    public void setPixels(NativeImage p_117989_) {
        if (this.pixels != null) {
            this.pixels.close();
        }
        this.pixels = p_117989_;
    }

    @Override
    public void close() {
        if (this.pixels != null) {
            this.pixels.close();
            this.pixels = null;
        }
        super.close();
    }

    @Override
    public void dumpContents(ResourceLocation p_276119_, Path p_276105_) throws IOException {
        if (this.pixels != null) {
            String $$2 = p_276119_.toDebugFileName() + ".png";
            Path $$3 = p_276105_.resolve($$2);
            this.pixels.writeToFile($$3);
        }
    }
}

